/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration;

import appeng.api.AEApi;
import appeng.api.storage.data.IAEItemStack;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.API;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IStackPositioner;
import codechicken.nei.recipe.IRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.network.packet.server.PacketServerArcaneCraftingTerminal;

public class ModuleNEI {
    private static final int NEI_SLOT_OFFSET_X = 25;
    private static final int NEI_SLOT_OFFSET_Y = 6;
    private static final int SLOT_INDEX_DIVISOR = 18;

    public ModuleNEI() throws Exception {
        API.registerGuiOverlay(GuiArcaneCraftingTerminal.class, (String)"crafting", (IStackPositioner)new ACTSlotFinder());
        ACTOverlayHandler overlayHandler = new ACTOverlayHandler();
        API.registerGuiOverlayHandler(GuiArcaneCraftingTerminal.class, (IOverlayHandler)overlayHandler, (String)"crafting");
    }

    public class ACTSlotFinder
    implements IStackPositioner {
        public ArrayList<PositionedStack> positionStacks(ArrayList<PositionedStack> stacks) {
            for (PositionedStack ps : stacks) {
                if (ps == null) continue;
                ps.relx += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_X_POS - 25;
                ps.rely += ContainerPartArcaneCraftingTerminal.CRAFTING_SLOT_Y_POS - 6;
            }
            return stacks;
        }
    }

    public class ACTOverlayHandler
    implements IOverlayHandler {
        public void overlayRecipe(GuiContainer gui, IRecipeHandler recipeHandler, int recipeIndex, boolean shift) {
            if (gui instanceof GuiArcaneCraftingTerminal) {
                IAEItemStack[] items = new IAEItemStack[9];
                boolean hasItems = false;
                List ingredients = recipeHandler.getIngredientStacks(recipeIndex);
                for (PositionedStack ingredient : ingredients) {
                    int slotX = (ingredient.relx - 25) / 18;
                    int slotY = (ingredient.rely - 6) / 18;
                    int slotIndex = slotX + slotY * 3;
                    items[slotIndex] = AEApi.instance().storage().createItemStack(ingredient.item);
                    hasItems = true;
                }
                if (hasItems) {
                    new PacketServerArcaneCraftingTerminal().createNEIRequestSetCraftingGrid((EntityPlayer)Minecraft.func_71410_x().field_71439_g, items).sendPacketToServer();
                }
            }
        }
    }
}

