/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.widget;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.gui.widget.AbstractAspectWidget;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.IWidgetHost;
import thaumicenergistics.network.IAspectSlotPart;
import thaumicenergistics.network.packet.server.PacketServerAspectSlot;
import thaumicenergistics.texture.GuiTextureManager;

public class WidgetAspectSlot
extends AbstractAspectWidget {
    private int id;
    private IAspectSlotPart part;
    private EntityPlayer player;
    private IConfigurable configurable;
    private byte configOption;

    public WidgetAspectSlot(IWidgetHost hostGui, EntityPlayer player, IAspectSlotPart part, int posX, int posY) {
        this(hostGui, player, part, 0, posX, posY, null, 0);
    }

    public WidgetAspectSlot(IWidgetHost hostGui, EntityPlayer player, IAspectSlotPart part, int id, int posX, int posY) {
        this(hostGui, player, part, id, posX, posY, null, 0);
    }

    public WidgetAspectSlot(IWidgetHost hostGui, EntityPlayer player, IAspectSlotPart part, int id, int posX, int posY, IConfigurable configurable, byte configOption) {
        super(hostGui, null, posX, posY, player);
        this.player = player;
        this.part = part;
        this.id = id;
        this.configurable = configurable;
        this.configOption = configOption;
    }

    public boolean canRender() {
        return this.configurable == null || this.configurable.getConfigState() >= this.configOption;
    }

    @Override
    public void drawWidget() {
        if (this.canRender()) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_IO_BUS.getTexture());
            this.func_73729_b(this.xPosition, this.yPosition, 79, 39, AbstractWidget.WIDGET_SIZE, AbstractWidget.WIDGET_SIZE);
            if (this.getAspect() != null) {
                this.drawAspect();
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        if (this.canRender() && this.getAspect() != null) {
            tooltip.add(this.aspectName);
        }
    }

    @Override
    public void mouseClicked() {
    }

    public void mouseClicked(Aspect withAspect) {
        this.setAspect(withAspect);
        new PacketServerAspectSlot().createUpdatePartAspect(this.part, this.id, this.getAspect(), this.player).sendPacketToServer();
    }

    public static interface IConfigurable {
        public byte getConfigState();
    }
}

