/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.buttons;

import appeng.api.config.ViewItems;
import appeng.core.localization.ButtonToolTips;
import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import thaumicenergistics.gui.buttons.AbstractAEButton;
import thaumicenergistics.texture.AEStateIconsEnum;

public class ButtonViewType
extends AbstractAEButton {
    private String tooltipViewType = "";

    public ButtonViewType(int ID, int xPosition, int yPosition, int width, int height) {
        super(ID, xPosition, yPosition, width, height, AEStateIconsEnum.VIEW_TYPE_ALL);
        this.setViewMode(ViewItems.ALL);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        this.addAboutToTooltip(tooltip, ButtonToolTips.View.getLocal(), EnumChatFormatting.GRAY + this.tooltipViewType);
    }

    public void setViewMode(ViewItems mode) {
        switch (mode) {
            case ALL: {
                this.tooltipViewType = ButtonToolTips.StoredCraftable.getLocal();
                this.icon = AEStateIconsEnum.VIEW_TYPE_ALL;
                break;
            }
            case CRAFTABLE: {
                this.tooltipViewType = ButtonToolTips.Craftable.getLocal();
                this.icon = AEStateIconsEnum.VIEW_TYPE_CRAFT;
                break;
            }
            case STORED: {
                this.tooltipViewType = ButtonToolTips.StoredItems.getLocal();
                this.icon = AEStateIconsEnum.VIEW_TYPE_STORED;
            }
        }
    }
}

