/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui.buttons;

import appeng.api.config.RedstoneMode;
import java.util.List;
import net.minecraft.util.StatCollector;
import thaumicenergistics.gui.buttons.AbstractAEButton;
import thaumicenergistics.texture.AEStateIconsEnum;

public class ButtonRedstoneModes
extends AbstractAEButton {
    private static final String TOOLTIP_LOC_HEADER = "gui.tooltips.appliedenergistics2.";
    private RedstoneMode redstoneMode;
    private boolean emitter = false;

    public ButtonRedstoneModes(int ID, int xPos, int yPos, int width, int height, RedstoneMode mode) {
        this(ID, xPos, yPos, width, height, mode, false);
    }

    public ButtonRedstoneModes(int ID, int xPos, int yPos, int width, int height, RedstoneMode mode, boolean emitter) {
        super(ID, xPos, yPos, width, height, (AEStateIconsEnum)null);
        this.emitter = emitter;
        this.setRedstoneMode(mode);
    }

    @Override
    public void getTooltip(List<String> tooltip) {
        String explanation = "";
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                explanation = StatCollector.func_74838_a((String)(this.emitter ? "gui.tooltips.appliedenergistics2.EmitLevelAbove" : "gui.tooltips.appliedenergistics2.ActiveWithSignal"));
                break;
            }
            case IGNORE: {
                explanation = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.AlwaysActive");
                break;
            }
            case LOW_SIGNAL: {
                explanation = StatCollector.func_74838_a((String)(this.emitter ? "gui.tooltips.appliedenergistics2.EmitLevelsBelow" : "gui.tooltips.appliedenergistics2.ActiveWithoutSignal"));
                break;
            }
            case SIGNAL_PULSE: {
                explanation = StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.ActiveOnPulse");
            }
        }
        this.addAboutToTooltip(tooltip, StatCollector.func_74838_a((String)"gui.tooltips.appliedenergistics2.RedstoneMode"), explanation);
    }

    public void setRedstoneMode(RedstoneMode mode) {
        this.redstoneMode = mode;
        switch (this.redstoneMode) {
            case HIGH_SIGNAL: {
                this.icon = AEStateIconsEnum.REDSTONE_HIGH;
                break;
            }
            case IGNORE: {
                this.icon = AEStateIconsEnum.REDSTONE_IGNORE;
                break;
            }
            case LOW_SIGNAL: {
                this.icon = AEStateIconsEnum.REDSTONE_LOW;
                break;
            }
            case SIGNAL_PULSE: {
                this.icon = AEStateIconsEnum.REDSTONE_PULSE;
            }
        }
    }
}

