/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import appeng.api.config.RedstoneMode;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.container.ContainerPartEssentiaLevelEmitter;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.gui.buttons.ButtonRedstoneModes;
import thaumicenergistics.gui.widget.DigitTextField;
import thaumicenergistics.gui.widget.IWidgetHost;
import thaumicenergistics.gui.widget.WidgetAspectSlot;
import thaumicenergistics.integration.tc.EssentiaItemContainerHelper;
import thaumicenergistics.network.IAspectSlotGui;
import thaumicenergistics.network.packet.server.PacketServerEssentiaEmitter;
import thaumicenergistics.parts.AEPartEssentiaLevelEmitter;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.texture.GuiTextureManager;

@SideOnly(value=Side.CLIENT)
public class GuiEssentiaLevelEmitter
extends AbstractGuiBase
implements IAspectSlotGui {
    private static final String[] BUTTON_LABELS = new String[]{"-1", "-10", "-100", "+1", "+10", "+100"};
    private static final String[] BUTTON_LABELS_SHIFTED = new String[]{"-100", "-1000", "-10000", "+100", "+1000", "+10000"};
    private static final int GUI_WIDTH = 176;
    private static final int GUI_HEIGHT = 184;
    private static final int REDSTONE_MODE_BUTTON_INDEX = 6;
    private static final int TITLE_POS_X = 8;
    private static final int TITLE_POS_Y = 5;
    private static final int AMOUNT_OFFSET_X = 25;
    private static final int AMOUNT_OFFSET_Y = 44;
    private static final int AMOUNT_WIDTH = 80;
    private static final int AMOUNT_HEIGHT = 10;
    private static final int BUTTON_PADDING_HORZ = 8;
    private static final int BUTTON_PADDING_VERT = 22;
    private static final int BUTTON_POS_X = 15;
    private static final int BUTTON_POS_Y = 17;
    private static final int BUTTON_WIDTH = 42;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_ROWS = 2;
    private static final int BUTTON_COLUMNS = 3;
    private static final int REDSTONE_BUTTON_POS_X = -18;
    private static final int REDSTONE_BUTTON_POS_Y = 2;
    private static final int REDSTONE_BUTTON_SIZE = 16;
    private static final int FILTER_WIDGET_POS_X = 123;
    private static final int FILTER_WIDGET_POS_Y = 39;
    private static final int AMOUNT_MAX_CHARS = 10;
    private DigitTextField amountField;
    private AEPartEssentiaLevelEmitter part;
    private EntityPlayer player;
    private WidgetAspectSlot aspectFilterSlot;

    public GuiEssentiaLevelEmitter(AEPartEssentiaLevelEmitter part, EntityPlayer player) {
        super(new ContainerPartEssentiaLevelEmitter(part, player));
        this.player = player;
        this.part = part;
        this.aspectFilterSlot = new WidgetAspectSlot((IWidgetHost)this, this.player, this.part, 123, 39);
        this.field_146999_f = 176;
        this.field_147000_g = 184;
    }

    @Override
    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ESSENTIA_LEVEL_EMITTER.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 184);
    }

    protected void func_73869_a(char key, int keyID) {
        super.func_73869_a(key, keyID);
        if (Character.isDigit(key) && this.amountField.func_146179_b().length() < 10 || keyID == 14) {
            this.amountField.func_146201_a(key, keyID);
            long wantedAmount = 0L;
            try {
                wantedAmount = Long.parseLong(this.amountField.func_146179_b());
            }
            catch (NumberFormatException _) {
                // empty catch block
            }
            new PacketServerEssentiaEmitter().createWantedAmountUpdate(wantedAmount, this.part, this.player).sendPacketToServer();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        if (this.aspectFilterSlot.isMouseOverWidget(mouseX, mouseY)) {
            this.aspectFilterSlot.mouseClicked(EssentiaItemContainerHelper.instance.getAspectInContainer(this.player.field_71071_by.func_70445_o()));
        }
    }

    public void func_146284_a(GuiButton button) {
        int index = button.field_146127_k;
        if (index >= 0 && index < BUTTON_LABELS.length) {
            try {
                int adjustment = Integer.parseInt(button.field_146126_j);
                new PacketServerEssentiaEmitter().createWantedAmountAdjustment(adjustment, this.part, this.player).sendPacketToServer();
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (index == 6) {
            new PacketServerEssentiaEmitter().createRedstoneModeToggle(this.part, this.player).sendPacketToServer();
        }
    }

    public void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(AEPartsEnum.EssentiaLevelEmitter.getLocalizedName(), 8, 5, 0);
        if (this.aspectFilterSlot.isMouseOverWidget(mouseX, mouseY)) {
            this.aspectFilterSlot.drawMouseHoverUnderlay();
            this.aspectFilterSlot.getTooltip(this.tooltip);
        }
        this.aspectFilterSlot.drawWidget();
        this.amountField.func_146194_f();
        if (this.tooltip.size() == 0) {
            this.addTooltipFromButtons(mouseX, mouseY);
        }
        if (this.tooltip.size() > 0) {
            this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
        }
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        int count = BUTTON_LABELS.length;
        for (int buttonIndex = 0; buttonIndex < count; ++buttonIndex) {
            GuiButton currentButton = (GuiButton)this.field_146292_n.get(buttonIndex);
            currentButton.field_146126_j = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? BUTTON_LABELS_SHIFTED[buttonIndex] : BUTTON_LABELS[buttonIndex];
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        this.amountField = new DigitTextField(this.field_146289_q, 25, 44, 80, 10);
        this.amountField.func_146195_b(true);
        this.amountField.func_146185_a(false);
        this.amountField.func_146193_g(-1);
        this.field_146292_n.clear();
        for (int row = 0; row < 2; ++row) {
            int yPos = this.field_147009_r + 17 + row * 42;
            for (int column = 0; column < 3; ++column) {
                int buttonIndex = row * 3 + column;
                int xPos = this.field_147003_i + 15 + column * 50;
                this.field_146292_n.add(new GuiButton(buttonIndex, xPos, yPos, 42, 20, BUTTON_LABELS[buttonIndex]));
            }
        }
        this.field_146292_n.add(new ButtonRedstoneModes(6, this.field_147003_i + -18, this.field_147009_r + 2, 16, 16, RedstoneMode.LOW_SIGNAL, true));
        new PacketServerEssentiaEmitter().createUpdateRequest(this.part, this.player).sendPacketToServer();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void onServerUpdateRedstoneMode(RedstoneMode mode) {
        ((ButtonRedstoneModes)((Object)this.field_146292_n.get(6))).setRedstoneMode(mode);
    }

    public void onServerUpdateWantedAmount(long amount) {
        this.amountField.func_146180_a(Long.toString(amount));
    }

    public boolean setFilteredAspectFromItemstack(ItemStack itemStack) {
        Aspect itemAspect = EssentiaItemContainerHelper.instance.getAspectInContainer(itemStack);
        if (itemAspect != null) {
            this.aspectFilterSlot.setAspect(itemAspect);
            return true;
        }
        return false;
    }

    @Override
    public void updateAspects(List<Aspect> aspectList) {
        if (aspectList == null || aspectList.isEmpty()) {
            this.aspectFilterSlot.setAspect(null);
        } else {
            this.aspectFilterSlot.setAspect(aspectList.get(0));
        }
    }
}

