/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.me.ItemRepo;
import appeng.client.render.AppEngRenderItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.config.Config;
import thaumicenergistics.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.gui.abstraction.AbstractGuiConstantsACT;
import thaumicenergistics.gui.abstraction.AbstractGuiWithScrollbar;
import thaumicenergistics.gui.buttons.ButtonClearCraftingGrid;
import thaumicenergistics.gui.buttons.ButtonSortingDirection;
import thaumicenergistics.gui.buttons.ButtonSortingMode;
import thaumicenergistics.gui.buttons.ButtonViewType;
import thaumicenergistics.gui.widget.AbstractWidget;
import thaumicenergistics.gui.widget.WidgetAEItem;
import thaumicenergistics.integration.tc.MEItemAspectBridgeContainer;
import thaumicenergistics.network.packet.server.PacketServerArcaneCraftingTerminal;
import thaumicenergistics.parts.AEPartArcaneCraftingTerminal;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.texture.AEStateIconsEnum;
import thaumicenergistics.texture.GuiTextureManager;
import thaumicenergistics.util.GuiHelper;

@SideOnly(value=Side.CLIENT)
public class GuiArcaneCraftingTerminal
extends AbstractGuiConstantsACT
implements ISortSource {
    private AppEngRenderItem aeItemRenderer = new AppEngRenderItem();
    private String guiTitle;
    private WidgetAEItem[] itemWidgets = new WidgetAEItem[27];
    private EntityPlayer player;
    private GuiTextField searchField;
    private final ItemRepo repo;
    private SortOrder sortingOrder = SortOrder.NAME;
    private SortDir sortingDirection = SortDir.ASCENDING;
    private ViewItems viewMode = ViewItems.ALL;
    private int previousMouseX = 0;
    private int previousMouseY = 0;
    private WidgetAEItem previousWidgetUnderMouse = null;
    private long lastTooltipUpdateTime = 0L;
    private MEItemAspectBridgeContainer meAspectBridge;

    public GuiArcaneCraftingTerminal(AEPartArcaneCraftingTerminal part, EntityPlayer player) {
        super(new ContainerPartArcaneCraftingTerminal(part, player));
        this.player = player;
        this.field_146999_f = 230;
        this.field_147000_g = 243;
        this.guiTitle = ThEStrings.Gui_TitleArcaneCraftingTerminal.getLocalized();
        try {
            this.meAspectBridge = new MEItemAspectBridgeContainer(27);
        }
        catch (Exception e) {
            this.meAspectBridge = null;
        }
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int index = row * 9 + column;
                int posX = 7 + column * AbstractWidget.WIDGET_SIZE;
                int posY = 17 + row * AbstractWidget.WIDGET_SIZE;
                this.itemWidgets[index] = new WidgetAEItem(this, posX, posY, this.aeItemRenderer);
                if (this.meAspectBridge == null) continue;
                this.meAspectBridge.addSlot(index, posX, posY);
            }
        }
        this.repo = new ItemRepo((IScrollSource)this.scrollBar, (ISortSource)this);
    }

    private void doMEWheelAction(int deltaZ) {
        int mouseY;
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (GuiHelper.instance.isPointInGuiRegion(17, 7, 53, 161, mouseX, mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1, this.field_147003_i, this.field_147009_r)) {
            if (deltaZ > 0) {
                if (this.player.field_71071_by.func_70445_o() != null) {
                    new PacketServerArcaneCraftingTerminal().createRequestDeposit(this.player, -2).sendPacketToServer();
                }
            } else {
                this.sendItemWidgetClicked(mouseX, mouseY, -2);
            }
        }
    }

    private void drawCraftingAspects(List<ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost> craftingCost) {
        int posY = 90;
        int column = 0;
        for (ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost cost : craftingCost) {
            float alpha = 1.0f;
            if (!cost.hasEnoughVis) {
                alpha = GuiHelper.instance.pingPongFromTime(0.5, 0.25f, 0.75f);
            }
            int posX = 136 + column * 18;
            UtilsFX.drawTag((int)posX, (int)posY, (Aspect)cost.primal, (float)cost.visCost, (int)0, (double)this.field_73735_i, (int)771, (float)alpha, (boolean)false);
            if (++column != 2) continue;
            column = 0;
            posY += 18;
        }
    }

    private WidgetAEItem drawItemWidgets(int mouseX, int mouseY) {
        boolean hasNoOverlay = true;
        WidgetAEItem widgetUnderMouse = null;
        for (int index = 0; index < 27; ++index) {
            WidgetAEItem currentWidget = this.itemWidgets[index];
            currentWidget.drawWidget();
            if (!hasNoOverlay || !currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            currentWidget.drawMouseHoverUnderlay();
            hasNoOverlay = false;
            widgetUnderMouse = currentWidget;
        }
        return widgetUnderMouse;
    }

    private void sendItemWidgetClicked(int mouseX, int mouseY, int mouseButton) {
        for (int index = 0; index < 27; ++index) {
            WidgetAEItem currentWidget = this.itemWidgets[index];
            if (!currentWidget.isMouseOverWidget(mouseX, mouseY)) continue;
            IAEItemStack widgetStack = currentWidget.getItemStack();
            if (widgetStack != null) {
                if (widgetStack.getStackSize() == 0L) {
                    if (widgetStack.isCraftable()) {
                        // empty if block
                    }
                } else {
                    boolean isShiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    new PacketServerArcaneCraftingTerminal().createRequestExtract(this.player, widgetStack, mouseButton, isShiftHeld).sendPacketToServer();
                }
            }
            return;
        }
    }

    private void updateMEWidgets() {
        int repoIndex = 0;
        for (int index = 0; index < 27; ++index) {
            IAEItemStack stack;
            if ((stack = this.repo.getReferenceItem(repoIndex++)) != null) {
                if (stack.getStackSize() == 0L) {
                    --index;
                    continue;
                }
                this.itemWidgets[index].setItemStack(stack);
                if (this.meAspectBridge == null) continue;
                this.meAspectBridge.setSlot(index, stack.getItemStack().func_77946_l());
                continue;
            }
            this.itemWidgets[index].setItemStack(null);
            if (this.meAspectBridge == null) continue;
            this.meAspectBridge.setSlot(index, null);
        }
    }

    private void updateScrollMaximum() {
        int max = Math.max(0, this.repo.size() / 9 - 2);
        this.scrollBar.setRange(0, max, 2);
    }

    private void updateSorting() {
        ((ButtonSortingDirection)((Object)this.field_146292_n.get(2))).setSortingDirection(this.sortingDirection);
        ((ButtonSortingMode)((Object)this.field_146292_n.get(1))).setSortMode(this.sortingOrder);
        ((ButtonViewType)((Object)this.field_146292_n.get(3))).setViewMode(this.viewMode);
        this.repo.updateView();
        this.updateMEWidgets();
    }

    @Override
    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(GuiTextureManager.ARCANE_CRAFTING_TERMINAL.getTexture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 230, 243);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AEStateIconsEnum.AE_STATES_TEXTURE);
        int u = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getU();
        int v = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getV();
        int h = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getHeight();
        int w = AEStateIconsEnum.VIEW_CELL_BACKGROUND.getWidth();
        int x = this.field_147003_i + ContainerPartArcaneCraftingTerminal.VIEW_SLOT_XPOS;
        int y = this.field_147009_r + ContainerPartArcaneCraftingTerminal.VIEW_SLOT_YPOS;
        for (int row = 0; row < 5; ++row) {
            this.func_73729_b(x, y + row * 18, u, v, w, h);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        boolean forceTooltipUpdate;
        super.func_146979_b(mouseX, mouseY);
        this.field_146289_q.func_78276_b(this.guiTitle, 8, 6, 0);
        this.searchField.func_146194_f();
        GL11.glEnable((int)2896);
        WidgetAEItem widgetUnderMouse = this.drawItemWidgets(mouseX, mouseY);
        List<ContainerPartArcaneCraftingTerminal.ArcaneCrafingCost> craftingCost = ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).getCraftingCost();
        if (craftingCost != null) {
            this.drawCraftingAspects(craftingCost);
        }
        boolean bl = forceTooltipUpdate = System.currentTimeMillis() - this.lastTooltipUpdateTime >= 3000L;
        if (forceTooltipUpdate || this.previousMouseX != mouseX || this.previousMouseY != mouseY) {
            if (widgetUnderMouse != null) {
                if (forceTooltipUpdate || widgetUnderMouse != this.previousWidgetUnderMouse) {
                    this.tooltip.clear();
                    widgetUnderMouse.getTooltip(this.tooltip);
                    this.lastTooltipUpdateTime = System.currentTimeMillis();
                }
            } else {
                this.tooltip.clear();
                this.lastTooltipUpdateTime = System.currentTimeMillis();
                this.addTooltipFromButtons(mouseX, mouseY);
            }
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
            this.previousWidgetUnderMouse = widgetUnderMouse;
        }
        this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, false);
    }

    @Override
    protected AbstractGuiWithScrollbar.ScrollbarParams getScrollbarParameters() {
        return new AbstractGuiWithScrollbar.ScrollbarParams(this, 175, 18, 52);
    }

    @Override
    protected void func_73869_a(char key, int keyID) {
        if (keyID == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (this.searchField.func_146206_l()) {
            this.searchField.func_146201_a(key, keyID);
            String newSearch = this.searchField.func_146179_b().trim().toLowerCase();
            if (!newSearch.equals(this.repo.searchString)) {
                this.repo.searchString = newSearch;
                this.repo.updateView();
                this.updateScrollMaximum();
                this.updateMEWidgets();
            }
        } else {
            super.func_73869_a(key, keyID);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        Slot slotClicked;
        if (GuiHelper.instance.isPointInGuiRegion(17, 7, 53, 161, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            if (this.player.field_71071_by.func_70445_o() != null) {
                new PacketServerArcaneCraftingTerminal().createRequestDeposit(this.player, mouseButton).sendPacketToServer();
            } else {
                this.sendItemWidgetClicked(mouseX, mouseY, mouseButton);
            }
            return;
        }
        if (Keyboard.isKeyDown((int)57) && (slotClicked = this.func_146975_c(mouseX, mouseY)) != null) {
            new PacketServerArcaneCraftingTerminal().createRequestDepositRegion(this.player, slotClicked.field_75222_d).sendPacketToServer();
            return;
        }
        if (mouseButton == 1 && GuiHelper.instance.isPointInGuiRegion(6, 98, 10, 65, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) {
            this.searchField.func_146180_a("");
            this.repo.searchString = "";
            this.repo.updateView();
            this.updateMEWidgets();
            this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
            return;
        }
        this.searchField.func_146192_a(mouseX - this.field_147003_i, mouseY - this.field_147009_r, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    protected void onScrollbarMoved() {
        this.updateMEWidgets();
    }

    public void func_146284_a(GuiButton button) {
        boolean sortingChanged = false;
        switch (button.field_146127_k) {
            case 0: {
                new PacketServerArcaneCraftingTerminal().createRequestClearGrid(this.player).sendPacketToServer();
                break;
            }
            case 1: {
                switch (this.sortingOrder) {
                    case AMOUNT: {
                        this.sortingOrder = SortOrder.MOD;
                        break;
                    }
                    case INVTWEAKS: {
                        break;
                    }
                    case MOD: {
                        this.sortingOrder = SortOrder.NAME;
                        break;
                    }
                    case NAME: {
                        this.sortingOrder = SortOrder.AMOUNT;
                    }
                }
                sortingChanged = true;
                break;
            }
            case 2: {
                switch (this.sortingDirection) {
                    case ASCENDING: {
                        this.sortingDirection = SortDir.DESCENDING;
                        break;
                    }
                    case DESCENDING: {
                        this.sortingDirection = SortDir.ASCENDING;
                    }
                }
                sortingChanged = true;
                break;
            }
            case 3: {
                switch (this.viewMode) {
                    case ALL: {
                        this.viewMode = ViewItems.STORED;
                        break;
                    }
                    case STORED: {
                        this.viewMode = ViewItems.CRAFTABLE;
                        break;
                    }
                    case CRAFTABLE: {
                        this.viewMode = ViewItems.ALL;
                    }
                }
                sortingChanged = true;
            }
        }
        if (sortingChanged) {
            this.updateSorting();
            this.lastTooltipUpdateTime = 0L;
            new PacketServerArcaneCraftingTerminal().createRequestSetSort(this.player, this.sortingOrder, this.sortingDirection, this.viewMode).sendPacketToServer();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float mouseBtn) {
        super.func_73863_a(mouseX, mouseY, mouseBtn);
        if (this.meAspectBridge != null && !Config.showTags == Keyboard.isKeyDown((int)42)) {
            this.meAspectBridge.renderAspects(this, this.player);
        }
    }

    public Enum getSortBy() {
        return this.sortingOrder;
    }

    public Enum getSortDir() {
        return this.sortingDirection;
    }

    public Enum getSortDisplay() {
        return this.viewMode;
    }

    public void func_146274_d() {
        super.func_146274_d();
        int deltaZ = Mouse.getEventDWheel();
        if (deltaZ != 0) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.doMEWheelAction(deltaZ);
            } else {
                this.scrollBar.wheel(deltaZ);
                this.updateMEWidgets();
            }
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        Mouse.getDWheel();
        Keyboard.enableRepeatEvents((boolean)true);
        this.searchField = new GuiTextField(this.field_146289_q, 98, 6, 65, 10);
        this.searchField.func_146185_a(false);
        this.searchField.func_146195_b(false);
        this.searchField.func_146203_f(15);
        this.field_146292_n.clear();
        this.field_146292_n.add(new ButtonClearCraftingGrid(0, this.field_147003_i + 98, this.field_147009_r + 89, 8, 8));
        this.field_146292_n.add(new ButtonSortingMode(1, this.field_147003_i + -18, this.field_147009_r + 8, 16, 16));
        this.field_146292_n.add(new ButtonSortingDirection(2, this.field_147003_i + -18, this.field_147009_r + 28, 16, 16));
        this.field_146292_n.add(new ButtonViewType(3, this.field_147003_i + -18, this.field_147009_r + 48, 16, 16));
        ((ContainerPartArcaneCraftingTerminal)this.field_147002_h).registerForUpdates();
        new PacketServerArcaneCraftingTerminal().createRequestFullList(this.player).sendPacketToServer();
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void onReceiveChange(IAEItemStack change) {
        this.repo.postUpdate(change);
        this.repo.updateView();
        this.updateScrollMaximum();
        this.updateMEWidgets();
    }

    public void onReceiveFullList(IItemList<IAEItemStack> itemList) {
        for (IAEItemStack stack : itemList) {
            this.repo.postUpdate(stack);
        }
        this.repo.updateView();
        this.updateScrollMaximum();
        this.updateMEWidgets();
    }

    public void onReceivePlayerHeld(IAEItemStack heldItemstack) {
        ItemStack itemStack = null;
        if (heldItemstack != null) {
            itemStack = heldItemstack.getItemStack();
        }
        this.player.field_71071_by.func_70437_b(itemStack);
    }

    public void onReceiveSorting(SortOrder order, SortDir direction, ViewItems viewMode) {
        this.sortingDirection = direction;
        this.sortingOrder = order;
        this.viewMode = viewMode;
        this.updateSorting();
    }

    public void onViewCellsChanged(ItemStack[] viewCells) {
        this.repo.setViewCell(viewCells);
        this.updateMEWidgets();
        this.updateScrollMaximum();
    }
}

