/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.gui;

import java.util.Dictionary;
import java.util.Hashtable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumicenergistics.container.ContainerArcaneAssembler;
import thaumicenergistics.gui.abstraction.AbstractGuiBase;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.texture.GuiTextureManager;
import thaumicenergistics.tileentities.TileArcaneAssembler;
import thaumicenergistics.util.GuiHelper;

public class GuiArcaneAssembler
extends AbstractGuiBase {
    private static final int FULL_GUI_WIDTH = 247;
    private static final int MAIN_GUI_WIDTH = 176;
    private static final int UPGRADE_GUI_WIDTH = 58;
    private static final int GUI_HEIGHT = 197;
    private static final int UPGRADE_GUI_HEIGHT = 104;
    private static final int TITLE_POS_X = 6;
    private static final int TITLE_POS_Y = 6;
    private static final int VIS_EMPTY_Y = 87;
    private static final int VIS_FULL_Y = 202;
    private static final int VIS_BAR_HEIGHT = 16;
    private static final int VIS_BAR_WIDTH = 4;
    private String title;
    private Dictionary<Aspect, Integer> visBarPositionMap = new Hashtable<Aspect, Integer>();
    private boolean hasNetworkTool = false;
    private Aspect progressAspect = Aspect.MECHANISM;

    public GuiArcaneAssembler(EntityPlayer player, World world, int X, int Y, int Z) {
        super(new ContainerArcaneAssembler(player, world, X, Y, Z));
        this.hasNetworkTool = ((ContainerArcaneAssembler)this.field_147002_h).hasNetworkTool();
        this.field_146999_f = this.hasNetworkTool ? 247 : 234;
        this.field_147000_g = 197;
        this.title = ThEStrings.Gui_TitleArcaneAssembler.getLocalized();
        this.visBarPositionMap.put(Aspect.AIR, 41);
        this.visBarPositionMap.put(Aspect.WATER, 59);
        this.visBarPositionMap.put(Aspect.FIRE, 77);
        this.visBarPositionMap.put(Aspect.ORDER, 95);
        this.visBarPositionMap.put(Aspect.ENTROPY, 113);
        this.visBarPositionMap.put(Aspect.EARTH, 131);
        this.visBarPositionMap.put(this.progressAspect, 149);
    }

    private void drawVisBar(Aspect aspect, float percent) {
        int height = (int)Math.floor(percent * 16.0f);
        if (height > 0) {
            int xuPos = this.visBarPositionMap.get(aspect);
            int yPos = 87 + (16 - height);
            int vPos = 202 + (16 - height);
            this.func_73729_b(this.field_147003_i + xuPos, this.field_147009_r + yPos, xuPos, vPos, 4, height);
        }
    }

    @Override
    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiTextureManager.ARCANE_ASSEMBLER.getTexture());
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        } else {
            this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, this.field_147000_g);
            this.func_73729_b(this.field_147003_i + 176, this.field_147009_r, 176, 0, 58, 104);
        }
        AspectList storedVis = ((ContainerArcaneAssembler)this.field_147002_h).assembler.getStoredVis();
        for (Aspect aspect : TileArcaneAssembler.PRIMALS) {
            float percent = (float)storedVis.getAmount(aspect) / 1500.0f;
            this.drawVisBar(aspect, percent);
        }
        this.drawVisBar(this.progressAspect, ((ContainerArcaneAssembler)this.field_147002_h).assembler.getPercentComplete());
        super.func_146976_a(alpha, mouseX, mouseY);
    }

    public void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, 6, 6, 0);
        for (Aspect aspect : TileArcaneAssembler.PRIMALS) {
            int left = this.visBarPositionMap.get(aspect);
            if (!GuiHelper.instance.isPointInGuiRegion(87, left, 16, 4, mouseX, mouseY, this.field_147003_i, this.field_147009_r)) continue;
            this.tooltip.add(GuiHelper.instance.getAspectChatColor(aspect) + StringUtils.capitalize((String)aspect.getTag()));
            int amount = ((ContainerArcaneAssembler)this.field_147002_h).assembler.getStoredVis().getAmount(aspect);
            this.tooltip.add(Float.toString((float)amount / 10.0f) + " / 150");
            float discount = ((ContainerArcaneAssembler)this.field_147002_h).assembler.getVisDiscountForAspect(aspect);
            this.tooltip.add(String.format("%.0f%% %s", Float.valueOf(discount * 100.0f), StatCollector.func_74838_a((String)"tc.vis.costavg")));
            this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, true);
            break;
        }
    }
}

