/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.container;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerWithPlayerInventory
extends Container {
    private static int ROWS = 3;
    private static int COLUMNS = 9;
    protected static final int SLOT_SIZE = 18;
    private static final int INVENTORY_X_OFFSET = 8;
    private int firstPlayerSlotNumber = -1;
    private int lastPlayerSlotNumber = -1;
    private int firstHotbarSlotNumber = -1;
    private int lastHotbarSlotNumber = -1;

    protected final boolean mergeSlotWithHotbarInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.firstHotbarSlotNumber, this.lastHotbarSlotNumber + 1, false);
    }

    protected final boolean mergeSlotWithPlayerInventory(ItemStack slotStack) {
        return this.func_75135_a(slotStack, this.firstPlayerSlotNumber, this.lastPlayerSlotNumber + 1, false);
    }

    protected final boolean slotClickedWasInHotbarInventory(int slotNumber) {
        return slotNumber >= this.firstHotbarSlotNumber && slotNumber <= this.lastHotbarSlotNumber;
    }

    protected final boolean slotClickedWasInPlayerInventory(int slotNumber) {
        return slotNumber >= this.firstPlayerSlotNumber && slotNumber <= this.lastPlayerSlotNumber;
    }

    protected final boolean swapSlotInventoryHotbar(int slotNumber, ItemStack slotStack) {
        if (this.slotClickedWasInHotbarInventory(slotNumber)) {
            return this.mergeSlotWithPlayerInventory(slotStack);
        }
        if (this.slotClickedWasInPlayerInventory(slotNumber)) {
            return this.mergeSlotWithHotbarInventory(slotStack);
        }
        return false;
    }

    public final void bindPlayerInventory(IInventory playerInventory, int inventoryOffsetY, int hotbarPositionY) {
        Slot hotbarSlot = null;
        for (int column = 0; column < COLUMNS; ++column) {
            hotbarSlot = new Slot(playerInventory, column, 8 + column * 18, hotbarPositionY);
            this.func_75146_a(hotbarSlot);
            if (column != 0) continue;
            this.firstHotbarSlotNumber = hotbarSlot.field_75222_d;
        }
        if (hotbarSlot != null) {
            this.lastHotbarSlotNumber = hotbarSlot.field_75222_d;
        }
        Slot inventorySlot = null;
        for (int row = 0; row < ROWS; ++row) {
            for (int column = 0; column < COLUMNS; ++column) {
                inventorySlot = new Slot(playerInventory, COLUMNS + (column + row * COLUMNS), 8 + column * 18, row * 18 + inventoryOffsetY);
                this.func_75146_a(inventorySlot);
                if (row + column != 0) continue;
                this.firstPlayerSlotNumber = inventorySlot.field_75222_d;
            }
        }
        if (inventorySlot != null) {
            this.lastPlayerSlotNumber = inventorySlot.field_75222_d;
        }
    }

    public final List<Slot> getNonEmptySlotsFromHotbar() {
        ArrayList<Slot> hSlots = new ArrayList<Slot>();
        for (int slotNumber = this.firstHotbarSlotNumber; slotNumber <= this.lastHotbarSlotNumber; ++slotNumber) {
            Slot hSlot = this.func_75139_a(slotNumber);
            if (!hSlot.func_75216_d()) continue;
            hSlots.add(hSlot);
        }
        return hSlots;
    }

    public final List<Slot> getNonEmptySlotsFromPlayerInventory() {
        ArrayList<Slot> pSlots = new ArrayList<Slot>();
        for (int slotNumber = this.firstPlayerSlotNumber; slotNumber <= this.lastPlayerSlotNumber; ++slotNumber) {
            Slot pSlot = this.func_75139_a(slotNumber);
            if (!pSlot.func_75216_d()) continue;
            pSlots.add(pSlot);
        }
        return pSlots;
    }
}

