/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.aspect;

import java.util.Comparator;
import thaumicenergistics.aspect.AspectStack;

public class AspectStackComparator
implements Comparator<AspectStack> {
    private ComparatorMode mode;

    public AspectStackComparator() {
        this(ComparatorMode.MODE_ALPHABETIC);
    }

    public AspectStackComparator(ComparatorMode mode) {
        this.mode = mode;
    }

    private int compareByAmount(AspectStack left, AspectStack right) {
        return (int)(right.amount - left.amount);
    }

    private int compareByTag(AspectStack left, AspectStack right) {
        return left.aspect.getTag().compareTo(right.aspect.getTag());
    }

    @Override
    public int compare(AspectStack left, AspectStack right) {
        switch (this.mode) {
            case MODE_ALPHABETIC: {
                return this.compareByTag(left, right);
            }
            case MODE_AMOUNT: {
                int comparedAmounts = this.compareByAmount(left, right);
                if (comparedAmounts == 0) {
                    comparedAmounts = this.compareByTag(left, right);
                }
                return comparedAmounts;
            }
        }
        return 0;
    }

    public static enum ComparatorMode {
        MODE_ALPHABETIC,
        MODE_AMOUNT;

        public static final ComparatorMode[] VALUES;

        static {
            VALUES = ComparatorMode.values();
        }
    }
}

