/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client;

import cofh.api.tileentity.IRedstoneControl;
import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabRedstone;
import cofh.core.gui.element.TabSecurity;
import cofh.core.gui.element.TabTutorial;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementEnergyStored;
import cofh.lib.gui.element.TabBase;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.block.cell.TileCell;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalexpansion.gui.element.TabConfigCell;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiCell
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/Cell.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/Cell.png");
    TileCell myTile;
    UUID playerName;
    ElementButton decRecv;
    ElementButton incRecv;
    ElementButton decSend;
    ElementButton incSend;

    public GuiCell(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerTEBase(inventoryPlayer, tileEntity), TEXTURE);
        this.myTile = (TileCell)tileEntity;
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.playerName = inventoryPlayer.field_70458_d.func_146103_bH().getId();
        this.generateInfo("tab.thermalexpansion.cell", 2);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addElement((ElementBase)new ElementEnergyStored((GuiBase)this, 80, 18, this.myTile.getEnergyStorage()));
        this.addTab((TabBase)new TabRedstone((GuiBase)this, (IRedstoneControl)this.myTile));
        this.addTab(new TabConfigCell((GuiBase)this, this.myTile));
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        this.addTab((TabBase)new TabTutorial((GuiBase)this, StringHelper.tutorialTabRedstone() + "\n\n" + StringHelper.tutorialTabConfigurationEnergy()));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.decRecv = new ElementButton((GuiBase)this, 28, 56, "DecRecv", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incRecv = new ElementButton((GuiBase)this, 44, 56, "IncRecv", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decSend = new ElementButton((GuiBase)this, 118, 56, "DecSend", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incSend = new ElementButton((GuiBase)this, 134, 56, "IncSend", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decRecv);
        this.addElement((ElementBase)this.incRecv);
        this.addElement((ElementBase)this.decSend);
        this.addElement((ElementBase)this.incSend);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    protected void updateElementInformation() {
        int n = 0;
        int n2 = 0;
        if (GuiScreen.func_146272_n()) {
            n = 1000;
            n2 = 100;
            if (GuiScreen.func_146271_m()) {
                n *= 10;
                n2 *= 10;
            }
        } else if (GuiScreen.func_146271_m()) {
            n = 5;
            n2 = 1;
        } else {
            n = 50;
            n2 = 10;
        }
        if (this.myTile.energyReceive > 0) {
            this.decRecv.setActive();
            this.decRecv.setToolTip(StringHelper.localize((String)"info.thermalexpansion.decRecv") + " " + n + "/" + n2);
        } else {
            this.decRecv.setDisabled();
            this.decRecv.clearToolTip();
        }
        if (this.myTile.energyReceive < TileCell.MAX_RECEIVE[this.myTile.type]) {
            this.incRecv.setActive();
            this.incRecv.setToolTip(StringHelper.localize((String)"info.thermalexpansion.incRecv") + " " + n + "/" + n2);
        } else {
            this.incRecv.setDisabled();
            this.incRecv.clearToolTip();
        }
        if (this.myTile.energySend > 0) {
            this.decSend.setActive();
            this.decSend.setToolTip(StringHelper.localize((String)"info.thermalexpansion.decSend") + " " + n + "/" + n2);
        } else {
            this.decSend.setDisabled();
            this.decSend.clearToolTip();
        }
        if (this.myTile.energySend < TileCell.MAX_SEND[this.myTile.type]) {
            this.incSend.setActive();
            this.incSend.setToolTip(StringHelper.localize((String)"info.thermalexpansion.incSend") + " " + n + "/" + n2);
        } else {
            this.incSend.setDisabled();
            this.incSend.clearToolTip();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        int n2 = 0;
        float f = 1.0f;
        if (GuiScreen.func_146272_n()) {
            n2 = 1000;
            f = 0.9f;
            if (n == 1) {
                n2 = 100;
                f = 0.8f;
            }
            if (GuiScreen.func_146271_m()) {
                n2 *= 10;
            }
        } else if (GuiScreen.func_146271_m()) {
            n2 = 5;
            f = 0.5f;
            if (n == 1) {
                n2 = 1;
                f = 0.4f;
            }
        } else {
            n2 = 50;
            f = 0.7f;
            if (n == 1) {
                n2 = 10;
                f = 0.6f;
            }
        }
        int n3 = this.myTile.energyReceive;
        int n4 = this.myTile.energySend;
        if (string.equalsIgnoreCase("DecRecv")) {
            this.myTile.energyReceive -= n2;
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("IncRecv")) {
            this.myTile.energyReceive += n2;
            f += 0.1f;
        } else if (string.equalsIgnoreCase("DecSend")) {
            this.myTile.energySend -= n2;
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("IncSend")) {
            this.myTile.energySend += n2;
            f += 0.1f;
        }
        GuiCell.playSound((String)"random.click", (float)1.0f, (float)f);
        this.myTile.sendModePacket();
        this.myTile.energyReceive = n3;
        this.myTile.energySend = n4;
    }

    protected void func_146979_b(int n, int n2) {
        ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermalexpansion.maxIn") + ":", this.getCenteredOffset(StringHelper.localize((String)"info.thermalexpansion.maxIn"), ((GuiContainer)this).field_146999_f / 2), 32, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(StringHelper.localize((String)"info.thermalexpansion.maxOut") + ":", ((GuiContainer)this).field_146999_f / 2 + this.getCenteredOffset(StringHelper.localize((String)"info.thermalexpansion.maxOut"), ((GuiContainer)this).field_146999_f / 2), 32, 0x404040);
        String string = String.format("%-8s", "" + this.myTile.energyReceive + " RF/t");
        String string2 = String.format("%-8s", "" + this.myTile.energySend + " RF/t");
        int n3 = 20;
        int n4 = 110;
        if (this.myTile.energyReceive < 10) {
            n3 += 6;
        }
        if (this.myTile.energyReceive < 100) {
            n3 += 6;
        }
        if (this.myTile.energyReceive < 1000) {
            n3 += 6;
        }
        if (this.myTile.energyReceive >= 10000) {
            n3 -= 6;
        }
        if (this.myTile.energyReceive >= 100000) {
            n3 -= 3;
        }
        if (this.myTile.energySend < 10) {
            n4 += 6;
        }
        if (this.myTile.energySend < 100) {
            n4 += 6;
        }
        if (this.myTile.energySend < 1000) {
            n4 += 6;
        }
        if (this.myTile.energySend >= 10000) {
            n4 -= 6;
        }
        if (this.myTile.energySend >= 100000) {
            n4 -= 3;
        }
        ((GuiScreen)this).field_146289_q.func_78276_b(string, n3, 44, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(string2, n4, 44, 0x404040);
        super.func_146979_b(n, n2);
    }
}

