/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.sponge;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.sponge.TileSponge;
import cofh.thermalexpansion.block.sponge.TileSpongeCreative;
import cofh.thermalexpansion.block.sponge.TileSpongeMagmatic;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockSponge
extends BlockTEBase {
    public static final String[] NAMES = new String[]{"creative", "basic", "magmatic"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack spongeCreative;
    public static ItemStack spongeBasic;
    public static ItemStack spongeMagmatic;

    public BlockSponge() {
        super(Material.field_151583_m);
        this.func_149711_c(0.6f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149663_c("thermalexpansion.sponge");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case CREATIVE: {
                if (!enable[Types.CREATIVE.ordinal()]) {
                    return null;
                }
                return new TileSpongeCreative(n);
            }
            case BASIC: {
                return new TileSponge(n);
            }
            case MAGMATIC: {
                return new TileSpongeMagmatic(n);
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (enable[0]) {
            list.add(new ItemStack(item, 1, 0));
        }
        for (int i = 1; i < Types.values().length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (!enable[world.func_72805_g(n, n2, n3)]) {
            world.func_147468_f(n, n2, n3);
            return;
        }
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (itemStack.field_77990_d != null && itemStack.field_77990_d.func_74764_b("Fluid")) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("Fluid"));
            if (fluidStack != null) {
                ((TileSponge)tileEntity).setFluid(fluidStack);
            }
        } else if (tileEntity instanceof TileSponge) {
            ((TileSponge)tileEntity).absorb();
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public void func_149674_a(World world, int n, int n2, int n3, Random random) {
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileSponge) {
            ((TileSponge)tileEntity).placeAir();
        }
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        ISidedTexture iSidedTexture = (ISidedTexture)iBlockAccess.func_147438_o(n, n2, n3);
        return iSidedTexture == null ? null : iSidedTexture.getTexture(n4, BlockCoFHBase.renderPass);
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        return IconRegistry.getIcon((String)"Sponge", (int)n2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"Sponge0", (String)"thermalexpansion:sponge/Sponge_Creative", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Sponge1", (String)"thermalexpansion:sponge/Sponge_Basic", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Sponge2", (String)"thermalexpansion:sponge/Sponge_Magmatic", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Sponge9", (String)"thermalexpansion:sponge/Sponge_Basic_Soaked", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"Sponge10", (String)"thermalexpansion:sponge/Sponge_Magmatic_Soaked", (IIconRegister)iIconRegister);
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        FluidStack fluidStack;
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileSponge tileSponge = (TileSponge)world.func_147438_o(n, n2, n3);
        if (tileSponge != null && (fluidStack = tileSponge.getFluid()) != null) {
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("Fluid", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
        return nBTTagCompound;
    }

    public boolean initialize() {
        TileSponge.initialize();
        TileSpongeMagmatic.initialize();
        TileSpongeCreative.initialize();
        spongeBasic = new ItemStack((Block)this, 1, Types.BASIC.ordinal());
        spongeMagmatic = new ItemStack((Block)this, 1, Types.MAGMATIC.ordinal());
        GameRegistry.registerCustomItemStack((String)"spongeBasic", (ItemStack)spongeBasic);
        GameRegistry.registerCustomItemStack((String)"spongeMagmatic", (ItemStack)spongeMagmatic);
        return true;
    }

    public boolean postInit() {
        if (enable[Types.BASIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(spongeBasic, new Object[]{"SWS", "WBW", "SWS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('W'), "dustWood", Character.valueOf('B'), "slimeball"}));
        }
        if (enable[Types.MAGMATIC.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(spongeMagmatic, new Object[]{"SWS", "WBW", "SWS", Character.valueOf('S'), Items.field_151007_F, Character.valueOf('W'), "dustWood", Character.valueOf('B'), Items.field_151064_bs}));
        }
        return true;
    }

    static {
        String string = "Sponge.";
        BlockSponge.enable[0] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[0]), "Enable", true);
        for (int i = 1; i < Types.values().length; ++i) {
            BlockSponge.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        CREATIVE,
        BASIC,
        MAGMATIC;

    }
}

