/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.api.energy.IEnergyContainerItem;
import cofh.core.CoFHProps;
import cofh.core.network.PacketCoFHBase;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoEnervation;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoEnervation;
import cofh.thermalexpansion.util.FuelHandler;
import cofh.thermalfoundation.fluid.TFFluids;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileDynamoEnervation
extends TileDynamoBase {
    static final int TYPE = BlockDynamo.Types.ENERVATION.ordinal();
    static int redstoneRF = 64000;
    static int blockRedstoneRF = redstoneRF * 10;
    static ItemStack redstone = new ItemStack(Items.field_151137_ax);
    static ItemStack blockRedstone = new ItemStack(Blocks.field_150451_bX);
    int currentFuelRF = TileDynamoEnervation.getEnergyValue(redstone);

    public static void initialize() {
        GameRegistry.registerTileEntity(TileDynamoEnervation.class, (String)"thermalexpansion.DynamoEnervation");
    }

    public static int getEnergyValue(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        if (itemStack.func_77969_a(redstone)) {
            return redstoneRF;
        }
        if (itemStack.func_77969_a(blockRedstone)) {
            return blockRedstoneRF;
        }
        if (EnergyHelper.isEnergyContainerItem((ItemStack)itemStack)) {
            IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)itemStack.func_77973_b();
            return iEnergyContainerItem.extractEnergy(itemStack, iEnergyContainerItem.getEnergyStored(itemStack), true);
        }
        return 0;
    }

    public TileDynamoEnervation() {
        this.inventory = new ItemStack[1];
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canGenerate() {
        if (this.fuelRF > 0) {
            return true;
        }
        return TileDynamoEnervation.getEnergyValue(this.inventory[0]) > 0;
    }

    @Override
    protected void generate() {
        int n;
        if (this.fuelRF <= 0) {
            if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
                IEnergyContainerItem iEnergyContainerItem = (IEnergyContainerItem)this.inventory[0].func_77973_b();
                this.fuelRF += iEnergyContainerItem.extractEnergy(this.inventory[0], iEnergyContainerItem.getEnergyStored(this.inventory[0]), false);
                this.currentFuelRF = redstoneRF;
            } else {
                n = TileDynamoEnervation.getEnergyValue(this.inventory[0]) * this.fuelMod / 100;
                this.fuelRF += n;
                this.currentFuelRF = n;
                this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
            }
        }
        n = Math.min(this.fuelRF, this.calcEnergy() * this.energyMod);
        this.energyStorage.modifyEnergyStored(n);
        this.fuelRF -= n;
    }

    @Override
    public IIcon getActiveIcon() {
        return TFFluids.fluidRedstone.getIcon();
    }

    public Object getGuiClient(InventoryPlayer inventoryPlayer) {
        return new GuiDynamoEnervation(inventoryPlayer, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventoryPlayer) {
        return new ContainerDynamoEnervation(inventoryPlayer, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int n) {
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = redstoneRF;
        } else if (EnergyHelper.isEnergyContainerItem((ItemStack)this.inventory[0])) {
            return n;
        }
        return this.fuelRF * n / this.currentFuelRF;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.currentFuelRF = nBTTagCompound.func_74762_e("FuelMax");
        if (this.currentFuelRF <= 0) {
            this.currentFuelRF = redstoneRF;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("FuelMax", this.currentFuelRF);
    }

    @Override
    public PacketCoFHBase getGuiPacket() {
        PacketCoFHBase packetCoFHBase = super.getGuiPacket();
        packetCoFHBase.addInt(this.currentFuelRF);
        return packetCoFHBase;
    }

    @Override
    protected void handleGuiPacket(PacketCoFHBase packetCoFHBase) {
        super.handleGuiPacket(packetCoFHBase);
        this.currentFuelRF = packetCoFHBase.getInt();
    }

    @Override
    public int getInfoEnergyPerTick() {
        return Math.min(TileDynamoEnervation.getEnergyValue(this.inventory[0]), this.calcEnergy() * this.energyMod);
    }

    @Override
    public int[] func_94128_d(int n) {
        return n != this.facing || this.augmentCoilDuct ? TileDynamoBase.SLOTS : CoFHProps.EMPTY_INVENTORY;
    }

    static {
        String string = "Fuels.Enervation";
        redstoneRF = FuelHandler.configFuels.get(string, "redstone", redstoneRF);
        blockRedstoneRF = redstoneRF * 10;
    }
}

