/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.core.ICustomInventory;
import cofh.core.render.IconRegistry;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.common.registry.GameRegistry;
import gnu.trove.map.hash.THashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;

public class TileLexicon
extends TileAugmentable
implements ICustomInventory {
    static final int TYPE = BlockDevice.Types.LEXICON.ordinal();
    static TileTEBase.SideConfig defaultSideConfig = new TileTEBase.SideConfig();
    static TileTEBase.EnergyConfig energyConfig = new TileTEBase.EnergyConfig();
    public static boolean enableSecurity = true;
    Map<String, ItemStack> conversions = new THashMap(9);
    ItemStack[] conversionItems = new ItemStack[9];

    public static void initialize() {
        defaultSideConfig = new TileTEBase.SideConfig();
        TileLexicon.defaultSideConfig.numConfig = 4;
        TileLexicon.defaultSideConfig.slotGroups = new int[][]{new int[0], {0, 1, 2, 3, 4, 5}, {6, 7, 8, 9, 10, 11}};
        TileLexicon.defaultSideConfig.allowInsertionSide = new boolean[]{false, true, false, true};
        TileLexicon.defaultSideConfig.allowExtractionSide = new boolean[]{false, false, true, true};
        TileLexicon.defaultSideConfig.allowInsertionSlot = new boolean[]{true, true, true, true, true, true, false, false, false, false, false, false, false};
        TileLexicon.defaultSideConfig.allowExtractionSlot = new boolean[]{true, true, true, true, true, true, true, true, true, true, true, true, false};
        TileLexicon.defaultSideConfig.sideTex = new int[]{0, 1, 4, 7};
        TileLexicon.defaultSideConfig.defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        GameRegistry.registerTileEntity(TileLexicon.class, (String)"thermalexpansion.lexicon");
        TileLexicon.configure();
    }

    public static void configure() {
        String string = "Enable this to allow for Lexicons to be securable.";
        enableSecurity = ThermalExpansion.config.get("Security", "Device.Lexicon.Securable", enableSecurity, string);
    }

    public TileLexicon() {
        this.sideConfig = defaultSideConfig;
        this.inventory = new ItemStack[13];
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return TYPE;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.readConversionsFromNBT(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        this.writeConversionsToNBT(nBTTagCompound);
    }

    public void readConversionsFromNBT(NBTTagCompound nBTTagCompound) {
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Conversions", 10);
        for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            int n = nBTTagCompound2.func_74762_e("Slot");
            if (n < 0 || n >= this.conversionItems.length) continue;
            this.conversionItems[n] = ItemStack.func_77949_a((NBTTagCompound)nBTTagCompound2);
        }
    }

    public void writeConversionsToNBT(NBTTagCompound nBTTagCompound) {
        if (this.conversionItems.length <= 0) {
            return;
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.augments.length; ++i) {
            if (this.conversionItems[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.func_74768_a("Slot", i);
            this.conversionItems[i].func_77955_b(nBTTagCompound2);
            nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
        }
        nBTTagCompound.func_74782_a("Conversions", (NBTBase)nBTTagList);
    }

    public ItemStack[] getInventorySlots(int n) {
        return this.conversionItems;
    }

    public int getSlotStackLimit(int n) {
        return 1;
    }

    public void onSlotUpdate() {
        this.func_70296_d();
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? IconRegistry.getIcon((String)"DeviceSide") : (this.isActive && this.redstoneControlOrDisable() ? IconRegistry.getIcon((String)"DeviceActive", (int)this.getType()) : IconRegistry.getIcon((String)"DeviceFace", (int)this.getType()));
        }
        if (n < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]);
        }
        return IconRegistry.getIcon((String)"DeviceSide");
    }
}

