/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.tileentity.ISidedTexture;
import cofh.core.block.BlockCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.core.util.crafting.RecipeAugmentable;
import cofh.core.util.crafting.RecipeUpgrade;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.BlockTEBase;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.device.ItemBlockDevice;
import cofh.thermalexpansion.block.device.TileActivator;
import cofh.thermalexpansion.block.device.TileBreaker;
import cofh.thermalexpansion.block.device.TileNullifier;
import cofh.thermalexpansion.block.device.TilePump;
import cofh.thermalexpansion.block.device.TileWorkbench;
import cofh.thermalexpansion.block.strongbox.BlockStrongbox;
import cofh.thermalexpansion.item.TEAugments;
import cofh.thermalexpansion.item.TEEquipment;
import cofh.thermalexpansion.item.TEItems;
import cofh.thermalexpansion.util.ReconfigurableHelper;
import cofh.thermalexpansion.util.crafting.TECraftingHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockDevice
extends BlockTEBase {
    public static String[] NAMES = new String[]{"workbench", "lexicon", "activator", "breaker", "pump", "nullifier"};
    public static boolean[] enable = new boolean[Types.values().length];
    public static ItemStack[] defaultAugments = new ItemStack[3];
    public static boolean defaultAutoTransfer = true;
    public static boolean defaultRedstoneControl = true;
    public static boolean defaultReconfigSides = true;
    public static ItemStack workbench;
    public static ItemStack lexicon;
    public static ItemStack activator;
    public static ItemStack breaker;
    public static ItemStack pump;
    public static ItemStack nullifier;

    public BlockDevice() {
        super(Material.field_151573_f);
        this.func_149711_c(15.0f);
        this.func_149752_b(25.0f);
        this.func_149663_c("thermalexpansion.device");
    }

    public TileEntity func_149915_a(World world, int n) {
        if (n >= Types.values().length) {
            return null;
        }
        switch (Types.values()[n]) {
            case WORKBENCH: {
                return new TileWorkbench();
            }
            case ACTIVATOR: {
                return new TileActivator();
            }
            case BREAKER: {
                return new TileBreaker();
            }
            case PUMP: {
                return new TilePump();
            }
            case NULLIFIER: {
                return new TileNullifier();
            }
        }
        return null;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        if (enable[0]) {
            list.add(new ItemStack(item, 1, 0));
        }
        for (int i = 1; i < Types.values().length; ++i) {
            if (!enable[i]) continue;
            list.add(ItemBlockDevice.setDefaultTag(new ItemStack(item, 1, i)));
        }
    }

    @Override
    public void func_149689_a(World world, int n, int n2, int n3, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (itemStack.field_77990_d != null) {
            TileEntity tileEntity = world.func_147438_o(n, n2, n3);
            if (tileEntity instanceof TileWorkbench) {
                TileWorkbench tileWorkbench = (TileWorkbench)tileEntity;
                if (itemStack.field_77990_d.func_74764_b("Inventory")) {
                    tileWorkbench.selectedSchematic = itemStack.field_77990_d.func_74771_c("Mode");
                    tileWorkbench.readInventoryFromNBT(itemStack.field_77990_d);
                }
            } else if (tileEntity instanceof TileAugmentable) {
                TileAugmentable tileAugmentable = (TileAugmentable)world.func_147438_o(n, n2, n3);
                tileAugmentable.readAugmentsFromNBT(itemStack.field_77990_d);
                tileAugmentable.installAugments();
                tileAugmentable.setEnergyStored(itemStack.field_77990_d.func_74762_e("Energy"));
                int n4 = BlockHelper.determineXZPlaceFacing((EntityLivingBase)entityLivingBase);
                byte by = ReconfigurableHelper.getFacing(itemStack);
                byte[] byArray = ReconfigurableHelper.getSideCache(itemStack, tileAugmentable.getDefaultSides());
                tileAugmentable.sideCache[0] = byArray[0];
                tileAugmentable.sideCache[1] = byArray[1];
                tileAugmentable.sideCache[n4] = 0;
                tileAugmentable.sideCache[BlockHelper.getLeftSide((int)n4)] = byArray[BlockHelper.getLeftSide((int)by)];
                tileAugmentable.sideCache[BlockHelper.getRightSide((int)n4)] = byArray[BlockHelper.getRightSide((int)by)];
                tileAugmentable.sideCache[BlockHelper.getOppositeSide((int)n4)] = byArray[BlockHelper.getOppositeSide((int)by)];
            }
        }
        super.func_149689_a(world, n, n2, n3, entityLivingBase, itemStack);
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean canRenderInPass(int n) {
        BlockCoFHBase.renderPass = n;
        return n < 2;
    }

    public boolean isNormalCube(IBlockAccess iBlockAccess, int n, int n2, int n3) {
        return false;
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean isSideSolid(IBlockAccess iBlockAccess, int n, int n2, int n3, ForgeDirection forgeDirection) {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    public IIcon func_149673_e(IBlockAccess iBlockAccess, int n, int n2, int n3, int n4) {
        ISidedTexture iSidedTexture = (ISidedTexture)iBlockAccess.func_147438_o(n, n2, n3);
        return iSidedTexture == null ? null : iSidedTexture.getTexture(n4, BlockCoFHBase.renderPass);
    }

    @Override
    public IIcon func_149691_a(int n, int n2) {
        if (n2 == Types.WORKBENCH.ordinal()) {
            if (n == 0) {
                return IconRegistry.getIcon((String)"WorkbenchBottom");
            }
            if (n == 1) {
                return IconRegistry.getIcon((String)"WorkbenchTop");
            }
            return IconRegistry.getIcon((String)"WorkbenchSide");
        }
        return n != 3 ? IconRegistry.getIcon((String)"DeviceSide") : IconRegistry.getIcon((String)("DeviceFace" + n2));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        IconRegistry.addIcon((String)"WorkbenchBottom", (String)"thermalexpansion:device/Device_Bottom_Workbench", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"WorkbenchTop", (String)"thermalexpansion:device/Device_Top_Workbench", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"WorkbenchSide", (String)"thermalexpansion:device/Device_Side_Workbench", (IIconRegister)iIconRegister);
        IconRegistry.addIcon((String)"DeviceSide", (String)"thermalexpansion:device/Device_Side", (IIconRegister)iIconRegister);
        for (int i = 2; i < Types.values().length; ++i) {
            if (i == Types.PUMP.ordinal()) continue;
            IconRegistry.addIcon((String)("DeviceFace" + i), (String)("thermalexpansion:device/Device_Face_" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)iIconRegister);
            IconRegistry.addIcon((String)("DeviceActive" + i), (String)("thermalexpansion:device/Device_Active_" + StringHelper.titleCase((String)NAMES[i])), (IIconRegister)iIconRegister);
        }
    }

    @Override
    public NBTTagCompound getItemStackTag(World world, int n, int n2, int n3) {
        NBTTagCompound nBTTagCompound = super.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileWorkbench) {
            TileWorkbench tileWorkbench = (TileWorkbench)tileEntity;
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            nBTTagCompound.func_74778_a("Owner", tileWorkbench.getOwnerName());
            nBTTagCompound.func_74774_a("Access", (byte)tileWorkbench.getAccess().ordinal());
            nBTTagCompound.func_74774_a("Mode", (byte)tileWorkbench.selectedSchematic);
            tileWorkbench.writeInventoryToNBT(nBTTagCompound);
        } else if (tileEntity instanceof TileAugmentable) {
            TileAugmentable tileAugmentable = (TileAugmentable)world.func_147438_o(n, n2, n3);
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileAugmentable);
            nBTTagCompound.func_74768_a("Energy", tileAugmentable.getEnergyStored(ForgeDirection.UNKNOWN));
            tileAugmentable.writeAugmentsToNBT(nBTTagCompound);
        }
        return nBTTagCompound;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer entityPlayer, World world, int n, int n2, int n3, boolean bl) {
        NBTTagCompound nBTTagCompound = this.getItemStackTag(world, n, n2, n3);
        TileEntity tileEntity = world.func_147438_o(n, n2, n3);
        if (tileEntity instanceof TileWorkbench) {
            ((TileWorkbench)tileEntity).inventory = new ItemStack[((TileWorkbench)tileEntity).inventory.length];
        } else if (tileEntity instanceof TileAugmentable) {
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            TileAugmentable tileAugmentable = (TileAugmentable)tileEntity;
            ReconfigurableHelper.setItemStackTagReconfig(nBTTagCompound, tileAugmentable);
            nBTTagCompound.func_74768_a("Energy", tileAugmentable.getEnergyStored(ForgeDirection.UNKNOWN));
            tileAugmentable.writeAugmentsToNBT(nBTTagCompound);
        }
        return super.dismantleBlock(entityPlayer, nBTTagCompound, world, n, n2, n3, bl, false);
    }

    public boolean initialize() {
        TileWorkbench.initialize();
        TileActivator.initialize();
        TileBreaker.initialize();
        TileNullifier.initialize();
        if (defaultAutoTransfer) {
            // empty if block
        }
        if (defaultRedstoneControl) {
            BlockDevice.defaultAugments[1] = ItemHelper.cloneStack((ItemStack)TEAugments.generalRedstoneControl);
        }
        if (defaultReconfigSides) {
            BlockDevice.defaultAugments[2] = ItemHelper.cloneStack((ItemStack)TEAugments.generalReconfigSides);
        }
        workbench = new ItemStack((Block)this, 1, Types.WORKBENCH.ordinal());
        activator = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.ACTIVATOR.ordinal()));
        breaker = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.BREAKER.ordinal()));
        nullifier = ItemBlockDevice.setDefaultTag(new ItemStack((Block)this, 1, Types.NULLIFIER.ordinal()));
        GameRegistry.registerCustomItemStack((String)"workbench", (ItemStack)workbench);
        GameRegistry.registerCustomItemStack((String)"activator", (ItemStack)activator);
        GameRegistry.registerCustomItemStack((String)"breaker", (ItemStack)breaker);
        GameRegistry.registerCustomItemStack((String)"nullifier", (ItemStack)nullifier);
        return true;
    }

    public boolean postInit() {
        String string = "Device.Breaker";
        String string2 = "If enabled, The Block Breaker will require a Diamond Pickaxe instead of an Invar Pickaxe.";
        boolean bl = ThermalExpansion.config.get(string, "Recipe.RequireDiamondPickaxe", false, string2);
        ItemStack itemStack = bl ? new ItemStack(Items.field_151046_w) : TEEquipment.toolInvarPickaxe;
        String string3 = "thermalexpansion:machineTin";
        if (enable[Types.WORKBENCH.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeUpgrade(7, workbench, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), BlockStrongbox.strongboxBasic, Character.valueOf('X'), Items.field_151121_aF}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(workbench, new Object[]{"YXY", "ICI", "YPY", Character.valueOf('C'), Blocks.field_150462_ai, Character.valueOf('I'), "ingotCopper", Character.valueOf('P'), Blocks.field_150486_ae, Character.valueOf('X'), Items.field_151121_aF, Character.valueOf('Y'), "ingotTin"}));
        }
        if (enable[Types.LEXICON.ordinal()]) {
            // empty if block
        }
        if (enable[Types.ACTIVATOR.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(activator, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150331_J, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.powerCoilGold, Character.valueOf('X'), Blocks.field_150486_ae}));
        }
        if (enable[Types.BREAKER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(breaker, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Blocks.field_150331_J, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), itemStack}));
        }
        if (enable[Types.PUMP.ordinal()]) {
            // empty if block
        }
        if (enable[Types.NULLIFIER.ordinal()]) {
            GameRegistry.addRecipe((IRecipe)new RecipeAugmentable(nullifier, defaultAugments, new Object[]{" X ", "ICI", " P ", Character.valueOf('C'), Items.field_151129_at, Character.valueOf('I'), string3, Character.valueOf('P'), TEItems.pneumaticServo, Character.valueOf('X'), "ingotInvar"}));
        }
        TECraftingHandler.addSecureRecipe(workbench);
        TECraftingHandler.addSecureRecipe(activator);
        TECraftingHandler.addSecureRecipe(breaker);
        TECraftingHandler.addSecureRecipe(nullifier);
        return true;
    }

    public static void refreshItemStacks() {
        activator = ItemBlockDevice.setDefaultTag(activator);
        breaker = ItemBlockDevice.setDefaultTag(breaker);
        nullifier = ItemBlockDevice.setDefaultTag(nullifier);
    }

    static {
        String string = "Device.";
        for (int i = 0; i < Types.values().length; ++i) {
            if (i == Types.LEXICON.ordinal() || i == Types.PUMP.ordinal()) continue;
            BlockDevice.enable[i] = ThermalExpansion.config.get(string + StringHelper.titleCase((String)NAMES[i]), "Recipe.Enable", true);
        }
    }

    public static enum Types {
        WORKBENCH,
        LEXICON,
        ACTIVATOR,
        BREAKER,
        PUMP,
        NULLIFIER;

    }
}

