/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.cache;

import cofh.api.inventory.IInventoryRetainer;
import cofh.api.tileentity.ITileInfo;
import cofh.core.network.PacketCoFHBase;
import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileReconfigurable;
import cofh.thermalexpansion.block.cache.BlockCache;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TileCache
extends TileReconfigurable
implements IDeepStorageUnit,
ISidedInventory,
IInventoryRetainer,
ITileInfo {
    public static int[] CAPACITY = new int[]{Integer.MAX_VALUE, 10000, 40000, 160000, 640000};
    public static final int[] SLOTS = new int[]{0, 1};
    public static final byte[] DEFAULT_SIDES = new byte[]{1, 0, 0, 0, 0, 0};
    int meterTracker;
    int compareTracker;
    public byte type = 1;
    public boolean locked;
    public int maxCacheStackSize;
    public ItemStack storedStack;

    public static void initialize() {
        GameRegistry.registerTileEntity(TileCache.class, (String)"thermalexpansion.Cache");
    }

    public TileCache() {
        this.inventory = new ItemStack[2];
    }

    public TileCache(int n) {
        this.type = (byte)n;
        this.inventory = new ItemStack[2];
        this.maxCacheStackSize = CAPACITY[this.type] - 128;
    }

    public String getName() {
        return "tile.thermalexpansion.cache." + BlockCache.NAMES[this.getType()] + ".name";
    }

    public int getType() {
        return this.type;
    }

    public int getComparatorInput(int n) {
        return this.compareTracker;
    }

    public int getScaledItemsStored(int n) {
        return MathHelper.round((double)((long)this.getStoredCount() * (long)n / (long)CAPACITY[this.type]));
    }

    public boolean canUpdate() {
        return false;
    }

    public boolean toggleLock() {
        boolean bl = this.locked = !this.locked;
        if (this.getStoredCount() <= 0 && !this.locked) {
            this.clearInventory();
        }
        this.sendUpdatePacket(Side.CLIENT);
        return this.locked;
    }

    protected void balanceStacks() {
        this.inventory[0] = null;
        this.inventory[1] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.storedStack.func_77976_d(), this.storedStack.field_77994_a));
        this.storedStack.field_77994_a -= this.inventory[1].field_77994_a;
        if (this.storedStack.field_77994_a > this.maxCacheStackSize) {
            this.inventory[0] = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)(this.storedStack.field_77994_a - this.maxCacheStackSize));
            this.storedStack.field_77994_a = this.maxCacheStackSize;
        }
    }

    protected void clearInventory() {
        if (!this.locked) {
            this.storedStack = null;
            this.sendUpdatePacket(Side.CLIENT);
        } else if (this.storedStack != null) {
            this.storedStack.field_77994_a = 0;
        }
        this.inventory[0] = null;
        this.inventory[1] = null;
    }

    protected void updateTrackers() {
        int n;
        int n2 = n = this.getScaledItemsStored(14) + this.getStoredCount() > 0 ? 1 : 0;
        if (this.compareTracker != n) {
            this.compareTracker = n;
            this.callNeighborTileChange();
        }
        if (this.meterTracker != (n = Math.min(8, this.getScaledItemsStored(9)))) {
            this.meterTracker = n;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    @Override
    public boolean hasGui() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        this.type = nBTTagCompound.func_74771_c("Type");
        this.facing = nBTTagCompound.func_74771_c("Facing");
        this.locked = nBTTagCompound.func_74767_n("LockItem");
        if (nBTTagCompound.func_74764_b("Item")) {
            this.storedStack = ItemHelper.readItemStackFromNBT((NBTTagCompound)nBTTagCompound.func_74775_l("Item"));
            this.maxCacheStackSize = CAPACITY[this.type] - this.storedStack.func_77976_d() * 2;
        } else {
            this.maxCacheStackSize = CAPACITY[this.type] - 128;
        }
        super.func_145839_a(nBTTagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound nBTTagCompound) {
        super.func_145841_b(nBTTagCompound);
        nBTTagCompound.func_74774_a("Type", this.type);
        nBTTagCompound.func_74774_a("Facing", this.facing);
        nBTTagCompound.func_74757_a("LockItem", this.locked);
        if (this.storedStack != null) {
            nBTTagCompound.func_74782_a("Item", (NBTBase)ItemHelper.writeItemStackToNBT((ItemStack)this.storedStack, (NBTTagCompound)new NBTTagCompound()));
        }
    }

    @Override
    public PacketCoFHBase getPacket() {
        PacketCoFHBase packetCoFHBase = super.getPacket();
        packetCoFHBase.addBool(this.locked);
        packetCoFHBase.addItemStack(this.storedStack);
        if (this.storedStack != null) {
            packetCoFHBase.addInt(this.getStoredCount());
        }
        return packetCoFHBase;
    }

    @Override
    public void handleTilePacket(PacketCoFHBase packetCoFHBase, boolean bl) {
        super.handleTilePacket(packetCoFHBase, bl);
        this.locked = packetCoFHBase.getBool();
        this.storedStack = packetCoFHBase.getItemStack();
        if (this.storedStack != null) {
            this.storedStack.field_77994_a = packetCoFHBase.getInt();
            this.inventory[1] = null;
            this.balanceStacks();
        } else {
            this.storedStack = null;
            this.inventory[0] = null;
            this.inventory[1] = null;
        }
    }

    @Override
    public ItemStack getStoredItemType() {
        return ItemHelper.cloneStack((ItemStack)this.storedStack, (int)this.getStoredCount());
    }

    @Override
    public void setStoredItemCount(int n) {
        if (this.storedStack == null) {
            return;
        }
        this.storedStack.field_77994_a = Math.min(n, this.getMaxStoredCount());
        if (n > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack itemStack, int n) {
        if (itemStack == null) {
            this.clearInventory();
        } else {
            this.storedStack = ItemHelper.cloneStack((ItemStack)itemStack, (int)Math.min(n, this.getMaxStoredCount()));
            this.maxCacheStackSize = CAPACITY[this.type] - this.storedStack.func_77976_d() * 2;
            this.balanceStacks();
        }
        this.updateTrackers();
        this.sendUpdatePacket(Side.CLIENT);
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        return CAPACITY[this.type];
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        if (this.inventory[n] == null) {
            return null;
        }
        if (this.inventory[n].field_77994_a <= n2) {
            n2 = this.inventory[n].field_77994_a;
        }
        ItemStack itemStack = this.inventory[n].func_77979_a(n2);
        if (this.inventory[n].field_77994_a <= 0) {
            this.inventory[n] = null;
        }
        this.storedStack.field_77994_a = this.storedStack.field_77994_a + ((this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
        if (this.storedStack.field_77994_a > 0) {
            this.balanceStacks();
        } else {
            this.clearInventory();
        }
        this.updateTrackers();
        this.func_70296_d();
        return itemStack;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        boolean bl;
        this.inventory[n] = itemStack;
        boolean bl2 = bl = this.storedStack == null;
        if (n == 0) {
            if (this.inventory[0] == null) {
                return;
            }
            if (this.storedStack == null) {
                this.storedStack = this.inventory[0].func_77946_l();
                this.inventory[0] = null;
                this.maxCacheStackSize = CAPACITY[this.type] - this.storedStack.func_77976_d() * 2;
            } else {
                this.storedStack.field_77994_a = this.storedStack.field_77994_a + (this.inventory[0].field_77994_a + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
            }
            this.balanceStacks();
        } else {
            if (this.storedStack == null) {
                return;
            }
            this.storedStack.field_77994_a = this.storedStack.field_77994_a + ((this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a));
            if (this.storedStack.field_77994_a > 0) {
                this.balanceStacks();
            } else {
                this.clearInventory();
            }
        }
        this.updateTrackers();
        if (bl != (this.storedStack == null)) {
            this.sendUpdatePacket(Side.CLIENT);
        }
        this.func_70296_d();
    }

    @Override
    public int getNumConfig(int n) {
        return 1;
    }

    public int[] func_94128_d(int n) {
        return SLOTS;
    }

    public boolean func_102007_a(int n, ItemStack itemStack, int n2) {
        return n == 0 && (this.storedStack == null || ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack, (ItemStack)this.storedStack, (boolean)true));
    }

    public boolean func_102008_b(int n, ItemStack itemStack, int n2) {
        return n == 1;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 1) {
            if (n != this.facing) {
                return IconRegistry.getIcon((String)"CacheBlank");
            }
            return IconRegistry.getIcon((String)"CacheMeter", (int)Math.min(8, this.getScaledItemsStored(9)));
        }
        if (n == 0) {
            return IconRegistry.getIcon((String)"CacheBottom", (int)this.type);
        }
        if (n == 1) {
            return IconRegistry.getIcon((String)"CacheTop", (int)this.type);
        }
        return n != this.facing ? IconRegistry.getIcon((String)"CacheSide", (int)this.type) : IconRegistry.getIcon((String)"CacheFace", (int)this.type);
    }

    public void getTileInfo(List<IChatComponent> list, ForgeDirection forgeDirection, EntityPlayer entityPlayer, boolean bl) {
        if (bl) {
            return;
        }
        if (this.storedStack != null) {
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.getItemName((ItemStack)this.storedStack)));
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.amount") + ": " + this.getStoredCount() + " / " + CAPACITY[this.type]));
        } else {
            list.add((IChatComponent)new ChatComponentText(StringHelper.localize((String)"info.cofh.item") + ": " + StringHelper.localize((String)"info.cofh.empty")));
        }
        list.add((IChatComponent)new ChatComponentText(this.locked ? StringHelper.localize((String)"info.cofh.locked") : StringHelper.localize((String)"info.cofh.unlocked")));
    }

    public int getStoredCount() {
        return this.storedStack == null ? 0 : this.storedStack.field_77994_a + (this.inventory[0] == null ? 0 : this.inventory[0].field_77994_a) + (this.inventory[1] == null ? 0 : this.inventory[1].field_77994_a);
    }

    public ItemStack insertItem(ForgeDirection forgeDirection, ItemStack itemStack, boolean bl) {
        if (itemStack == null) {
            return null;
        }
        if (this.storedStack == null) {
            if (!bl) {
                this.setStoredItemType(itemStack, itemStack.field_77994_a);
            }
            return null;
        }
        if (this.getStoredCount() == CAPACITY[this.type]) {
            return itemStack;
        }
        if (ItemHelper.itemsIdentical((ItemStack)itemStack, (ItemStack)this.storedStack)) {
            if (this.getStoredCount() + itemStack.field_77994_a > CAPACITY[this.type]) {
                ItemStack itemStack2 = ItemHelper.cloneStack((ItemStack)itemStack, (int)(CAPACITY[this.type] - this.getStoredCount()));
                if (!bl) {
                    this.setStoredItemCount(CAPACITY[this.type]);
                }
                return itemStack2;
            }
            if (!bl) {
                this.setStoredItemCount(this.getStoredCount() + itemStack.field_77994_a);
            }
            return null;
        }
        return itemStack;
    }

    public ItemStack extractItem(ForgeDirection forgeDirection, int n, boolean bl) {
        if (this.storedStack == null) {
            return null;
        }
        ItemStack itemStack = ItemHelper.cloneStack((ItemStack)this.storedStack, (int)Math.min(this.getStoredCount(), Math.min(n, this.storedStack.func_77976_d())));
        if (!bl) {
            this.setStoredItemCount(this.getStoredCount() - itemStack.field_77994_a);
        }
        return itemStack;
    }

    static {
        String string = "Cache.";
        TileCache.CAPACITY[4] = MathHelper.clampI((int)ThermalExpansion.config.get(string + StringHelper.titleCase((String)BlockCache.NAMES[4]), "Capacity", CAPACITY[4]), (int)(CAPACITY[4] / 8), (int)1000000000);
        TileCache.CAPACITY[3] = MathHelper.clampI((int)ThermalExpansion.config.get(string + StringHelper.titleCase((String)BlockCache.NAMES[3]), "Capacity", CAPACITY[3]), (int)(CAPACITY[3] / 8), (int)CAPACITY[4]);
        TileCache.CAPACITY[2] = MathHelper.clampI((int)ThermalExpansion.config.get(string + StringHelper.titleCase((String)BlockCache.NAMES[2]), "Capacity", CAPACITY[2]), (int)(CAPACITY[2] / 8), (int)CAPACITY[3]);
        TileCache.CAPACITY[1] = MathHelper.clampI((int)ThermalExpansion.config.get(string + StringHelper.titleCase((String)BlockCache.NAMES[1]), "Capacity", CAPACITY[1]), (int)(CAPACITY[1] / 8), (int)CAPACITY[2]);
    }
}

