/*
 * Decompiled with CFR 0.152.
 */
package codechicken.core.asm;

import codechicken.core.asm.CodeChickenCoreModContainer;
import codechicken.lib.asm.ObfMapping;
import com.google.common.collect.ImmutableBiMap;
import cpw.mods.fml.common.asm.transformers.AccessTransformer;
import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import java.io.IOException;
import java.lang.reflect.Field;

public class CodeChickenAccessTransformer
extends AccessTransformer {
    private static boolean makeAllPublic;
    private static Field f_classNameBiMap;
    private static Object emptyMap;

    public CodeChickenAccessTransformer() throws IOException {
        this.loadPublicConfig();
    }

    private void loadPublicConfig() {
        if (ObfMapping.obfuscated) {
            return;
        }
        makeAllPublic = CodeChickenCoreModContainer.config.getTag("dev.runtimePublic").setComment("Enabling this setting will make all minecraft classes public at runtime in MCP just as they are in modloader.\nYou should ONLY use this when you are testing with a mod that relies on runtime publicity and doesn't include access transformers.\nSuch mods are doing the wrong thing and should be fixed.").getBooleanValue(false);
        if (!makeAllPublic) {
            return;
        }
        try {
            f_classNameBiMap = FMLDeobfuscatingRemapper.class.getDeclaredField("classNameBiMap");
            f_classNameBiMap.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        boolean setPublic;
        boolean bl = setPublic = makeAllPublic && name.startsWith("net.minecraft.");
        if (setPublic) {
            this.setClassMap(name);
        }
        bytes = super.transform(name, transformedName, bytes);
        if (setPublic) {
            this.restoreClassMap();
        }
        return bytes;
    }

    private void restoreClassMap() {
        try {
            f_classNameBiMap.set(FMLDeobfuscatingRemapper.INSTANCE, emptyMap);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setClassMap(String name) {
        try {
            f_classNameBiMap.set(FMLDeobfuscatingRemapper.INSTANCE, ImmutableBiMap.of((Object)name.replace('.', '/'), (Object)""));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        emptyMap = ImmutableBiMap.of();
    }
}

