/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.network;

import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import io.endertech.network.PacketBase;
import io.endertech.util.BlockCoord;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.fluids.FluidStack;

public abstract class PacketETBase
extends PacketBase {
    public DataInputStream dataIn;
    private ByteArrayOutputStream arrayOut;
    private DataOutputStream dataOut;

    public PacketETBase() {
        this.arrayOut = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.arrayOut);
    }

    public PacketETBase(byte[] data) {
        this.dataIn = new DataInputStream(new ByteArrayInputStream(data));
    }

    public PacketETBase addString(String theString) {
        try {
            this.dataOut.writeUTF(theString);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addInt(int theInteger) {
        try {
            this.dataOut.writeInt(theInteger);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addBool(boolean theBoolean) {
        try {
            this.dataOut.writeBoolean(theBoolean);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addByte(byte theByte) {
        try {
            this.dataOut.writeByte(theByte);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addByte(int theByte) {
        return this.addByte((byte)theByte);
    }

    public PacketETBase addShort(short theShort) {
        try {
            this.dataOut.writeShort(theShort);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addShort(int theShort) {
        return this.addShort((short)theShort);
    }

    public PacketETBase addByteArray(byte[] theByteArray) {
        try {
            this.dataOut.write(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addFloat(float theFloat) {
        try {
            this.dataOut.writeFloat(theFloat);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addVec3(Vec3 theVec3) {
        this.addDouble(theVec3.field_72450_a);
        this.addDouble(theVec3.field_72448_b);
        return this.addDouble(theVec3.field_72449_c);
    }

    public PacketETBase addDouble(double theDouble) {
        try {
            this.dataOut.writeDouble(theDouble);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addItemStack(ItemStack theStack) {
        try {
            this.writeItemStack(theStack);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addInventory(ItemStack[] itemStacks) {
        try {
            for (ItemStack itemStack : itemStacks) {
                this.writeItemStack(itemStack);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addFluidStack(FluidStack theStack) {
        try {
            FluidHelper.writeFluidStackToPacket(theStack, this.dataOut);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this;
    }

    public PacketETBase addCoords(TileEntity theTile) {
        this.addInt(theTile.field_145851_c);
        this.addInt(theTile.field_145848_d);
        return this.addInt(theTile.field_145849_e);
    }

    public PacketETBase addCoords(int x, int y, int z) {
        this.addInt(x);
        this.addInt(y);
        return this.addInt(z);
    }

    public PacketETBase addCoords(BlockCoord coord) {
        this.addInt(coord.x);
        this.addInt(coord.y);
        return this.addInt(coord.z);
    }

    public String getString() {
        try {
            return this.dataIn.readUTF();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getInt() {
        try {
            return this.dataIn.readInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public boolean getBool() {
        try {
            return this.dataIn.readBoolean();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public byte getByte() {
        try {
            return this.dataIn.readByte();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public short getShort() {
        try {
            return this.dataIn.readShort();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void getByteArray(byte[] theByteArray) {
        try {
            this.dataIn.readFully(theByteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public float getFloat() {
        try {
            return this.dataIn.readFloat();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public double getDouble() {
        try {
            return this.dataIn.readDouble();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Vec3 getVec3() {
        double d1 = this.getDouble();
        double d2 = this.getDouble();
        double d3 = this.getDouble();
        return Vec3.func_72443_a((double)d1, (double)d2, (double)d3);
    }

    public ItemStack getItemStack() {
        try {
            return this.readItemStack();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack[] getInventory(int count) {
        ItemStack[] itemStacks = new ItemStack[count];
        try {
            for (int i = 0; i < count; ++i) {
                itemStacks[i] = this.readItemStack();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return itemStacks;
    }

    public FluidStack getFluidStack() {
        try {
            return FluidHelper.readFluidStackFromPacket(this.dataIn);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getCoords() {
        return new int[]{this.getInt(), this.getInt(), this.getInt()};
    }

    private void writeItemStack(ItemStack theStack) throws IOException {
        if (theStack == null) {
            this.addShort(-1);
        } else {
            this.addShort(Item.func_150891_b((Item)theStack.func_77973_b()));
            this.addByte(theStack.field_77994_a);
            this.addShort(ItemHelper.getItemDamage(theStack));
            this.writeNBT(theStack.field_77990_d);
        }
    }

    public ItemStack readItemStack() throws IOException {
        ItemStack stack = null;
        short itemID = this.getShort();
        if (itemID >= 0) {
            byte stackSize = this.getByte();
            short damage = this.getShort();
            stack = new ItemStack(Item.func_150899_d((int)itemID), (int)stackSize, (int)damage);
            stack.field_77990_d = this.readNBT();
        }
        return stack;
    }

    public void writeNBT(NBTTagCompound nbt) throws IOException {
        if (nbt == null) {
            this.addShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)nbt);
            this.addShort((short)abyte.length);
            this.addByteArray(abyte);
        }
    }

    public NBTTagCompound readNBT() throws IOException {
        short nbtLength = this.getShort();
        if (nbtLength < 0) {
            return null;
        }
        byte[] abyte = new byte[nbtLength];
        this.getByteArray(abyte);
        return CompressedStreamTools.func_152457_a((byte[])abyte, (NBTSizeTracker)new NBTSizeTracker(0x200000L));
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeBytes(this.arrayOut.toByteArray());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dataIn = new DataInputStream(new ByteArrayInputStream(buffer.array()));
        try {
            this.dataIn.skipBytes(1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handlePacket(player, false);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handlePacket(player, true);
    }

    public void handlePacket(EntityPlayer player, boolean isServer) {
    }
}

