/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.feature;

import cofh.lib.util.WeightedRandomBlock;
import cofh.lib.util.helpers.BlockHelper;
import cofh.lib.world.WorldGenMinableCluster;
import cofh.lib.world.feature.FeatureBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class FeatureGenSurface
extends FeatureBase {
    final WorldGenerator worldGen;
    final int count;
    final WeightedRandomBlock[] matList;

    public FeatureGenSurface(String name, WorldGenerator worldGen, List<WeightedRandomBlock> matList, int count, FeatureBase.GenRestriction biomeRes, boolean regen, FeatureBase.GenRestriction dimRes) {
        super(name, biomeRes, regen, dimRes);
        this.worldGen = worldGen;
        this.count = count;
        this.matList = matList.toArray(new WeightedRandomBlock[matList.size()]);
    }

    @Override
    public boolean generateFeature(Random random, int chunkX, int chunkZ, World world) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        boolean generated = false;
        for (int i = 0; i < this.count; ++i) {
            int y;
            Block block;
            int z;
            int x = blockX + random.nextInt(16);
            if (!this.canGenerateInBiome(world, x, z = blockZ + random.nextInt(16), random) || (block = world.func_147439_a(x, y = BlockHelper.getSurfaceBlockY(world, x, z), z)).isAir((IBlockAccess)world, x, y, z) || !WorldGenMinableCluster.canGenerateInBlock(world, x, y, z, this.matList)) continue;
            generated |= this.worldGen.func_76484_a(world, random, x, y + 1, z);
        }
        return generated;
    }
}

