/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.biome;

import cofh.lib.world.biome.BiomeInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;

public class BiomeInfoSet
implements Set<BiomeInfo> {
    protected BiomeInfo[] elementData;
    protected int size;
    protected int modCount;

    public BiomeInfoSet() {
        this(10);
    }

    public BiomeInfoSet(int size) {
        this.elementData = new BiomeInfo[size];
    }

    public BiomeInfoSet(Collection<? extends BiomeInfo> c) {
        this.elementData = c.toArray(new BiomeInfo[c.size()]);
    }

    public void ensureCapacity(int minCapacity) {
        ++this.modCount;
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = Arrays.copyOf(this.elementData, newCapacity);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        BiomeInfo[] oldData = this.elementData;
        if (o instanceof BiomeGenBase) {
            BiomeGenBase bgb = (BiomeGenBase)o;
            int e = this.size;
            for (int i = 0; i < e; ++i) {
                if (oldData[i] == null || !oldData[i].isBiomeEqual(bgb, null)) continue;
                return true;
            }
            return false;
        }
        int e = this.size;
        for (int i = 0; i < e; ++i) {
            if (oldData[i] != o && (oldData[i] == null || o == null || !oldData[i].equals(o))) continue;
            return true;
        }
        return false;
    }

    public boolean contains(BiomeGenBase bgb, Random rand) {
        BiomeInfo[] oldData = this.elementData;
        int e = this.size;
        for (int i = 0; i < e; ++i) {
            if (oldData[i] == null || !oldData[i].isBiomeEqual(bgb, rand)) continue;
            return true;
        }
        return false;
    }

    public BiomeInfo get(int i) {
        if (i < 0 | i >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elementData[i];
    }

    @Override
    public Iterator<BiomeInfo> iterator() {
        return new Itr();
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size, Object[].class);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, a.getClass());
        }
        System.arraycopy(this.elementData, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean add(BiomeInfo e) {
        int i = this.size;
        this.size = i + 1;
        this.ensureCapacity(this.size);
        this.elementData[i] = e;
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int e = this.size;
        for (int i = 0; i < e; ++i) {
            if (this.elementData[i] != o) continue;
            this.fastRemove(i);
            return true;
        }
        return false;
    }

    protected void fastRemove(int index) {
        ++this.modCount;
        int numMoved = this.size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.elementData, index + 1, this.elementData, index, numMoved);
        }
        this.elementData[--this.size] = null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean r = true;
        for (Object i : c) {
            r |= this.contains(i);
        }
        return r;
    }

    @Override
    public boolean addAll(Collection<? extends BiomeInfo> c) {
        int oSize = c.size();
        if (oSize == 0) {
            return false;
        }
        BiomeInfo[] a = c.toArray(new BiomeInfo[oSize]);
        this.ensureCapacity(this.size + oSize);
        System.arraycopy(a, 0, this.elementData, this.size, oSize);
        this.size += oSize;
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        BiomeInfo[] oldData = this.elementData;
        int e = oldData.length;
        this.elementData = new BiomeInfo[c.size() / 2];
        this.size = 0;
        boolean r = true;
        for (Object o : c) {
            for (int i = 0; i < e; ++i) {
                if (oldData[i] != o && (oldData[i] == null || o == null || !oldData[i].equals(o))) continue;
                r |= this.add(oldData[i]);
            }
        }
        return r;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = true;
        for (Object i : c) {
            r |= this.remove(i);
        }
        return r;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    protected class Itr
    implements Iterator<BiomeInfo> {
        protected int cursor = 0;
        protected int expectedModCount;
        protected boolean lastRet;

        protected Itr() {
            this.expectedModCount = BiomeInfoSet.this.modCount;
            this.lastRet = false;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != BiomeInfoSet.this.size;
        }

        @Override
        public BiomeInfo next() {
            this.checkForComodification();
            try {
                if (this.cursor < BiomeInfoSet.this.size) {
                    this.lastRet = true;
                    return BiomeInfoSet.this.elementData[this.cursor++];
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.lastRet) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                this.lastRet = false;
                BiomeInfoSet.this.remove(--this.cursor);
                this.expectedModCount = BiomeInfoSet.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        protected final void checkForComodification() {
            if (BiomeInfoSet.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

