/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.world.biome;

import java.util.Collection;
import java.util.Random;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class BiomeInfo {
    private final Object data;
    private final boolean whitelist;
    private final int type;
    private final int hash;

    public BiomeInfo(String name) {
        this.data = name;
        this.hash = name.hashCode();
        this.whitelist = true;
        this.type = 0;
    }

    public BiomeInfo(Object d, int t, boolean wl) {
        this.data = d;
        this.hash = 0;
        this.whitelist = wl;
        this.type = t;
    }

    public boolean isBiomeEqual(BiomeGenBase biome, Random rand) {
        if (biome != null) {
            switch (this.type) {
                default: {
                    break;
                }
                case 0: {
                    String name = biome.field_76791_y;
                    return name.hashCode() == this.hash && name.equals(this.data);
                }
                case 1: {
                    return biome.func_150561_m() == this.data == this.whitelist;
                }
                case 2: {
                    return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)((BiomeDictionary.Type)this.data)) == this.whitelist;
                }
                case 4: {
                    return ((Collection)this.data).contains(biome.field_76791_y);
                }
                case 5: {
                    return ((Collection)this.data).contains(biome.func_150561_m()) == this.whitelist;
                }
                case 6: {
                    BiomeDictionary.Type[] d = (BiomeDictionary.Type[])this.data;
                    int c = 0;
                    int e = d.length;
                    for (int i = 0; i < e; ++i) {
                        if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)d[i])) continue;
                        ++c;
                    }
                    return c == e == this.whitelist;
                }
            }
        }
        return !this.whitelist;
    }
}

