/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.api.tileentity.ISecurable;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;

public class SecurityHelper {
    private SecurityHelper() {
    }

    public static NBTTagCompound setItemStackTagSecure(NBTTagCompound tag, ISecurable tile) {
        if (tile == null) {
            return null;
        }
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74757_a("Secure", true);
        tag.func_74774_a("Access", (byte)tile.getAccess().ordinal());
        tag.func_74778_a("OwnerUUID", tile.getOwner().getId().toString());
        tag.func_74778_a("Owner", tile.getOwner().getName());
        return tag;
    }

    public static void addOwnerInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            boolean hasUUID = stack.field_77990_d.func_74764_b("OwnerUUID");
            if (!stack.field_77990_d.func_74764_b("Owner") && !hasUUID) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.none"));
            } else if (hasUUID && stack.field_77990_d.func_74764_b("Owner")) {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + stack.field_77990_d.func_74779_i("Owner"));
            } else {
                list.add(StringHelper.localize("info.cofh.owner") + ": " + StringHelper.localize("info.cofh.anotherplayer"));
            }
        }
    }

    public static void addAccessInformation(ItemStack stack, List<String> list) {
        if (SecurityHelper.isSecure(stack)) {
            String accessString = "";
            switch (stack.field_77990_d.func_74771_c("Access")) {
                case 0: {
                    accessString = StringHelper.localize("info.cofh.accessPublic");
                    break;
                }
                case 1: {
                    accessString = StringHelper.localize("info.cofh.accessRestricted");
                    break;
                }
                case 2: {
                    accessString = StringHelper.localize("info.cofh.accessPrivate");
                }
            }
            list.add(StringHelper.localize("info.cofh.access") + ": " + accessString);
        }
    }

    public static boolean isSecure(ItemStack stack) {
        return stack.field_77990_d == null ? false : stack.field_77990_d.func_74764_b("Secure");
    }

    public static ItemStack setSecure(ItemStack stack) {
        if (SecurityHelper.isSecure(stack)) {
            return stack;
        }
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74757_a("Secure", true);
        stack.field_77990_d.func_74774_a("Access", (byte)0);
        return stack;
    }

    public static boolean setAccess(ItemStack stack, ISecurable.AccessMode access) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74774_a("Access", (byte)access.ordinal());
        return true;
    }

    public static ISecurable.AccessMode getAccess(ItemStack stack) {
        return stack.field_77990_d == null ? ISecurable.AccessMode.PUBLIC : ISecurable.AccessMode.values()[stack.field_77990_d.func_74771_c("Access")];
    }

    public static boolean setOwner(ItemStack stack, GameProfile name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.func_77983_a("OwnerUUID", (NBTBase)new NBTTagString(name.getId().toString()));
        stack.func_77983_a("Owner", (NBTBase)new NBTTagString(name.getName()));
        return true;
    }

    public static GameProfile getOwner(ItemStack stack) {
        if (stack.field_77990_d != null) {
            NBTTagCompound nbt = stack.field_77990_d;
            String uuid = nbt.func_74779_i("OwnerUUID");
            String name = nbt.func_74779_i("Owner");
            if (!Strings.isNullOrEmpty((String)uuid)) {
                return new GameProfile(UUID.fromString(uuid), name);
            }
            if (!Strings.isNullOrEmpty((String)name)) {
                return new GameProfile(UUID.fromString(PreYggdrasilConverter.func_152719_a((String)name)), name);
            }
        }
        return new GameProfile(UUID.fromString("1ef1a6f0-87bc-4e78-0a0b-c6824eb787ea"), "[None]");
    }

    public static GameProfile getProfile(UUID uuid, String name) {
        GameProfile owner = MinecraftServer.func_71276_C().func_152358_ax().func_152652_a(uuid);
        if (owner == null) {
            GameProfile temp = new GameProfile(uuid, name);
            owner = MinecraftServer.func_71276_C().func_147130_as().fillProfileProperties(temp, true);
            if (owner != temp) {
                MinecraftServer.func_71276_C().func_152358_ax().func_152649_a(owner);
            }
        }
        return owner;
    }

    @Deprecated
    public static boolean setOwnerName(ItemStack stack, String name) {
        if (!SecurityHelper.isSecure(stack)) {
            return false;
        }
        stack.field_77990_d.func_74778_a("Owner", name);
        return true;
    }

    public static String getOwnerName(ItemStack stack) {
        boolean hasUUID;
        NBTTagCompound nbt = stack.field_77990_d;
        if (nbt == null || !(hasUUID = nbt.func_74764_b("OwnerUUID")) && !nbt.func_74764_b("Owner")) {
            return "[None]";
        }
        return hasUUID ? stack.field_77990_d.func_74779_i("Owner") : StringHelper.localize("info.cofh.anotherplayer");
    }
}

