/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.RegistryDelegate;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.image.BufferedImage;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryNamespaced;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;

public class RegistryUtils {
    private RegistryUtils() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void _(WorldEvent.Load event) {
        if (Repl.replacements.size() < 1) {
            return;
        }
        for (Map.Entry entry : Repl.replacements.entrySet()) {
            RegistryNamespaced reg = (RegistryNamespaced)entry.getKey();
            Multimap map = (Multimap)entry.getValue();
            for (String id : map.keySet()) {
                List c = (List)map.get((Object)id);
                int e = c.size() - 1;
                Object end = c.get(e);
                if (reg.func_148757_b(c.get(0)) == reg.func_148757_b(end)) continue;
                for (int i = 0; i <= e; ++i) {
                    Object t = c.get(i);
                    Object oldThing = reg.func_82594_a(id);
                    Repl.overwrite_do(reg, id, t, oldThing);
                    Repl.alterDelegate(oldThing, end);
                }
            }
        }
    }

    public static void overwriteEntry(RegistryNamespaced registry, String name, Object object) {
        Object oldThing = registry.func_82594_a(name);
        Repl.overwrite_do(registry, name, object, oldThing);
        Multimap reg = (Multimap)Repl.replacements.get(registry);
        if (reg == null) {
            reg = ArrayListMultimap.create();
            Repl.replacements.put(registry, reg);
        }
        if (!reg.containsKey((Object)name)) {
            reg.put((Object)name, oldThing);
        }
        reg.put((Object)name, object);
        Repl.alterDelegateChain(registry, name, object);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean textureExists(ResourceLocation texture) {
        try {
            Minecraft.func_71410_x().func_110442_L().func_135056_b(texture);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean textureExists(String texture) {
        return RegistryUtils.textureExists(new ResourceLocation(texture));
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean blockTextureExists(String texture) {
        int i = texture.indexOf(58);
        texture = i > 0 ? texture.substring(0, i) + ":textures/blocks/" + texture.substring(i + 1, texture.length()) : "textures/blocks/" + texture;
        return RegistryUtils.textureExists(texture + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean itemTextureExists(String texture) {
        int i = texture.indexOf(58);
        texture = i > 0 ? texture.substring(0, i) + ":textures/items/" + texture.substring(i + 1, texture.length()) : "textures/items/" + texture;
        return RegistryUtils.textureExists(texture + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTextureColor(ResourceLocation texture) {
        try {
            BufferedImage image = ImageIO.read(Minecraft.func_71410_x().func_110442_L().func_110536_a(texture).func_110527_b());
            int[] a = new int[image.getWidth() * image.getHeight()];
            image.getRGB(0, 0, image.getWidth(), image.getHeight(), a, 0, image.getWidth());
            int r = a[0];
            int i = a.length;
            while (i-- > 1) {
                int t = a[i];
                int v = ((r >> 24 & 0xFF) + (t >> 24 & 0xFF)) / 2;
                r &= 0xFFFFFF;
                r |= v << 24;
                v = ((r >> 16 & 0xFF) + (t >> 16 & 0xFF)) / 2;
                r &= 0xFF00FFFF;
                r |= v << 16;
                v = ((r >> 8 & 0xFF) + (t >> 8 & 0xFF)) / 2;
                r &= 0xFFFF00FF;
                r |= v << 8;
                v = ((r >> 0 & 0xFF) + (t >> 0 & 0xFF)) / 2;
                r &= 0xFFFFFF00;
                r |= v << 0;
            }
            return r;
        }
        catch (Throwable t) {
            return 0xFFFFFF;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static int getTextureColor(String texture) {
        return RegistryUtils.getTextureColor(new ResourceLocation(texture));
    }

    @SideOnly(value=Side.CLIENT)
    public static int getBlockTextureColor(String texture) {
        int i = texture.indexOf(58);
        texture = i > 0 ? texture.substring(0, i) + ":textures/blocks/" + texture.substring(i + 1, texture.length()) : "textures/blocks/" + texture;
        return RegistryUtils.getTextureColor(texture + ".png");
    }

    @SideOnly(value=Side.CLIENT)
    public static int getItemTextureColor(String texture) {
        int i = texture.indexOf(58);
        texture = i > 0 ? texture.substring(0, i) + ":textures/items/" + texture.substring(i + 1, texture.length()) : "textures/items/" + texture;
        return RegistryUtils.getTextureColor(texture + ".png");
    }

    private static class Repl {
        private static IdentityHashMap<RegistryNamespaced, Multimap<String, Object>> replacements = new IdentityHashMap(2);
        private static Class<RegistryDelegate<?>> DelegateClass;

        private Repl() {
        }

        private static void overwrite_do(RegistryNamespaced registry, String name, Object object, Object oldThing) {
            int id = registry.func_148757_b(oldThing);
            BiMap map = (BiMap)registry.field_82596_a;
            registry.field_148759_a.func_148746_a(object, id);
            map.remove((Object)name);
            map.forcePut((Object)name, object);
        }

        private static void alterDelegateChain(RegistryNamespaced registry, String id, Object object) {
            Multimap<String, Object> map = replacements.get(registry);
            List c = (List)map.get((Object)id);
            int e = c.size() - 1;
            Object end = c.get(e);
            for (int i = 0; i <= e; ++i) {
                Object t = c.get(i);
                Repl.alterDelegate(t, end);
            }
        }

        private static void alterDelegate(Object obj, Object repl) {
            if (obj instanceof Item) {
                RegistryDelegate delegate = ((Item)obj).delegate;
                ReflectionHelper.setPrivateValue(DelegateClass, (Object)delegate, (Object)repl, (String[])new String[]{"referant"});
            }
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)new RegistryUtils());
            try {
                DelegateClass = Class.forName("cpw.mods.fml.common.registry.RegistryDelegate$Delegate");
            }
            catch (Throwable e) {
                Throwables.propagate((Throwable)e);
            }
        }
    }
}

