/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.tiles;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.entities.ai.inventory.AIFillGoto;
import thaumcraft.common.entities.golems.EntityGolemBase;
import tuhljin.automagy.entities.GolemLink;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.inventory.MappedItemsOrderedByTimeAdded;
import tuhljin.automagy.tiles.IGolemLinkableDevice;
import tuhljin.automagy.tiles.IInventariumMemoryUser;
import tuhljin.automagy.tiles.ModTileEntity;
import tuhljin.automagy.tiles.TileEntityInventarium;

public class TileEntityGolemTaskmaster
extends ModTileEntity
implements IGolemLinkableDevice,
IInventariumMemoryUser {
    public static final int FILL_CORE = 0;
    public static int MAX_LINKS = 6;
    public static int RANGE = 5;
    public static int FREQUENCY_HASREQUESTS = 1;
    public static int FREQUENCY_NOREQUESTS = 20;
    public int numLinksSeen = 0;
    public int linkX;
    public int linkY = -1;
    public int linkZ;
    private String linkName = null;
    private int nextGolemUpdate = 0;
    public static int rotationSpeedFactor = 3240;
    public static double clientRenderFloatingTop = 0.3;
    public int clientRenderRotationHelper = 0;
    public double clientRenderFloatingDistance = 0.0;
    private String linkID = null;
    EntitySelectorRequestGolem entitySelectorRequestGolem = new EntitySelectorRequestGolem();

    public boolean isActive() {
        return this.linkY != -1;
    }

    public int getRange() {
        return RANGE;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        boolean active = this.isActive();
        if (this.field_145850_b.field_72995_K) {
            if (active) {
                if (this.clientRenderFloatingDistance < clientRenderFloatingTop) {
                    this.clientRenderFloatingDistance += 0.008;
                }
                if (this.clientRenderFloatingDistance > clientRenderFloatingTop / 2.0) {
                    this.clientRenderRotationHelper += 5;
                    if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                        this.clientRenderRotationHelper -= rotationSpeedFactor;
                    }
                }
            } else {
                if (this.clientRenderRotationHelper != 0) {
                    this.clientRenderRotationHelper = this.clientRenderRotationHelper > rotationSpeedFactor / 2 ? (this.clientRenderRotationHelper += 16) : (this.clientRenderRotationHelper -= 16);
                    if (this.clientRenderRotationHelper >= rotationSpeedFactor) {
                        this.clientRenderRotationHelper -= rotationSpeedFactor;
                    }
                    if (this.clientRenderRotationHelper <= 16) {
                        this.clientRenderRotationHelper = 0;
                    }
                } else if (this.clientRenderFloatingDistance > 0.0) {
                    this.clientRenderFloatingDistance -= 0.005;
                    if (this.clientRenderFloatingDistance < 0.01) {
                        this.clientRenderFloatingDistance = 0.0;
                    }
                }
                return;
            }
        }
        if (this.nextGolemUpdate > 0) {
            --this.nextGolemUpdate;
            if (this.nextGolemUpdate > 0) {
                return;
            }
        }
        this.nextGolemUpdate = FREQUENCY_NOREQUESTS;
        this.numLinksSeen = 0;
        if (active) {
            TileEntityInventarium teInv = null;
            MappedItemsOrderedByTimeAdded requests = null;
            if (!this.field_145850_b.field_72995_K) {
                TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
                if (!(te instanceof TileEntityInventarium)) {
                    this.linkY = -1;
                    this.func_70296_d();
                    return;
                }
                teInv = (TileEntityInventarium)te;
                requests = teInv.getRequestedItems();
                if (requests.size() > 0) {
                    this.nextGolemUpdate = FREQUENCY_HASREQUESTS;
                }
            }
            int grabRange = this.getRange();
            AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - grabRange), (double)((double)this.field_145848_d - 1.5), (double)(this.field_145849_e - grabRange), (double)(this.field_145851_c + grabRange + 1), (double)(this.field_145848_d + grabRange), (double)(this.field_145849_e + grabRange + 1));
            List entities = this.field_145850_b.func_82733_a(EntityGolemBase.class, box, (IEntitySelector)this.entitySelectorRequestGolem);
            for (Entity entity : entities) {
                AIFillGoto task;
                boolean preciseMode;
                EntityGolemBase golem = (EntityGolemBase)entity;
                if (this.field_145850_b.field_72995_K) continue;
                boolean bl = preciseMode = !golem.getToggles()[0];
                if (!preciseMode) {
                    golem.setToggle(0, false);
                }
                if ((task = this.getGolemFillTask((EntityLiving)golem)) == null) continue;
                boolean filterOK = true;
                Iterator<Map.Entry<HashableItemWithoutSize, Integer>> iter = requests.getIterator();
                while (iter.hasNext()) {
                    filterOK = false;
                    Map.Entry<HashableItemWithoutSize, Integer> entry = iter.next();
                    HashableItemWithoutSize item = entry.getKey();
                    int amt = entry.getValue() - teInv.getRequestedAmountEnRoute(item);
                    if (amt <= 0) continue;
                    ItemStack stack = item.getItemStack(amt);
                    int max = Math.min(Math.min(stack.func_77976_d(), golem.getCarryLimit()), 127);
                    if (stack.field_77994_a > max) {
                        stack.field_77994_a = max;
                    }
                    ThaumcraftExtension.setGolemItemFilter(golem, stack);
                    int prevTicksExisted = golem.field_70173_aa;
                    golem.field_70173_aa = 0;
                    if (task.func_75250_a()) {
                        teInv.markRequestEnRoute(golem, stack);
                        filterOK = true;
                        break;
                    }
                    golem.field_70173_aa = prevTicksExisted;
                }
                if (filterOK) continue;
                ThaumcraftExtension.clearGolemItemFilter(golem);
            }
        }
    }

    public TileEntityInventarium getLinkedInventarium() {
        TileEntity te = this.field_145850_b.func_147438_o(this.linkX, this.linkY, this.linkZ);
        if (te instanceof TileEntityInventarium) {
            return (TileEntityInventarium)te;
        }
        return null;
    }

    @Override
    public String getGolemLinkID() {
        if (this.linkID == null) {
            if (this.linkName == null || this.linkName.isEmpty()) {
                if (this.field_145850_b.field_72995_K) {
                    return null;
                }
                int t = (int)(System.currentTimeMillis() / 1000L);
                this.linkName = Integer.toHexString(t);
                this.func_70296_d();
            }
            this.linkID = this.linkName + ":" + this.field_145850_b.field_73011_w.field_76574_g + "," + this.field_145851_c + "," + this.field_145848_d + "," + this.field_145849_e;
        }
        return this.linkID;
    }

    @Override
    public void forgetGolemLinkID() {
        int t = (int)(System.currentTimeMillis() / 1000L);
        this.linkName = Integer.toHexString(t);
        this.linkID = null;
        this.func_70296_d();
        if (this.numLinksSeen > 0) {
            Thaumcraft.proxy.sparkle((float)this.field_145851_c + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, (float)this.field_145848_d + 0.2f, (float)this.field_145849_e + 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.6f, 1.0f, 5, -0.1f);
        }
    }

    private AIFillGoto getGolemFillTask(EntityLiving entity) {
        for (EntityAITasks.EntityAITaskEntry entityaitaskentry : entity.field_70714_bg.field_75782_a) {
            EntityAIBase entityaibase1 = entityaitaskentry.field_75733_a;
            if (!(entityaibase1 instanceof AIFillGoto)) continue;
            return (AIFillGoto)entityaibase1;
        }
        return null;
    }

    @Override
    public void breakLink() {
        this.linkY = -1;
        this.func_70296_d();
    }

    @Override
    public void setLink(TileEntityInventarium teInv) {
        this.linkX = teInv.field_145851_c;
        this.linkY = teInv.field_145848_d;
        this.linkZ = teInv.field_145849_e;
        this.func_70296_d();
    }

    @Override
    public boolean isLinkedTo(TileEntityInventarium te) {
        return te.field_145851_c == this.linkX && te.field_145848_d == this.linkY && te.field_145849_e == this.linkZ;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbttagcompound) {
        if (this.linkName == null && this.getGolemLinkID() == null) {
            return;
        }
        nbttagcompound.func_74778_a("linkName", this.linkName);
        nbttagcompound.func_74768_a("linkX", this.linkX);
        nbttagcompound.func_74768_a("linkY", this.linkY);
        nbttagcompound.func_74768_a("linkZ", this.linkZ);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbttagcompound) {
        String newLinkName = nbttagcompound.func_74779_i("linkName");
        if (!newLinkName.equals(this.linkName)) {
            this.linkName = newLinkName;
            this.linkID = null;
        }
        this.linkX = nbttagcompound.func_74762_e("linkX");
        this.linkY = nbttagcompound.func_74762_e("linkY");
        this.linkZ = nbttagcompound.func_74762_e("linkZ");
    }

    public class EntitySelectorRequestGolem
    implements IEntitySelector {
        public boolean func_82704_a(Entity entity) {
            if (TileEntityGolemTaskmaster.this.numLinksSeen >= MAX_LINKS) {
                return false;
            }
            EntityGolemBase golem = (EntityGolemBase)entity;
            if (GolemLink.golemLinkedTo(golem, TileEntityGolemTaskmaster.this)) {
                ++TileEntityGolemTaskmaster.this.numLinksSeen;
                if (!golem.inactive && !golem.paused && golem.field_70159_w == 0.0 && Math.abs(golem.field_70181_x) < 0.1 && golem.field_70179_y == 0.0 && golem.getCore() == 0 && golem.getCarried() == null && !TileEntityInventarium.isGolemEnRoute(golem)) {
                    return true;
                }
            }
            return false;
        }
    }
}

