/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.api.wands.FocusUpgradeType;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.blocks.BlockCosmeticSolid;
import thaumcraft.common.blocks.BlockStoneDevice;
import thaumcraft.common.blocks.BlockWoodenDevice;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.entities.InventoryMob;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.monster.EntityPech;
import thaumcraft.common.items.ItemResource;
import thaumcraft.common.items.armor.ItemHoverHarness;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketResearchComplete;
import thaumcraft.common.lib.research.ScanManager;
import thaumcraft.common.lib.world.ThaumcraftWorldGenerator;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileHole;
import thaumcraft.common.tiles.TileMirror;
import thaumcraft.common.tiles.TileMirrorEssentia;
import thaumcraft.common.tiles.TileWandPedestal;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.inventory.HashableItemWithoutSize;
import tuhljin.automagy.lib.struct.WorldSpecificCoordinates;

public class ThaumcraftExtension {
    private static Boolean reservoirClassExists = null;
    static Method placeItemStackIntoInventory;
    static Method setBiomeAt;

    public static void setupPechTrade() {
        HashMap valuedItems = null;
        try {
            Field f = ReflectionHelper.findField(EntityPech.class, (String[])new String[]{"valuedItems"});
            valuedItems = (HashMap)f.get(null);
        }
        catch (Exception ex) {
            FMLLog.severe((String)"[Automagy] Error: Failed to alter what pechs value.", (Object[])new Object[0]);
        }
        if (valuedItems != null) {
            valuedItems.put(Item.func_150891_b((Item)ModItems.edible), 7);
        }
    }

    public static boolean addFluxTaintPotionEffect(EntityLivingBase entity, int duration, int amplifier) {
        try {
            entity.func_70690_d(new PotionEffect(PotionFluxTaint.instance.field_76415_H, duration, amplifier, false));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean playerHasWandEquipped(EntityPlayer player) {
        ItemStack stack = player.func_71045_bC();
        return stack != null && stack.func_77973_b() instanceof ItemWandCasting;
    }

    public static boolean wandIsStaff(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWandCasting) {
            return ((ItemWandCasting)stack.func_77973_b()).isStaff(stack);
        }
        return false;
    }

    public static ItemStack getStackInRechargePedestal(TileEntity te) {
        if (!(te instanceof TileWandPedestal)) {
            return null;
        }
        ItemStack stack = null;
        if (!(te instanceof IInventory)) {
            FMLLog.warning((String)"[Automagy] Error: Expected TileWandPedestal to implement IInventory.", (Object[])new Object[0]);
            return null;
        }
        try {
            stack = ((IInventory)te).func_70301_a(0);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Could not invoke TileWandPedestal method getStackInSlot.", (Object[])new Object[0]);
            return null;
        }
        return stack;
    }

    public static boolean blockIsPedestal(Block block, int metadata, boolean allowWandRecharger) {
        if (block instanceof BlockStoneDevice) {
            if (metadata == 1) {
                return true;
            }
            if (metadata == 5) {
                return allowWandRecharger;
            }
        }
        return false;
    }

    public static boolean blockIsArcaneBore(Block block, int metadata, boolean allowWandRecharger) {
        if (block instanceof BlockWoodenDevice) {
            return metadata == 5;
        }
        return false;
    }

    public static boolean tileIsPortableHole(TileEntity te, Block block) {
        return te instanceof TileHole && (block == null || ((TileHole)te).oldblock == block);
    }

    public static boolean blockIsFetter(World world, int x, int y, int z, boolean activeOnly) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof BlockCosmeticSolid) {
            int metadata = world.func_72805_g(x, y, z);
            if (metadata == 9) {
                return !activeOnly;
            }
            if (metadata == 10) {
                return true;
            }
        }
        return false;
    }

    public static boolean blockIsObsidianTotem(IBlockAccess blockaccess, int x, int y, int z) {
        Block block = blockaccess.func_147439_a(x, y, z);
        if (block instanceof BlockCosmeticSolid) {
            return blockaccess.func_72805_g(x, y, z) == 0;
        }
        return false;
    }

    public static boolean tileIsMirror(TileEntity te) {
        return te instanceof TileMirror || te instanceof TileMirrorEssentia;
    }

    public static boolean itemIsJarLabel(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemResource && stack.func_77960_j() == 13;
    }

    public static EssentiaJarItemRef getJarFromHarness(ItemStack stack) {
        Item item;
        ItemStack jarStack;
        if (stack != null && stack.func_77973_b() instanceof ItemHoverHarness && stack.func_77942_o() && (jarStack = ItemStack.func_77949_a((NBTTagCompound)stack.field_77990_d.func_74775_l("jar"))) != null && (item = jarStack.func_77973_b()) instanceof ItemJarFilled) {
            EssentiaJarItemRef jar = new EssentiaJarItemRef(jarStack, (ItemJarFilled)item);
            return jar;
        }
        return null;
    }

    public static boolean objectIsEssentiaReservoir(Object obj) {
        if (reservoirClassExists == null) {
            reservoirClassExists = false;
            try {
                Class.forName("thaumcraft.common.tiles.TileEssentiaReservoir");
                reservoirClassExists = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!reservoirClassExists.booleanValue()) {
            return false;
        }
        return obj instanceof TileEssentiaReservoir;
    }

    public static AspectList getAspectsFromItem(ItemStack stack) {
        if (stack.func_77942_o()) {
            AspectList aspects = new AspectList();
            aspects.readFromNBT(stack.func_77978_p());
            return aspects.size() > 0 ? aspects : null;
        }
        return null;
    }

    public static boolean isResearchComplete(EntityPlayer player, String key) {
        String name = player.func_70005_c_();
        return ThaumcraftApiHelper.isResearchComplete((String)name, (String)key);
    }

    public static boolean isResearchDiscovered(EntityPlayer player, String key) {
        String name = player.func_70005_c_();
        return ThaumcraftApiHelper.isResearchComplete((String)name, (String)key) || ThaumcraftApiHelper.isResearchComplete((String)name, (String)("@" + key));
    }

    public static void triggerResearchUnlock(EntityPlayerMP player, String key) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketResearchComplete("@" + key), player);
        Thaumcraft.proxy.getResearchManager().completeResearch((EntityPlayer)player, "@" + key);
    }

    public static WorldSpecificCoordinates getLinkedMirrorCoordinates(TileEntity te) {
        if (te instanceof TileMirror) {
            TileMirror tem = (TileMirror)te;
            if (tem.linked) {
                return new WorldSpecificCoordinates(tem.linkDim, tem.linkX, tem.linkY, tem.linkZ);
            }
        } else if (te instanceof TileMirrorEssentia) {
            TileMirrorEssentia tem = (TileMirrorEssentia)te;
            if (tem.linked) {
                return new WorldSpecificCoordinates(tem.linkDim, tem.linkX, tem.linkY, tem.linkZ);
            }
        }
        return null;
    }

    public static int getTemporaryWarp(EntityPlayer player) {
        return Thaumcraft.proxy.getPlayerKnowledge().getWarpTemp(player.func_70005_c_());
    }

    public static int getStickyWarp(EntityPlayer player) {
        return Thaumcraft.proxy.getPlayerKnowledge().getWarpSticky(player.func_70005_c_());
    }

    public static void resetWarpCounter(EntityPlayer player) {
        Thaumcraft.proxy.getPlayerKnowledge().setWarpCounter(player.func_70005_c_(), Thaumcraft.proxy.getPlayerKnowledge().getWarpTotal(player.func_70005_c_()));
    }

    public static ItemFocusBasic getWandFocus(ItemStack wand) {
        Item focus;
        ItemStack stack;
        Item wi = wand.func_77973_b();
        if (wi instanceof ItemWandCasting && (stack = ((ItemWandCasting)wi).getFocusItem(wand)) != null && (focus = stack.func_77973_b()) instanceof ItemFocusBasic) {
            return (ItemFocusBasic)focus;
        }
        return null;
    }

    public static ItemStack getWandFocusStack(ItemStack wand) {
        Item wi = wand.func_77973_b();
        if (wi instanceof ItemWandCasting) {
            return ((ItemWandCasting)wi).getFocusItem(wand);
        }
        return null;
    }

    public static ItemStack applyWandFocus(ItemStack wandStack, ItemStack focusStack, boolean allowOverwrite) {
        if (wandStack.func_77973_b() instanceof ItemWandCasting) {
            ItemWandCasting wand = (ItemWandCasting)wandStack.func_77973_b();
            ItemStack prevFocus = wand.getFocusItem(wandStack);
            if (allowOverwrite || prevFocus == null) {
                wand.setFocus(wandStack, focusStack);
            }
            return prevFocus;
        }
        return null;
    }

    public static boolean playerIsWearingBauble(EntityPlayer player, HashableItemWithoutSize item) {
        IInventory baubles = BaublesApi.getBaubles((EntityPlayer)player);
        if (baubles != null) {
            int size = baubles.func_70302_i_();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = baubles.func_70301_a(i);
                if (stack == null || !item.isSameItem(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areAspectListsIdentical(AspectList a, AspectList b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (Aspect aspect : a.getAspects()) {
            if (a.getAmount(aspect) == b.getAmount(aspect)) continue;
            return false;
        }
        return true;
    }

    public static AspectWithAmount drawEssentia(IBlockAccess blockaccess, int x, int y, int z, ForgeDirection orientation, AspectList extractAspectAmounts, int suction) {
        TileEntity te = ThaumcraftApiHelper.getConnectableTile((IBlockAccess)blockaccess, (int)x, (int)y, (int)z, (ForgeDirection)orientation);
        if (te != null) {
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (!ic.canOutputTo(orientation.getOpposite())) {
                return null;
            }
            for (Aspect aspect : extractAspectAmounts.aspects.keySet()) {
                int takeMax;
                int took;
                if (ic.getSuctionType(orientation.getOpposite()) != aspect || ic.getSuctionAmount(orientation.getOpposite()) >= suction || suction < ic.getMinimumSuction() || (took = ic.takeEssentia(aspect, takeMax = extractAspectAmounts.getAmount(aspect), orientation.getOpposite())) <= 0) continue;
                return new AspectWithAmount(aspect, took);
            }
        }
        return null;
    }

    public static ItemStack insertStackIntoInventory(ItemStack stack, IInventory inv, int side, boolean doit) {
        ItemStack result;
        if (placeItemStackIntoInventory == null) {
            try {
                Class clazz = ReflectionHelper.getClass((ClassLoader)ThaumcraftExtension.class.getClassLoader(), (String[])new String[]{"thaumcraft.common.lib.utils.InventoryUtils", "thaumcraft.common.lib.InventoryHelper"});
                placeItemStackIntoInventory = clazz.getMethod("placeItemStackIntoInventory", ItemStack.class, IInventory.class, Integer.TYPE, Boolean.TYPE);
            }
            catch (Exception ex) {
                FMLLog.warning((String)"[Automagy] Error: Could not find inventory utility method.", (Object[])new Object[0]);
                return stack;
            }
        }
        try {
            result = (ItemStack)placeItemStackIntoInventory.invoke(null, stack, inv, side, doit);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Error: Could not invoke inventory utility method.", (Object[])new Object[0]);
            return stack;
        }
        return result;
    }

    public static boolean isBiomeEerie(World world, int x, int z) {
        BiomeGenBase bg = world.func_72807_a(x, z);
        return bg.field_76756_M == ThaumcraftWorldGenerator.biomeEerie.field_76756_M;
    }

    public static void setBiomeToEerie(World world, int x, int z) {
        if (setBiomeAt == null) {
            try {
                Class clazz = ReflectionHelper.getClass((ClassLoader)ThaumcraftExtension.class.getClassLoader(), (String[])new String[]{"thaumcraft.common.lib.utils.Utils", "thaumcraft.common.lib.Utils"});
                setBiomeAt = clazz.getMethod("setBiomeAt", World.class, Integer.TYPE, Integer.TYPE, BiomeGenBase.class);
            }
            catch (Exception ex) {
                FMLLog.warning((String)"[Automagy] Error: Could not invoke set biome utility method.", (Object[])new Object[0]);
                return;
            }
        }
        try {
            setBiomeAt.invoke(null, world, x, z, ThaumcraftWorldGenerator.biomeEerie);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Automagy] Error: Could not invoke set biome utility method.", (Object[])new Object[0]);
        }
    }

    public static boolean canGolemTake(EntityGolemBase golem, ItemStack stack) {
        if (golem != null && stack != null) {
            InventoryMob inv = golem.inventory;
            int size = golem.inventory.slotCount;
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack2 = inv.func_70301_a(slot);
                if (!TjUtil.areItemsEqualIgnoringSize(stack, stack2)) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack giveItemToGolem(EntityGolemBase golem, ItemStack stack) {
        ItemStack carried = golem.getCarried();
        int max = 0;
        if (carried == null) {
            max = golem.getCarryLimit();
            carried = stack.func_77946_l();
            carried.field_77994_a = 0;
        } else if (TjUtil.canItemsStack(stack, carried)) {
            max = golem.getCarrySpace();
        }
        ItemStack leftover = stack.func_77946_l();
        if (max < 1) {
            return leftover;
        }
        int change = Math.min(max, stack.field_77994_a);
        carried.field_77994_a += change;
        golem.setCarried(carried);
        leftover.field_77994_a -= change;
        return leftover.field_77994_a > 0 ? leftover : null;
    }

    public static void makeGolemDrop(EntityGolemBase golem, int amt) {
        ItemStack carried = golem.getCarried();
        if (carried != null) {
            amt = Math.min(amt, carried.field_77994_a);
            ItemStack dropStack = carried.func_77946_l();
            dropStack.field_77994_a = amt;
            TjUtil.dropItemIntoWorldSimple(dropStack, golem.field_70170_p, golem.field_70165_t, golem.field_70163_u + 0.1, golem.field_70161_v);
            int leftover = carried.field_77994_a - amt;
            if (leftover > 0) {
                carried.field_77994_a = leftover;
                golem.setCarried(carried);
            } else {
                golem.setCarried(null);
            }
        }
    }

    public static void limitGolemCarrying(EntityGolemBase golem, int max) {
        ItemStack carried = golem.getCarried();
        if (carried != null && carried.field_77994_a > max) {
            ThaumcraftExtension.makeGolemDrop(golem, carried.field_77994_a - max);
        }
    }

    public static boolean setGolemItemFilter(EntityGolemBase golem, ItemStack ... stacks) {
        if (golem == null) {
            return false;
        }
        boolean changed = false;
        InventoryMob inv = golem.inventory;
        int size = golem.inventory.slotCount;
        int listSize = stacks == null ? 0 : stacks.length;
        for (int slot = 0; slot < size; ++slot) {
            ItemStack oldStack;
            ItemStack newStack;
            ItemStack itemStack = newStack = slot < listSize ? stacks[slot] : null;
            if (newStack != null && newStack.field_77994_a > 256) {
                newStack.field_77994_a = 256;
            }
            if (ItemStack.func_77989_b((ItemStack)newStack, (ItemStack)(oldStack = inv.func_70301_a(slot)))) continue;
            inv.func_70299_a(slot, newStack);
            changed = true;
        }
        if (changed) {
            inv.func_70296_d();
        }
        return changed;
    }

    public static boolean clearGolemItemFilter(EntityGolemBase golem) {
        return ThaumcraftExtension.setGolemItemFilter(golem, new ItemStack[]{null});
    }

    public static ArrayList<ItemStack> getGolemItemFilter(EntityGolemBase golem) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        InventoryMob inv = golem.inventory;
        int size = golem.inventory.slotCount;
        for (int slot = 0; slot < size; ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null) continue;
            stacks.add(stack);
        }
        return stacks;
    }

    public static FocusUpgradeType createFocusUpgrade(int id, String name, AspectList cost) {
        return new FocusUpgradeType(id, new ResourceLocation("Automagy".toLowerCase(), "textures/foci/" + name + ".png"), "Automagy.focus.upgrade." + name + ".name", "Automagy.focus.upgrade." + name + ".text", cost);
    }

    public static AspectList getObjectTotalAspects(ItemStack stack) {
        AspectList tags = ThaumcraftApiHelper.getObjectAspects((ItemStack)stack);
        tags = ThaumcraftApiHelper.getBonusObjectTags((ItemStack)stack, (AspectList)tags);
        return tags;
    }

    public static boolean hasPlayerScanned(EntityPlayer player, ItemStack stack) {
        int h = ScanManager.generateItemHash((Item)stack.func_77973_b(), (int)stack.func_77960_j());
        List list = (List)Thaumcraft.proxy.getScannedObjects().get(player.func_70005_c_());
        return list != null && (list.contains("@" + h) || list.contains("#" + h));
    }

    public static class AspectWithAmount {
        public Aspect aspect;
        public int amount;

        public AspectWithAmount(Aspect aspect, int amount) {
            this.aspect = aspect;
            this.amount = amount;
        }
    }

    public static class EssentiaJarItemRef {
        public ItemStack stack;
        public ItemJarFilled item;

        public EssentiaJarItemRef(ItemStack stack, ItemJarFilled item) {
            this.stack = stack;
            this.item = item;
        }

        public AspectList getAspects() {
            AspectList aspects = this.item.getAspects(this.stack);
            return aspects;
        }

        public void setAspects(AspectList aspects) {
            this.item.setAspects(this.stack, aspects);
        }
    }
}

