/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.lib;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import tuhljin.automagy.Automagy;
import tuhljin.automagy.api.AutomagyAPI;
import tuhljin.automagy.blocks.BlockNethermind;
import tuhljin.automagy.blocks.ModBlocks;

public class AutomagyConfig {
    protected static Configuration config;
    public static final String CATEGORY_NETHERMIND = "nethermind";
    public static final String CATEGORY_LOOT = "loot";
    public static final String CATEGORY_KEYS = "keys";
    public static boolean versionChecking;
    public static boolean listCreativeJar;
    public static boolean listThinkingCap;
    public static boolean usableThinkingCap;
    public static boolean redcrystalEmitsLight;
    public static boolean thirstyTankDrinksRain;
    public static boolean useMFRMilk;
    public static boolean useMFRMushroomSoup;
    public static boolean overrideMFRMilkAspects;
    public static boolean overrideMFRMushroomSoupAspects;
    public static int lootWeightRingEnderDisjunctionLesser;
    public static boolean netherHeartDrops;
    public static boolean netherHeartDropNetherOnly;
    public static int nethermindBasicLavaChance;
    public static AspectList nethermindRockCostBasic;
    public static AspectList nethermindRockCost;
    public static AspectList nethermindLavaCost;
    public static AspectList nethermindQuartzCost;
    public static AspectList nethermindSoulSandCost;
    public static int nethermindRockSpeed;
    public static int nethermindLavaSpeed;
    public static int nethermindQuartzSpeed;
    public static int nethermindSoulSandSpeed;
    public static int focusUpgradeGratis;
    public static int focusUpgradeTransposing;
    public static int focusUpgradeStorage;
    public static int defaultKeyCraft;

    public static void load(File file) {
        config = new Configuration(file);
        config.load();
        config.addCustomCategoryComment(CATEGORY_LOOT, "Loot weights. Higher for higher chance. 1 is rare. 0 disables.");
        versionChecking = AutomagyConfig.loadBoolean("version_checking", "On startup, check whether a newer version of the mod exists", true);
        listCreativeJar = AutomagyConfig.loadBoolean("list_creative_jar", "Show the Infinity Jar in Creative Tab and NEI", true);
        listThinkingCap = AutomagyConfig.loadBoolean("list_thinking_cap", "Show the thinking cap in Creative Tab and NEI", true);
        usableThinkingCap = AutomagyConfig.loadBoolean("thinking_cap_usable", "Allow the thinking cap to be used to craft advanced golems", true);
        redcrystalEmitsLight = AutomagyConfig.loadBoolean("redcrystal_emits_light", "Should redcrystal emit light when it has a redstone signal", true);
        thirstyTankDrinksRain = AutomagyConfig.loadBoolean("thirstytank_drink_rain", "Should thirsty tanks slowly fill with water if exposed to the sky while it is raining", true);
        useMFRMilk = AutomagyConfig.loadBoolean("mfr_milk_used", "Should MineFactory Reloaded's milk be created when the thirsty tank milks cows rather than Automagy's own", useMFRMilk);
        useMFRMushroomSoup = AutomagyConfig.loadBoolean("mfr_mushroom_soup_used", "Should MineFactory Reloaded's mushroom soup be created when the thirsty tank milks mooshrooms rather than Automagy's own", useMFRMushroomSoup);
        overrideMFRMilkAspects = AutomagyConfig.loadBoolean("mfr_override_aspect_milk", "Should Automagy change the Aspects associated with MineFactory Reloaded's milk (arguably more balanced if we do, given what Automagy can do with it)", overrideMFRMilkAspects);
        overrideMFRMushroomSoupAspects = AutomagyConfig.loadBoolean("mfr_override_aspect_mushroom_soup", "Should Automagy change the Aspects associated with MineFactory Reloaded's mushroom soup", overrideMFRMushroomSoupAspects);
        lootWeightRingEnderDisjunctionLesser = AutomagyConfig.loadInteger(CATEGORY_LOOT, "lesser_disjunction", "Lesser Ring of Ender Disjunction", lootWeightRingEnderDisjunctionLesser);
        netherHeartDrops = AutomagyConfig.loadBoolean("emberheart_spawnerdrop", "Make blaze spawners drop an ember heart", true);
        netherHeartDropNetherOnly = AutomagyConfig.loadBoolean("emberheart_spawnerdrop_netheronly", "Only drop ember heart from spawners in the Nether", true);
        nethermindBasicLavaChance = AutomagyConfig.loadInteger(CATEGORY_NETHERMIND, "lava_basic_chance", "Percentage chance that a basic rune results in conjuring lava instead of netherrack.", BlockNethermind.defaultLavaChance);
        nethermindRockCostBasic = AutomagyConfig.loadAspectList(CATEGORY_NETHERMIND, "netherrack_basic_cost", "Nethermind's essentia cost to generate netherrack without the Rock rune.", BlockNethermind.defaultRockCostBasic);
        nethermindRockCost = AutomagyConfig.loadAspectList(CATEGORY_NETHERMIND, "netherrack_cost", "Nethermind's essentia cost to generate netherrack using the Rock rune.", BlockNethermind.defaultRockCost);
        nethermindRockSpeed = AutomagyConfig.loadInteger(CATEGORY_NETHERMIND, "netherrack_speed", null, BlockNethermind.defaultRockSpeed);
        nethermindLavaCost = AutomagyConfig.loadAspectList(CATEGORY_NETHERMIND, "lava_cost", "Nethermind's essentia cost to generate lava.", BlockNethermind.defaultLavaCost);
        nethermindLavaSpeed = AutomagyConfig.loadInteger(CATEGORY_NETHERMIND, "lava_speed", null, BlockNethermind.defaultLavaSpeed);
        nethermindQuartzCost = AutomagyConfig.loadAspectList(CATEGORY_NETHERMIND, "quartz_cost", "Nethermind's essentia cost to generate quartz ore.", BlockNethermind.defaultQuartzCost);
        nethermindQuartzSpeed = AutomagyConfig.loadInteger(CATEGORY_NETHERMIND, "quartz_speed", null, BlockNethermind.defaultQuartzSpeed);
        nethermindSoulSandCost = AutomagyConfig.loadAspectList(CATEGORY_NETHERMIND, "soulsand_cost", "Nethermind's essentia cost to generate soul sand.", BlockNethermind.defaultSoulSandCost);
        nethermindSoulSandSpeed = AutomagyConfig.loadInteger(CATEGORY_NETHERMIND, "soulsand_speed", null, BlockNethermind.defaultSoulSandSpeed);
        boolean nethermindIgnoreCustom = AutomagyConfig.loadBoolean(CATEGORY_NETHERMIND, "ignore_section", "IMPORTANT: If true, this section's customizations will be ignored. (This is useful for those who want to use the default settings since the defaults may change with a newer version of Automagy. Otherwise, you'd need to delete this section each time such an update is applied.)", true);
        if (nethermindIgnoreCustom) {
            nethermindBasicLavaChance = BlockNethermind.defaultLavaChance;
            nethermindRockCostBasic = BlockNethermind.defaultRockCostBasic;
            nethermindRockCost = BlockNethermind.defaultRockCost;
            nethermindRockSpeed = BlockNethermind.defaultRockSpeed;
            nethermindLavaCost = BlockNethermind.defaultLavaCost;
            nethermindLavaSpeed = BlockNethermind.defaultLavaSpeed;
            nethermindQuartzCost = BlockNethermind.defaultQuartzCost;
            nethermindQuartzSpeed = BlockNethermind.defaultQuartzSpeed;
            nethermindSoulSandCost = BlockNethermind.defaultSoulSandCost;
            nethermindSoulSandSpeed = BlockNethermind.defaultSoulSandSpeed;
        }
        focusUpgradeGratis = AutomagyConfig.loadInteger("focus_id_gratis", null, focusUpgradeGratis);
        focusUpgradeTransposing = AutomagyConfig.loadInteger("focus_id_transposing", null, focusUpgradeTransposing);
        focusUpgradeStorage = AutomagyConfig.loadInteger("focus_id_storage", null, focusUpgradeStorage);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT) {
            config.addCustomCategoryComment(CATEGORY_KEYS, "Default keybindings. Can still be adjusted by the player in-game.");
            defaultKeyCraft = AutomagyConfig.loadKeyBinding("focus_craft", "Wand Focus: Crafting - open GUI", defaultKeyCraft);
        }
    }

    public static void loadPostInit() {
        String[] arr = AutomagyConfig.loadStringArray("general", "inventarium_container_blacklist", "A list of any block names for containers that the Inventarium / Unseen Scribes should ignore.", new String[]{Block.field_149771_c.func_148750_c((Object)ModBlocks.tallyBlock)});
        if (arr != null && arr.length > 0) {
            for (String s : arr) {
                try {
                    Block b = Block.func_149684_b((String)s);
                    if (b != null) {
                        AutomagyAPI.invContainerBlacklist.add(b);
                        continue;
                    }
                    FMLLog.warning((String)("[Automagy] Ignoring invalid Inventarium blacklist entry: " + s), (Object[])new Object[0]);
                }
                catch (Exception e) {
                    FMLLog.warning((String)("[Automagy] Ignoring invalid Inventarium blacklist entry: " + s), (Object[])new Object[0]);
                }
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static boolean loadBoolean(String category, String name, String desc, boolean def) {
        Property p = config.get(category, name, def);
        if (desc != null) {
            p.comment = desc;
        }
        return p.getBoolean(def);
    }

    public static boolean loadBoolean(String name, String desc, boolean def) {
        return AutomagyConfig.loadBoolean("general", name, desc, def);
    }

    public static int loadInteger(String category, String name, String desc, int def) {
        Property p = config.get(category, name, def);
        if (desc != null) {
            p.comment = desc;
        }
        return p.getInt(def);
    }

    public static int loadInteger(String name, String desc, int def) {
        return AutomagyConfig.loadInteger("general", name, desc, def);
    }

    public static String loadString(String category, String name, String desc, String def) {
        Property p = config.get(category, name, def);
        if (desc != null) {
            p.comment = desc;
        }
        return p.getString();
    }

    public static String[] loadStringArray(String category, String name, String desc, String[] def) {
        Property p = config.get(category, name, def);
        if (desc != null) {
            p.comment = desc;
        }
        return p.getStringList();
    }

    public static AspectList loadAspectList(String category, String name, String desc, AspectList def) {
        Property p = config.get(category, name, AutomagyConfig.getStringsFromAspects(def));
        if (desc != null) {
            p.comment = desc;
        }
        return AutomagyConfig.getAspectsFromStrings(p.getStringList());
    }

    public static int loadKeyBinding(String name, String desc, int def) {
        String s = AutomagyConfig.loadString(CATEGORY_KEYS, name, desc, Automagy.proxy.getKeyName(def));
        return Automagy.proxy.getKeyIndex(s);
    }

    public static String[] getStringsFromAspects(AspectList aspects) {
        ArrayList<String> list = new ArrayList<String>();
        for (Aspect aspect : aspects.getAspects()) {
            String s = aspect.getName() + ":" + aspects.getAmount(aspect);
            list.add(s.toLowerCase(Locale.ENGLISH));
        }
        return list.toArray(new String[list.size()]);
    }

    public static AspectList getAspectsFromStrings(String[] strings) {
        AspectList aspects = new AspectList();
        for (String s : strings) {
            int num;
            Aspect a;
            if (s.contains(":")) {
                String[] parts = s.split(":");
                if (parts.length != 2) {
                    throw new IllegalArgumentException("Automagy was not configured properly. Expected a string in format of \"ASPECT_TAG:INTEGER\", e.g. \"terra:5\". Got \"" + s + "\". Check your Automagy config file.");
                }
                a = Aspect.getAspect((String)parts[0].toLowerCase(Locale.ENGLISH));
                if (a == null) {
                    throw new IllegalArgumentException("Automagy was not configured properly. Expected a string in format of \"ASPECT_TAG:INTEGER\", e.g. \"terra:5\". Got \"" + s + "\". Check your Automagy config file.");
                }
                try {
                    num = Integer.parseInt(parts[1]);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException("Automagy was not configured properly. Expected a string in format of \"ASPECT_TAG:INTEGER\", e.g. \"terra:5\". Got \"" + s + "\". Check your Automagy config file.");
                }
            } else {
                throw new IllegalArgumentException("Automagy was not configured properly. Expected a string in format of \"ASPECT_TAG:INTEGER\", e.g. \"terra:5\". Got \"" + s + "\". Check your Automagy config file.");
            }
            aspects.merge(a, num);
        }
        return aspects;
    }

    static {
        versionChecking = true;
        listCreativeJar = true;
        listThinkingCap = true;
        usableThinkingCap = true;
        redcrystalEmitsLight = true;
        thirstyTankDrinksRain = true;
        useMFRMilk = true;
        useMFRMushroomSoup = true;
        overrideMFRMilkAspects = true;
        overrideMFRMushroomSoupAspects = true;
        lootWeightRingEnderDisjunctionLesser = 1;
        netherHeartDrops = true;
        netherHeartDropNetherOnly = true;
        focusUpgradeGratis = 81;
        focusUpgradeTransposing = 82;
        focusUpgradeStorage = 83;
        defaultKeyCraft = 46;
    }
}

