/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.gui;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.gui.GuiSpa;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.gui.ContainerBoiler;
import tuhljin.automagy.gui.ModGuiContainer;
import tuhljin.automagy.items.ModItems;
import tuhljin.automagy.lib.ThaumcraftExtension;
import tuhljin.automagy.lib.TjUtil;
import tuhljin.automagy.lib.compat.CompatibilityManager;
import tuhljin.automagy.tiles.TileEntityBoiler;

public class GUIBoiler
extends ModGuiContainer {
    public TileEntityBoiler boiler;
    public final ResourceLocation texture = new ResourceLocation("Automagy:textures/gui/boiler.png");
    private boolean listInstalled = false;
    private boolean filterExtraText = false;
    private boolean filterIsBlacklist = false;

    public GUIBoiler(InventoryPlayer inventoryPlayer, TileEntityBoiler te) {
        super(new ContainerBoiler(inventoryPlayer, te));
        this.boiler = te;
        this.field_147000_g = 175;
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        AspectList tags;
        IIcon icon;
        FluidStack fluid;
        int i1;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.boiler.isBurning()) {
            i1 = this.boiler.getBurnTimeRemainingScaled(20);
            this.func_73729_b(k + 80, l + 26 + 20 - i1, 176, 20 - i1, 16, i1);
        }
        i1 = this.boiler.getCookProgressScaled(46);
        this.func_73729_b(k + 100, l + 13 + 56 - i1, 216, 46 - i1, 9, i1);
        i1 = this.boiler.getContentsScaled(48);
        this.func_73729_b(k + 56, l + 12 + 54 - i1, 200, 48 - i1, 8, i1);
        this.func_73729_b(k + 55, l + 14, 232, 0, 10, 55);
        if (this.boiler.tank.getFluidAmount() > 0 && (fluid = this.boiler.tank.getFluid()) != null && (icon = fluid.getFluid().getIcon()) != null) {
            float bar = (float)this.boiler.tank.getFluidAmount() / (float)this.boiler.tank.getCapacity();
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(this.field_147003_i + 117), (float)(this.field_147009_r + 18), (float)0.0f);
            GuiSpa.renderFluid((IIcon)icon);
            GL11.glPopMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
            this.func_73729_b(k + 117, l + 18, 117, 18, 10, (int)(48.0f - 48.0f * bar));
        }
        this.func_73729_b(k + 116, l + 14, 232, 0, 10, 55);
        ItemStack stack = this.boiler.getStackToBoil();
        if (stack != null && ((tags = ThaumcraftExtension.getObjectTotalAspects(stack)) == null || tags.size() == 0)) {
            this.func_73729_b(k + 82, l + 14, 178, 82, 12, 12);
        }
        GL11.glDisable((int)3042);
        super.func_146976_a(var1, var2, var3);
    }

    @Override
    protected void buttonClicked(GuiButton button, boolean rightClick) {
    }

    public void func_73863_a(int x, int y, float p_73863_3_) {
        AspectList tags;
        ItemStack stack;
        super.func_73863_a(x, y, p_73863_3_);
        int posX = x - this.field_147003_i;
        int posY = y - this.field_147009_r;
        if (posX >= 116 && posX < 126 && posY >= 14 && posY < 70) {
            FluidStack fluid = this.boiler.tank.getFluid();
            if (fluid != null) {
                Fluid theFluid = fluid.getFluid();
                ArrayList<String> tipsList = new ArrayList<String>();
                tipsList.add(theFluid.getLocalizedName(fluid));
                tipsList.add(StatCollector.func_74837_a((String)"Automagy.gui.boiler.liquidQty", (Object[])new Object[]{fluid.amount}));
                this.drawHoveringText(tipsList, x, y, this.field_146289_q);
                Block block = theFluid.getBlock();
                if (block != null) {
                    EntityClientPlayerMP player = this.field_146297_k.field_71439_g;
                    ItemStack blockStack = new ItemStack(block);
                    if (ThaumcraftExtension.hasPlayerScanned((EntityPlayer)player, blockStack)) {
                        this.renderAspects((EntityPlayer)player, blockStack, x, y);
                    } else {
                        ItemStack bucket = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)new ItemStack(Items.field_151133_ar));
                        if (bucket != null && ThaumcraftExtension.hasPlayerScanned((EntityPlayer)player, bucket)) {
                            this.renderAspects((EntityPlayer)player, blockStack, x, y);
                        } else if (theFluid == CompatibilityManager.mushroomSoupBlock.getFluid()) {
                            if (ThaumcraftExtension.hasPlayerScanned((EntityPlayer)player, new ItemStack(Items.field_151009_A))) {
                                this.renderAspects((EntityPlayer)player, blockStack, x, y);
                            }
                        } else if (theFluid == ModBlocks.fluidVishroom && ThaumcraftExtension.hasPlayerScanned((EntityPlayer)player, new ItemStack((Item)ModItems.food, 1, 0))) {
                            this.renderAspects((EntityPlayer)player, blockStack, x, y);
                        }
                    }
                }
            }
        } else if (posX >= 82 && posX < 94 && posY >= 14 && posY < 26 && (stack = this.boiler.getStackToBoil()) != null && ((tags = ThaumcraftExtension.getObjectTotalAspects(stack)) == null || tags.size() == 0)) {
            ArrayList<String> lines = TjUtil.getMultiLineLocalizedString("Automagy.gui.boiler.cannotProcess");
            this.drawHoveringText(lines, x, y, this.field_146289_q);
        }
    }

    public boolean renderAspects(EntityPlayer player, ItemStack stack, int x, int y) {
        AspectList tags = ThaumcraftExtension.getObjectTotalAspects(stack);
        if (tags != null) {
            GUIBoiler.renderAspectsForPlayer(this, player, tags, x, y);
            return true;
        }
        return false;
    }

    public static void renderAspectsForPlayer(GuiContainer gui, EntityPlayer player, AspectList tags, int var16, int var17) {
        int shiftx = -8;
        int shifty = -8;
        if (Thaumcraft.instance.aspectShift) {
            shiftx -= 8;
            shifty -= 8;
        }
        int x = var16 + 17;
        int y = var17 + 7 - 33;
        GL11.glDisable((int)2929);
        int index = 0;
        if (tags.size() > 0) {
            for (Aspect tag : tags.getAspectsSortedAmount()) {
                if (tag == null) continue;
                x = var16 + 17 + index * 18;
                y = var17 + 7 - 33;
                UtilsFX.bindTexture((String)"textures/aspects/_back.png");
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glTranslated((double)(x + shiftx - 2), (double)(y + shifty - 2), (double)0.0);
                GL11.glScaled((double)1.25, (double)1.25, (double)0.0);
                UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                if (Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(player.func_70005_c_(), tag)) {
                    UtilsFX.drawTag((int)(x + shiftx), (int)(y + shifty), (Aspect)tag, (float)tags.getAmount(tag), (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                } else {
                    UtilsFX.bindTexture((String)"textures/aspects/_unknown.png");
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glTranslated((double)(x + shiftx), (double)(y + shifty), (double)0.0);
                    UtilsFX.drawTexturedQuadFull((int)0, (int)0, (double)UtilsFX.getGuiZLevel((Gui)gui));
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                }
                ++index;
            }
        }
        GL11.glEnable((int)2929);
    }
}

