/*
 * Decompiled with CFR 0.152.
 */
package tuhljin.automagy.blocks;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.AspectList;
import tuhljin.automagy.api.nethermind.INetherRune;
import tuhljin.automagy.api.nethermind.RuneCategory;
import tuhljin.automagy.blocks.ItemBlockNetherRune;
import tuhljin.automagy.blocks.ModBlock;
import tuhljin.automagy.blocks.ModBlocks;
import tuhljin.automagy.lib.AutomagyConfig;

public class BlockNetherRune
extends ModBlock
implements INetherRune {
    private IIcon[] secondaryIconsDim;
    private IIcon[] secondaryIconsActive;

    public BlockNetherRune(String name) {
        super(name, ModBlocks.materialNiceStone, ItemBlockNetherRune.class);
        this.func_149752_b(2000.0f);
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 6));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister ir) {
        this.secondaryIconsActive = new IIcon[7];
        this.secondaryIconsActive[0] = ir.func_94245_a(this.field_149768_d + "Rock");
        this.secondaryIconsActive[1] = ir.func_94245_a(this.field_149768_d + "Lava");
        this.secondaryIconsActive[2] = ir.func_94245_a(this.field_149768_d + "Crystal");
        this.secondaryIconsActive[4] = ir.func_94245_a(this.field_149768_d + "Soul");
        this.secondaryIconsActive[6] = ir.func_94245_a(this.field_149768_d + "Celerity");
        this.secondaryIconsDim = new IIcon[7];
        this.secondaryIconsDim[0] = ir.func_94245_a(this.field_149768_d + "RockDim");
        this.secondaryIconsDim[1] = ir.func_94245_a(this.field_149768_d + "LavaDim");
        this.secondaryIconsDim[2] = ir.func_94245_a(this.field_149768_d + "CrystalDim");
        this.secondaryIconsDim[4] = ir.func_94245_a(this.field_149768_d + "SoulDim");
        this.secondaryIconsDim[6] = this.secondaryIconsActive[6];
        this.field_149761_L = this.secondaryIconsActive[0];
    }

    public int func_149692_a(int metadata) {
        return metadata > 7 ? metadata - 8 : metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockaccess, int x, int y, int z, int side) {
        int meta = blockaccess.func_72805_g(x, y, z);
        if (meta > 7) {
            return this.secondaryIconsActive[meta - 8];
        }
        return this.secondaryIconsDim[meta];
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta == 0) {
            return this.field_149761_L;
        }
        if (meta > 7) {
            return this.secondaryIconsActive[meta - 8];
        }
        return this.secondaryIconsActive[meta];
    }

    public boolean isFireSource(World world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    @Override
    public int getRuneType(IBlockAccess blockaccess, int x, int y, int z) {
        int meta = blockaccess.func_72805_g(x, y, z);
        return meta > 7 ? meta - 8 : meta;
    }

    @Override
    public Block blockCreated(int runeType) {
        switch (runeType) {
            case 0: {
                return Blocks.field_150424_aL;
            }
            case 1: {
                return Blocks.field_150353_l;
            }
            case 2: {
                return Blocks.field_150449_bY;
            }
            case 4: {
                return Blocks.field_150425_aM;
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRune blockCreated: Invalid runeType.", (Object[])new Object[0]);
        return null;
    }

    @Override
    public int blockCreatedMetadata(int runeType) {
        return 0;
    }

    @Override
    public int ticksUntilBlockCreated(int runeType) {
        switch (runeType) {
            case 0: {
                return AutomagyConfig.nethermindRockSpeed;
            }
            case 1: {
                return AutomagyConfig.nethermindLavaSpeed;
            }
            case 2: {
                return AutomagyConfig.nethermindQuartzSpeed;
            }
            case 4: {
                return AutomagyConfig.nethermindSoulSandSpeed;
            }
        }
        return -1;
    }

    @Override
    public AspectList essentiaCostPerBlockCreated(int runeType) {
        switch (runeType) {
            case 0: {
                return AutomagyConfig.nethermindRockCost;
            }
            case 1: {
                return AutomagyConfig.nethermindLavaCost;
            }
            case 2: {
                return AutomagyConfig.nethermindQuartzCost;
            }
            case 4: {
                return AutomagyConfig.nethermindSoulSandCost;
            }
        }
        FMLLog.warning((String)"[Automagy] BlockNetherRune essentiaCostPerBlockCreated: Invalid runeType.", (Object[])new Object[0]);
        return null;
    }

    @Override
    public void activateRune(World world, int x, int y, int z, int runeType) {
        int meta = world.func_72805_g(x, y, z);
        if (meta < 8) {
            world.func_72921_c(x, y, z, meta + 8, 3);
        }
    }

    @Override
    public void deactivateRune(World world, int x, int y, int z, int runeType) {
        int meta = world.func_72805_g(x, y, z);
        if (meta > 7) {
            world.func_72921_c(x, y, z, meta - 8, 3);
        }
    }

    @Override
    public RuneCategory getRuneCategory(int runeType) {
        if (runeType == 6) {
            return RuneCategory.speed;
        }
        return null;
    }

    public MapColor func_149728_f(int p_149728_1_) {
        return MapColor.field_151654_J;
    }
}

