/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes;

import cofh.api.energy.IEnergyConnection;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TNHelper {
    public static Random rand = new Random();
    public static Set<Block> pipeBlocks = new HashSet<Block>();
    public static List<ForgeDirection> directions = new ArrayList<ForgeDirection>();

    public static IInventory getInventory(TileEntity tile) {
        if (tile instanceof IInventory) {
            if (tile instanceof TileEntityChest) {
                int x = tile.field_145851_c;
                int y = tile.field_145848_d;
                int z = tile.field_145849_e;
                Block blockID = tile.func_145831_w().func_147439_a(x, y, z);
                if (!tile.func_145831_w().func_147437_c(x, y, z) && blockID instanceof BlockChest) {
                    if (tile.func_145831_w().func_147439_a(x - 1, y, z) == blockID) {
                        return new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)tile.func_145831_w().func_147438_o(x - 1, y, z)), (IInventory)tile);
                    }
                    if (tile.func_145831_w().func_147439_a(x + 1, y, z) == blockID) {
                        return new InventoryLargeChest("container.chestDouble", (IInventory)tile, (IInventory)((TileEntityChest)tile.func_145831_w().func_147438_o(x + 1, y, z)));
                    }
                    if (tile.func_145831_w().func_147439_a(x, y, z - 1) == blockID) {
                        return new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityChest)tile.func_145831_w().func_147438_o(x, y, z - 1)), (IInventory)tile);
                    }
                    if (tile.func_145831_w().func_147439_a(x, y, z + 1) == blockID) {
                        return new InventoryLargeChest("container.chestDouble", (IInventory)tile, (IInventory)((TileEntityChest)tile.func_145831_w().func_147438_o(x, y, z + 1)));
                    }
                }
            }
            return (IInventory)tile;
        }
        return null;
    }

    public static boolean isValidTileEntity(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return TNHelper.getPipe(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ) == null && TNHelper.isValidTileEntity(world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ), dir.getOpposite().ordinal());
    }

    public static boolean isValidTileEntity(TileEntity inv, int side) {
        Object[] t;
        if (inv == null) {
            return false;
        }
        ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
        String classname = inv.getClass().toString();
        if (classname.contains("thermalexpansion") && classname.contains("conduit")) {
            return false;
        }
        if (inv instanceof IFluidHandler && (t = ((IFluidHandler)inv).getTankInfo(forgeSide)) != null && t.length != 0) {
            return true;
        }
        if (inv instanceof IInventory && ((IInventory)inv).func_70302_i_() > 0) {
            if (inv instanceof ISidedInventory) {
                t = ((ISidedInventory)inv).func_94128_d(side);
                if (t != null && t.length != 0) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return TNHelper.isRFEnergy(inv, forgeSide);
    }

    public static boolean isRFEnergy(TileEntity inv, ForgeDirection forgeSide) {
        return inv instanceof IEnergyConnection && ((IEnergyConnection)inv).canConnectEnergy(forgeSide);
    }

    public static boolean isEnergy(TileEntity inv, ForgeDirection forgeSide) {
        return TNHelper.isRFEnergy(inv, forgeSide);
    }

    public static void initBlocks() {
        for (Object aBlockRegistry : Block.field_149771_c) {
            Block i = (Block)aBlockRegistry;
            if (!(i instanceof IPipe) && !(i instanceof IPipeBlock)) continue;
            pipeBlocks.add(i);
        }
    }

    public static IPipe getPipe(IBlockAccess world, int x, int y, int z) {
        Block id;
        if (world == null) {
            return null;
        }
        if (y < 0 || y >= 256) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile instanceof IPipe) {
                return (IPipe)tile;
            }
            if (tile instanceof IPipeBlock) {
                return ((IPipeBlock)tile).getPipe(world.func_72805_g(x, y, z));
            }
        }
        if (!(id = world.func_147439_a(x, y, z)).isAir(world, x, y, z) && pipeBlocks.contains(id)) {
            if (id instanceof IPipe) {
                return (IPipe)id;
            }
            if (id instanceof IPipeBlock) {
                return ((IPipeBlock)id).getPipe(world.func_72805_g(x, y, z));
            }
        }
        return null;
    }

    public static boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        return pipe != null && pipe.canInput(world, x, y, z, dir);
    }

    public static boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        return pipe != null && pipe.canOutput(world, x, y, z, dir);
    }

    public static boolean doesPipeConnect(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return TNHelper.canOutput(world, x, y, z, dir) && TNHelper.canInput(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite()) || TNHelper.canInput(world, x, y, z, dir) && TNHelper.canOutput(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite());
    }

    public static ForgeDirection[] randomDirections() {
        Collections.shuffle(directions, rand);
        return directions.toArray(new ForgeDirection[directions.size()]);
    }

    static {
        for (int i = 0; i < 6; ++i) {
            directions.add(ForgeDirection.getOrientation((int)i));
        }
    }
}

