/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.endercollector;

import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.network.NetworkHandler;
import com.rwtema.extrautils.network.packets.PacketYoink;
import com.rwtema.extrautils.tileentity.endercollector.CollectorHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class TileEnderCollector
extends TileEntity {
    int range;
    AxisAlignedBB bounds;

    public TileEnderCollector() {
        this.setRange(8);
    }

    public void setRange(int r) {
        this.range = r;
        this.bounds = AxisAlignedBB.func_72330_a((double)Math.floor(this.field_145851_c - r), (double)Math.floor(this.field_145848_d - r), (double)Math.floor(this.field_145849_e - r), (double)Math.ceil(this.field_145851_c + r), (double)Math.ceil(this.field_145848_d + r), (double)Math.ceil(this.field_145849_e + r));
    }

    public void onNeighbourChange() {
        this.setRange(this.range);
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.setRange(this.range);
        if (!this.field_145850_b.field_72995_K && XUHelper.random.nextInt(20) == 0) {
            List entitiesWithinAABB = this.field_145850_b.func_72872_a(EntityItem.class, this.bounds);
            for (Object o : entitiesWithinAABB) {
                this.grabEntity((EntityItem)o);
            }
        }
    }

    public boolean inRange(Entity entity) {
        return this.bounds.func_72326_a(entity.field_70121_D);
    }

    public void func_145843_s() {
        super.func_145843_s();
        CollectorHandler.unregister(this);
    }

    public void onChunkUnload() {
        CollectorHandler.unregister(this);
    }

    public void func_145834_a(World p_145834_1_) {
        super.func_145834_a(p_145834_1_);
        CollectorHandler.register(this);
    }

    public void grabEntity(EntityItem entity) {
        int side = this.func_145832_p() % 6;
        TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + Facing.field_71586_b[side], this.field_145848_d + Facing.field_71587_c[side], this.field_145849_e + Facing.field_71585_d[side]);
        if (tileEntity instanceof IInventory) {
            ItemStack stack = entity.func_70096_w().func_82710_f(10);
            if (stack == null) {
                return;
            }
            int prevAmount = stack.field_77994_a;
            if ((stack = XUHelper.invInsert((IInventory)tileEntity, stack, side ^ 1)) == null) {
                this.signalChange(entity);
                entity.func_70106_y();
            } else if (stack.field_77994_a != prevAmount) {
                this.signalChange(entity);
                entity.func_92058_a(stack);
                if (entity.getClass() != EntityItem.class && (stack = entity.func_70096_w().func_82710_f(10)) != null && stack.field_77994_a > prevAmount) {
                    entity.func_70106_y();
                }
            }
        }
    }

    public void signalChange(EntityItem item) {
        NetworkHandler.sendToAllAround(new PacketYoink(item, this), this.field_145850_b.field_73011_w.field_76574_g, this.field_145851_c, this.field_145848_d, this.field_145849_e, 32.0);
    }
}

