/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils;

import com.rwtema.extrautils.ChunkPos;
import com.rwtema.extrautils.ExtraUtils;
import com.rwtema.extrautils.XUHelper;
import com.rwtema.extrautils.item.ItemDivisionSigil;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.oredict.OreDictionary;

public class EventHandlerSiege {
    public static final int numKills = 100;
    public static final int[] ddx = new int[]{-1, 0, 1, 0};
    public static final int[] ddz = new int[]{0, -1, 0, 1};
    public static List<String> SiegeParticipants = new ArrayList<String>();
    public static List<BiomeGenBase.SpawnListEntry> mobSpawns = new ArrayList<BiomeGenBase.SpawnListEntry>();
    public static ItemStack[] earthItems;
    public static ItemStack[] fireItems;
    private static Random rand;

    public static void endSiege(World world, boolean announce) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            if (!(world.field_72996_f.get(i) instanceof EntityMob) || !((EntityMob)world.field_72996_f.get(i)).getEntityData().func_74764_b("Siege")) continue;
            world.func_72900_e((Entity)world.field_72996_f.get(i));
        }
        if (announce) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("The Siege has ended in 'The End'"));
        }
    }

    public static void upgradeSigil(EntityPlayer player) {
        for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
            if (player.field_71071_by.field_70462_a[j] == null || player.field_71071_by.field_70462_a[j].func_77973_b() != ExtraUtils.divisionSigil) continue;
            if (player.field_71071_by.field_70462_a[j].func_77942_o() && player.field_71071_by.field_70462_a[j].func_77978_p().func_74764_b("damage")) {
                player.field_71071_by.field_70462_a[j] = ItemDivisionSigil.newStableSigil();
            }
            return;
        }
    }

    public static void beginSiege(World world) {
        if (world.field_72995_K) {
            return;
        }
        if (world.field_73011_w.field_76574_g != 1) {
            return;
        }
        for (int i = 0; i < world.field_72996_f.size(); ++i) {
            if (world.field_72996_f.get(i) instanceof EntityMob) {
                world.func_72900_e((Entity)world.field_72996_f.get(i));
                continue;
            }
            if (!(world.field_72996_f.get(i) instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)world.field_72996_f.get(i);
            SiegeParticipants.add(player.func_146103_bH().getName());
            player.getEntityData().func_74768_a("SiegeKills", 0);
        }
        if (SiegeParticipants.size() != 0) {
            MinecraftServer.func_71276_C().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText("The Siege has begun in 'The End'"));
        } else {
            EventHandlerSiege.endSiege(world, false);
        }
    }

    public static boolean hasSigil(EntityPlayer player) {
        for (int j = 0; j < player.field_71071_by.field_70462_a.length; ++j) {
            if (player.field_71071_by.field_70462_a[j] == null || player.field_71071_by.field_70462_a[j].func_77973_b() != ExtraUtils.divisionSigil || !player.field_71071_by.field_70462_a[j].func_77942_o() || !player.field_71071_by.field_70462_a[j].func_77978_p().func_74764_b("damage")) continue;
            return true;
        }
        return false;
    }

    public static void checkPlayers() {
        WorldServer worldObj = DimensionManager.getWorld((int)1);
        if (worldObj == null || worldObj.field_72995_K) {
            SiegeParticipants.clear();
            return;
        }
        if (SiegeParticipants.size() > 0) {
            for (int i = 0; i < SiegeParticipants.size(); ++i) {
                if (worldObj.func_72924_a(SiegeParticipants.get(i)) != null) continue;
                SiegeParticipants.remove(SiegeParticipants.get(i));
                --i;
            }
            if (SiegeParticipants.size() == 0) {
                EventHandlerSiege.endSiege((World)worldObj, true);
            }
        }
    }

    public static int[] getStrength(World world, int x, int y, int z) {
        ArrayList<ChunkPos> rs = new ArrayList<ChunkPos>();
        ArrayList<ChunkPos> st = new ArrayList<ChunkPos>();
        rs.add(new ChunkPos(x, y, z));
        st.add(new ChunkPos(x, y, z));
        int maxDist = 0;
        BlockRedstoneWire rsId = Blocks.field_150488_af;
        Block stId = Blocks.field_150473_bD;
        int k2 = 0;
        for (int i = 0; i < rs.size(); ++i) {
            for (int j = 0; j < 4; ++j) {
                ChunkPos nPos = new ChunkPos(((ChunkPos)rs.get((int)i)).x + ddx[j], y, ((ChunkPos)rs.get((int)i)).z + ddz[j]);
                int m = EventHandlerSiege.mDist(nPos.x - x, nPos.z - z);
                if (m >= 16 || world.func_147439_a(nPos.x, y, nPos.z) != rsId || rs.contains(nPos)) continue;
                rs.add(nPos);
                if (world.func_72805_g(nPos.x, y, nPos.z) != 0) {
                    ++k2;
                }
                if (m <= maxDist) continue;
                maxDist = m;
            }
        }
        rs.remove(new ChunkPos(x, y, z));
        int k = 0;
        for (int i = 0; i < st.size(); ++i) {
            for (int j = 0; j < 4; ++j) {
                ChunkPos nPos = new ChunkPos(((ChunkPos)st.get((int)i)).x + ddx[j], y, ((ChunkPos)st.get((int)i)).z + ddz[j]);
                int m = EventHandlerSiege.mDist(nPos.x - x, nPos.z - z);
                if (m >= 16) continue;
                if (world.func_147439_a(nPos.x, y, nPos.z) == stId && !st.contains(nPos)) {
                    st.add(nPos);
                    if (m <= maxDist) continue;
                    maxDist = m;
                    continue;
                }
                if (i == 0 || world.func_147439_a(nPos.x, y, nPos.z) != rsId || !rs.contains(nPos)) continue;
                ++k;
            }
        }
        return new int[]{k, maxDist * maxDist * 4};
    }

    public static int mDist(int x, int z) {
        if (x < 0) {
            x *= -1;
        }
        if (z < 0) {
            z *= -1;
        }
        return x > z ? x : z;
    }

    public static int checkChestList(IInventory chest, ItemStack[] items, boolean destroy) {
        boolean[] check = new boolean[items.length];
        int s = 0;
        block0: for (int i = 0; i < chest.func_70302_i_() && s < items.length; ++i) {
            if (chest.func_70301_a(i) == null) continue;
            for (int j = 0; !(j >= items.length || destroy && chest.func_70301_a(i) == null); ++j) {
                if (check[j] || !XUHelper.canItemsStack(items[j], chest.func_70301_a(i), false, true)) continue;
                if (destroy) {
                    chest.func_70299_a(i, null);
                }
                check[j] = true;
                ++s;
                continue block0;
            }
        }
        return s;
    }

    public static int checkChestEarth(IInventory chest, boolean destroy) {
        if (chest == null) {
            return 0;
        }
        if (earthItems == null) {
            earthItems = new ItemStack[]{new ItemStack(Blocks.field_150365_q), new ItemStack(Blocks.field_150352_o), new ItemStack(Blocks.field_150366_p), new ItemStack(Blocks.field_150369_x), new ItemStack(Blocks.field_150482_ag), new ItemStack(Blocks.field_150412_bA), new ItemStack(Blocks.field_150450_ax), new ItemStack((Block)Blocks.field_150349_c), new ItemStack(Blocks.field_150346_d), new ItemStack(Blocks.field_150435_aG), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150351_n), new ItemStack(Blocks.field_150343_Z)};
        }
        return EventHandlerSiege.checkChestList(chest, earthItems, destroy);
    }

    public static int checkChestFire(IInventory chest, boolean destroy) {
        if (chest == null) {
            return 0;
        }
        if (fireItems == null) {
            fireItems = new ItemStack[]{new ItemStack(Items.field_151044_h, 1, 1), new ItemStack(Blocks.field_150348_b), new ItemStack(Items.field_151118_aC), new ItemStack(Items.field_151101_aQ), new ItemStack(Blocks.field_150359_w), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151168_bH), new ItemStack(Items.field_151130_bT), new ItemStack(Items.field_151100_aR, 1, 2), new ItemStack(Blocks.field_150405_ch), new ItemStack(Items.field_151157_am), new ItemStack(Items.field_151083_be), new ItemStack(Items.field_151077_bg)};
        }
        return EventHandlerSiege.checkChestList(chest, fireItems, destroy);
    }

    public static int checkChestWater(IInventory chest, boolean destroy) {
        if (chest == null) {
            return 0;
        }
        ArrayList<PotionEffect> numEffects = new ArrayList<PotionEffect>();
        for (int i = 0; i < chest.func_70302_i_() && numEffects.size() < 12; ++i) {
            List temp;
            if (chest.func_70301_a(i) == null || chest.func_70301_a(i).func_77973_b() != Items.field_151068_bn || (temp = Items.field_151068_bn.func_77832_l(chest.func_70301_a(i))) == null) continue;
            for (Object aTemp : temp) {
                if (numEffects.contains(aTemp)) continue;
                numEffects.add((PotionEffect)aTemp);
                if (!destroy) continue;
                chest.func_70299_a(i, null);
            }
        }
        return numEffects.size();
    }

    public static int checkChestAir(IInventory chest, boolean destroy) {
        if (chest == null) {
            return 0;
        }
        int s = 0;
        ArrayList pt = OreDictionary.getOres((String)"record");
        HashSet<Item> items = new HashSet<Item>();
        for (int i = 0; i < chest.func_70302_i_() && s < 12; ++i) {
            ItemStack item;
            if (chest.func_70301_a(i) == null || items.contains((item = chest.func_70301_a(i)).func_77973_b())) continue;
            boolean flag = false;
            for (ItemStack ore : pt) {
                if (!OreDictionary.itemMatches((ItemStack)item, (ItemStack)ore, (boolean)false)) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            if (destroy) {
                chest.func_70299_a(i, null);
            }
            items.add(item.func_77973_b());
            ++s;
        }
        return s;
    }

    @SubscribeEvent
    public void Siege(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        EventHandlerSiege.checkPlayers();
        if (event.entity instanceof EntityPlayer) {
            if (event.world.field_73011_w.field_76574_g != 1) {
                if (event.entity.getEntityData().func_74764_b("SiegeKills")) {
                    event.entity.getEntityData().func_82580_o("SiegeKills");
                    SiegeParticipants.remove(((EntityPlayer)event.entity).func_146103_bH().getName());
                }
            } else if (event.entity.getEntityData().func_74764_b("SiegeKills") && !SiegeParticipants.contains(((EntityPlayer)event.entity).func_146103_bH().getName())) {
                SiegeParticipants.add(((EntityPlayer)event.entity).func_146103_bH().getName());
            }
        }
    }

    public double sq(double x, double y, double z) {
        return x * x + z * z + y * y;
    }

    @SubscribeEvent
    public void golemDeath(LivingDeathEvent event) {
        if (!event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.field_73011_w.field_76574_g == 1 && event.entity instanceof EntityIronGolem && event.source.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            if (!EventHandlerSiege.hasSigil(player)) {
                return;
            }
            List t = event.entity.field_70170_p.field_147482_g;
            for (Object aT : t) {
                int j;
                if (!aT.getClass().equals(TileEntityBeacon.class)) continue;
                TileEntityBeacon beacon = (TileEntityBeacon)aT;
                int x = beacon.field_145851_c;
                int y = beacon.field_145848_d;
                int z = beacon.field_145849_e;
                if (!(this.sq(event.entity.field_70165_t - (double)x - 0.5, event.entity.field_70163_u - (double)y - 0.5, event.entity.field_70161_v - (double)z - 0.5) < 300.0)) continue;
                int[] s = EventHandlerSiege.getStrength(event.entity.field_70170_p, x, y, z);
                World world = beacon.func_145831_w();
                if (s[0] != 64) continue;
                int debug = 1;
                boolean flag = true;
                if (EventHandlerSiege.checkChestFire(TileEntityHopper.func_145893_b((World)world, (double)x, (double)y, (double)(z - 5)), false) < debug) {
                    flag = false;
                }
                if (flag && EventHandlerSiege.checkChestEarth(TileEntityHopper.func_145893_b((World)world, (double)x, (double)y, (double)(z + 5)), false) < debug) {
                    flag = false;
                }
                if (flag && EventHandlerSiege.checkChestAir(TileEntityHopper.func_145893_b((World)world, (double)(x - 5), (double)y, (double)z), false) < debug) {
                    flag = false;
                }
                if (flag && EventHandlerSiege.checkChestWater(TileEntityHopper.func_145893_b((World)world, (double)(x + 5), (double)y, (double)z), false) < debug) {
                    flag = false;
                }
                if (!flag) continue;
                world.func_147480_a(x, y, z, false);
                for (j = 0; j < 4; ++j) {
                    world.func_147480_a(x + ddx[j] * 5, y, z + ddz[j] * 5, false);
                }
                world.func_147480_a(x, y, z, false);
                world.func_72876_a(null, (double)x, (double)y, (double)z, 6.0f, true);
                for (j = 0; j < 4; ++j) {
                    world.func_72876_a(null, (double)(x + ddx[j] * 5), (double)y, (double)(z + ddz[j] * 5), 3.0f, true);
                }
                EventHandlerSiege.beginSiege(world);
                return;
            }
        }
    }

    @SubscribeEvent
    public void SiegeDeath(LivingDeathEvent event) {
        if (SiegeParticipants.isEmpty()) {
            return;
        }
        if (event.entityLiving.field_70170_p.field_72995_K || event.entityLiving.field_70170_p.field_73011_w.field_76574_g != 1) {
            return;
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EventHandlerSiege.checkPlayers();
        }
        if (event.entityLiving instanceof EntityMob && event.source.func_76364_f() instanceof EntityPlayer && event.entityLiving.getEntityData().func_74764_b("Siege")) {
            EntityPlayer player = (EntityPlayer)event.source.func_76364_f();
            if (player != null && SiegeParticipants.contains(player.func_146103_bH().getName()) && EventHandlerSiege.hasSigil(player)) {
                if (player.getEntityData().func_74764_b("SiegeKills")) {
                    player.getEntityData().func_74768_a("SiegeKills", player.getEntityData().func_74762_e("SiegeKills") + 1);
                } else {
                    player.getEntityData().func_74768_a("SiegeKills", 1);
                }
                int kills = player.getEntityData().func_74762_e("SiegeKills");
                if (kills > 100) {
                    EventHandlerSiege.upgradeSigil(player);
                    player.getEntityData().func_82580_o("SiegeKills");
                    SiegeParticipants.remove(player.func_146103_bH().getName());
                    player.func_146105_b((IChatComponent)new ChatComponentText("Your Sigil has stabilized"));
                } else {
                    player.func_146105_b((IChatComponent)new ChatComponentText("Kills: " + player.getEntityData().func_74762_e("SiegeKills")));
                }
            }
        } else if (!(event.entityLiving instanceof EntityPlayer) || SiegeParticipants.contains(((EntityPlayer)event.entityLiving).func_146103_bH().getName())) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void SiegePotentialSpawns(WorldEvent.PotentialSpawns event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 1 && event.type == EnumCreatureType.monster) {
            EventHandlerSiege.checkPlayers();
            if (SiegeParticipants.isEmpty()) {
                event.list.removeAll(mobSpawns);
            } else if (event.list.size() < mobSpawns.size()) {
                event.list.addAll(mobSpawns);
            }
        }
    }

    @SubscribeEvent
    public void Siege(LivingEvent.LivingUpdateEvent event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (SiegeParticipants.isEmpty()) {
            if (event.entityLiving.getEntityData().func_74764_b("Siege")) {
                event.entity.func_70106_y();
                EventHandlerSiege.endSiege(event.entity.field_70170_p, true);
            }
            return;
        }
        if (event.entityLiving.field_70170_p.field_73012_v.nextInt(1000) == 0) {
            EventHandlerSiege.checkPlayers();
        }
        if (event.entityLiving.field_70170_p.field_73011_w.field_76574_g != 1) {
            return;
        }
        if (event.entityLiving instanceof EntityMob && ((EntityMob)event.entityLiving).func_70638_az() == null && event.entityLiving.getEntityData().func_74764_b("Siege")) {
            int i = rand.nextInt(SiegeParticipants.size());
            EntityPlayer player = event.entityLiving.field_70170_p.func_72924_a(SiegeParticipants.get(i));
            if (player != null) {
                ((EntityMob)event.entityLiving).func_70624_b((EntityLivingBase)player);
                ((EntityMob)event.entityLiving).func_70784_b((Entity)player);
            } else {
                SiegeParticipants.remove(i);
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (!(player.field_70181_x != 0.0 || player.field_70143_R != 0.0f || player.field_70122_E || player.func_70617_f_() || player.func_70090_H() || player.field_70154_o != null)) {
                player.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void SiegeCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (SiegeParticipants.isEmpty()) {
            return;
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (event.world.field_73011_w.field_76574_g != 1) {
            return;
        }
        if (event.entityLiving instanceof EntityMob && event.entityLiving.field_70170_p.func_72855_b(event.entityLiving.field_70121_D) && event.entityLiving.field_70170_p.func_72945_a((Entity)event.entityLiving, event.entityLiving.field_70121_D).isEmpty() && !event.entityLiving.field_70170_p.func_72953_d(event.entityLiving.field_70121_D)) {
            event.entityLiving.getEntityData().func_74757_a("Siege", true);
            event.entityLiving.func_70690_d(new PotionEffect(Potion.field_76424_c.field_76415_H, 7200, 2));
            event.setResult(Event.Result.ALLOW);
        }
    }

    static {
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntitySpider.class, 200, 3, 3));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityCaveSpider.class, 40, 4, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityZombie.class, 80, 4, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntitySkeleton.class, 200, 4, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityCreeper.class, 200, 4, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityBlaze.class, 80, 2, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityPigZombie.class, 40, 4, 4));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityWitch.class, 40, 1, 3));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntitySilverfish.class, 40, 3, 3));
        mobSpawns.add(new BiomeGenBase.SpawnListEntry(EntityGiantZombie.class, 5, 1, 1));
        rand = new Random();
    }
}

