/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Strings;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import openmods.Log;
import openperipheral.api.peripheral.PeripheralTypeId;
import org.apache.commons.lang3.StringUtils;

public class NameUtils {
    private static Map<String, Class<? extends TileEntity>> teNameToClass;
    private static Map<Class<? extends TileEntity>, String> teClassToName;

    public static Map<Class<? extends TileEntity>, String> getClassToNameMap() {
        if (teClassToName == null) {
            teClassToName = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"classToNameMap", "field_145853_j"});
        }
        return teClassToName;
    }

    public static Map<String, Class<? extends TileEntity>> getNameToClassMap() {
        if (teNameToClass == null) {
            teNameToClass = (Map)ReflectionHelper.getPrivateValue(TileEntity.class, null, (String[])new String[]{"nameToClassMap", "field_145855_i"});
        }
        return teNameToClass;
    }

    public static String getNameForTarget(Object target) {
        String name = NameUtils.tryGetName(target);
        return Strings.isNullOrEmpty((String)name) ? "peripheral" : name.replaceAll("[^a-zA-Z0-9]", "_").toLowerCase();
    }

    private static String tryGetName(Object target) {
        Class<?> cls;
        block17: {
            if (target == null) {
                return "invalid";
            }
            cls = target.getClass();
            PeripheralTypeId customId = cls.getAnnotation(PeripheralTypeId.class);
            if (customId != null) {
                return customId.value();
            }
            if (target instanceof IInventory) {
                try {
                    return ((IInventory)target).func_145825_b();
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Can't get inventory name for %s", (Object[])new Object[]{cls});
                }
            }
            if (target instanceof TileEntity) {
                TileEntity te = (TileEntity)target;
                try {
                    String mapping = NameUtils.getClassToNameMap().get(cls);
                    if (!Strings.isNullOrEmpty((String)mapping)) {
                        return mapping;
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Failed to map class %s to name", (Object[])new Object[]{cls});
                }
                try {
                    String name;
                    Block block = te.func_145838_q();
                    if (block == null) break block17;
                    int dmg = te.func_145832_p();
                    ItemStack is = new ItemStack(block, 1, dmg);
                    try {
                        name = is.func_82833_r();
                        if (!Strings.isNullOrEmpty((String)name)) {
                            return name;
                        }
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Can't get display name for %s", (Object[])new Object[]{cls});
                    }
                    try {
                        name = StringUtils.removeStart((String)block.func_149739_a(), (String)"tile.");
                        if (!Strings.isNullOrEmpty((String)name)) {
                            return name;
                        }
                    }
                    catch (Throwable t) {
                        Log.warn((Throwable)t, (String)"Can't get unlocalized name for %s", (Object[])new Object[]{cls});
                    }
                }
                catch (Throwable t) {
                    Log.warn((Throwable)t, (String)"Exception while getting name from item for %s", (Object[])new Object[]{cls});
                }
            }
        }
        return cls.getSimpleName();
    }

    public static String grumize(Class<?> targetCls) {
        return targetCls.getName().replace('.', '\u2603');
    }

    public static String degrumize(String obfClsName) {
        return obfClsName.replace('\u2603', '.');
    }
}

