/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.util;

import com.google.common.base.Joiner;
import joptsimple.internal.Strings;
import openmods.utils.CachedFactory;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IMethodMap;
import openperipheral.api.adapter.Doc;

public class DocUtils {
    public static final CachedFactory<Class<?>, String> DOC_TEXT_CACHE = new CachedFactory<Class<?>, String>(){

        protected String create(Class<?> key) {
            Doc doc = key.getAnnotation(Doc.class);
            return doc != null ? Joiner.on((char)'\n').join((Object[])doc.value()) : "";
        }
    };

    public static void listMethods(final StringBuilder builder, IMethodMap methods) {
        methods.visitMethods(new IMethodMap.IMethodVisitor(){

            @Override
            public void visit(String name, IMethodExecutor executor) {
                String methodDoc = executor.description().doc(name);
                builder.append(methodDoc);
                builder.append('\n');
            }
        });
    }

    public static String createPeripheralHelpText(Class<? extends Object> cls, String type, IMethodMap methods) {
        StringBuilder builder = new StringBuilder();
        builder.append("----OpenPeripheral doc----\n");
        builder.append("Peripheral type: ");
        builder.append(type);
        builder.append("\n\n");
        String docText = (String)DOC_TEXT_CACHE.getOrCreate(cls);
        if (!Strings.isNullOrEmpty((String)docText)) {
            builder.append(docText);
            builder.append("\n\n");
        }
        builder.append("---Methods---\n");
        DocUtils.listMethods(builder, methods);
        return builder.toString();
    }
}

