/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.Vec3;
import openperipheral.ApiImplementation;
import openperipheral.api.adapter.method.ScriptObject;
import openperipheral.api.meta.IEntityCustomMetaProvider;
import openperipheral.api.meta.IEntityMetaProvider;
import openperipheral.api.meta.IEntityPartialMetaBuilder;
import openperipheral.api.meta.IMetaProviderProxy;
import openperipheral.meta.MetaProvidersRegistry;

@ApiImplementation
public class EntityMetadataBuilder
implements IEntityPartialMetaBuilder {
    private static void fillCustomProperties(Map<String, Object> map, Iterable<IEntityMetaProvider<?>> providers, Entity entity, Vec3 relativePos) {
        for (IEntityMetaProvider<?> provider : providers) {
            Object converted = EntityMetadataBuilder.getProperty(entity, relativePos, provider);
            if (converted == null) continue;
            String key = provider.getKey();
            map.put(key, converted);
        }
    }

    private static Map<String, Object> createBasicProperties(Entity entity, Vec3 relativePos) {
        HashMap map = Maps.newHashMap();
        EntityMetadataBuilder.addPositionInfo(map, entity, relativePos);
        map.put("name", entity.func_70005_c_());
        map.put("id", entity.func_145782_y());
        map.put("uuid", entity.func_110124_au());
        if (entity.field_70153_n != null) {
            map.put("riddenBy", entity.field_70153_n.func_145782_y());
        }
        if (entity.field_70154_o != null) {
            map.put("ridingEntity", entity.field_70154_o.func_145782_y());
        }
        return map;
    }

    private static void addPositionInfo(Map<String, Object> map, Entity entity, Vec3 relativePos) {
        Map<String, Double> position = relativePos != null ? EntityMetadataBuilder.addRelativePos(entity, relativePos) : EntityMetadataBuilder.addAbsolutePos(entity);
        map.put("position", position);
    }

    private static Map<String, Double> addAbsolutePos(Entity entity) {
        return EntityMetadataBuilder.createPosition(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    private static Map<String, Double> addRelativePos(Entity entity, Vec3 relativePos) {
        return EntityMetadataBuilder.createPosition(entity.field_70165_t - relativePos.field_72450_a, entity.field_70163_u - relativePos.field_72448_b, entity.field_70161_v - relativePos.field_72449_c);
    }

    private static Map<String, Double> createPosition(double x, double y, double z) {
        return ImmutableMap.of((Object)"x", (Object)x, (Object)"y", (Object)y, (Object)"z", (Object)z);
    }

    private static Object getProperty(Entity entity, Vec3 relativePos, IEntityMetaProvider provider) {
        return provider.getMeta(entity, relativePos);
    }

    protected static Map<String, IEntityMetaProvider<?>> getProviders(Entity entity) {
        Map<String, IEntityMetaProvider<?>> immutableProviders = MetaProvidersRegistry.ENITITES.getProviders(entity.getClass());
        HashMap providers = Maps.newHashMap(immutableProviders);
        EntityMetadataBuilder.filterCustomProviders(providers, entity);
        return providers;
    }

    protected static void filterCustomProviders(Map<String, IEntityMetaProvider<?>> providers, Entity entity) {
        Iterator<IEntityMetaProvider<?>> it = providers.values().iterator();
        while (it.hasNext()) {
            IEntityMetaProvider<?> provider = it.next();
            if (!(provider instanceof IEntityCustomMetaProvider) || !((IEntityCustomMetaProvider)provider).canApply(entity)) continue;
            it.remove();
        }
    }

    @Override
    public IMetaProviderProxy createProxy(Entity entity, Vec3 relativePos) {
        Map<String, IEntityMetaProvider<?>> providers = EntityMetadataBuilder.getProviders(entity);
        return new Proxy(providers, relativePos, entity);
    }

    @Override
    public Map<String, Object> getBasicEntityMetadata(Entity entity, Vec3 relativePos) {
        return EntityMetadataBuilder.createBasicProperties(entity, relativePos);
    }

    @Override
    public Map<String, Object> getEntityMetadata(Entity entity, Vec3 relativePos) {
        Map<String, Object> map = EntityMetadataBuilder.createBasicProperties(entity, relativePos);
        Collection<IEntityMetaProvider<?>> providers = EntityMetadataBuilder.getProviders(entity).values();
        EntityMetadataBuilder.fillCustomProperties(map, providers, entity, relativePos);
        return map;
    }

    @Override
    public Object getEntityMetadata(String key, Entity entity, Vec3 relativePos) {
        Map<String, IEntityMetaProvider<?>> providers = EntityMetadataBuilder.getProviders(entity);
        IEntityMetaProvider<?> provider = providers.get(key);
        return provider != null ? EntityMetadataBuilder.getProperty(entity, relativePos, provider) : null;
    }

    @Override
    public Set<String> getKeys(Entity target) {
        return ImmutableSet.copyOf(EntityMetadataBuilder.getProviders(target).keySet());
    }

    @Override
    public void register(IEntityMetaProvider<?> provider) {
        MetaProvidersRegistry.ENITITES.addProvider(provider);
    }

    @ScriptObject
    private static class Proxy
    implements IMetaProviderProxy {
        private final Map<String, IEntityMetaProvider<?>> providers;
        private final Vec3 relativePos;
        private final Entity entity;

        private Proxy(Map<String, IEntityMetaProvider<?>> providers, Vec3 relativePos, Entity entity) {
            this.providers = ImmutableMap.copyOf(providers);
            this.relativePos = relativePos;
            this.entity = entity;
        }

        @Override
        public Map<String, Object> basic() {
            return EntityMetadataBuilder.createBasicProperties(this.entity, this.relativePos);
        }

        @Override
        public Map<String, Object> all() {
            Map<String, Object> map = this.basic();
            EntityMetadataBuilder.fillCustomProperties(map, this.providers.values(), this.entity, this.relativePos);
            return map;
        }

        @Override
        public Set<String> keys() {
            return ImmutableSet.copyOf(this.providers.keySet());
        }

        @Override
        public Map<String, Object> select(String ... keys) {
            Map<String, Object> result = this.basic();
            for (String key : keys) {
                Object value;
                IEntityMetaProvider<?> provider = this.providers.get(key);
                if (provider == null || (value = EntityMetadataBuilder.getProperty(this.entity, this.relativePos, provider)) == null) continue;
                result.put(key, value);
            }
            return result;
        }

        @Override
        public Object single(String key) {
            IEntityMetaProvider<?> provider = this.providers.get(key);
            return provider != null ? EntityMetadataBuilder.getProperty(this.entity, this.relativePos, provider) : null;
        }
    }
}

