/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.oc;

import com.google.common.base.Preconditions;
import li.cil.oc.api.Driver;
import li.cil.oc.api.driver.Block;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.machine.Value;
import li.cil.oc.api.network.ManagedEnvironment;
import openmods.injector.InjectedClassesManager;
import openperipheral.ApiProvider;
import openperipheral.CommandDump;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.composed.ComposedMethodsFactory;
import openperipheral.adapter.composed.MethodSelector;
import openperipheral.adapter.method.LuaTypeQualifier;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.oc.TypeConversionRegistryOC;
import openperipheral.interfaces.oc.asm.object.ObjectCodeGenerator;
import openperipheral.interfaces.oc.asm.peripheral.PeripheralCodeGenerator;
import openperipheral.interfaces.oc.providers.AdapterFactoryWrapperOC;
import openperipheral.interfaces.oc.providers.DriverOpenPeripheral;
import openperipheral.interfaces.oc.providers.EnvironmentClassBytesProvider;
import openperipheral.interfaces.oc.providers.EnvironmentMethodsFactory;
import openperipheral.interfaces.oc.providers.IEnviromentInstanceWrapper;
import openperipheral.util.DocBuilder;

public class ModuleOpenComputers {
    private static final String PERIPHERAL_CLASS_PREFIX = "OP_OC_Peripheral";
    private static final String OBJECT_CLASS_PREFIX = "OP_OC_Object";
    public static final ComposedMethodsFactory<IEnviromentInstanceWrapper<Value>> OBJECT_METHODS_FACTORY;
    public static final ComposedMethodsFactory<IEnviromentInstanceWrapper<ManagedEnvironment>> PERIPHERAL_METHODS_FACTORY;

    public static void init() {
        TypeConversionRegistryOC converter = new TypeConversionRegistryOC();
        TypeConvertersProvider.INSTANCE.registerConverter("OpenComputers", converter);
        LuaTypeQualifier.registerType(Value.class, ArgType.OBJECT);
    }

    public static void registerProvider() {
        Driver.add((Block)new DriverOpenPeripheral());
    }

    public static void installAPI(ApiProvider apiProvider) {
        apiProvider.registerClass(AdapterFactoryWrapperOC.class);
    }

    public static Value wrapObject(Object target) {
        Preconditions.checkNotNull((Object)target, (Object)"Can't wrap null");
        IEnviromentInstanceWrapper<Value> wrapper = OBJECT_METHODS_FACTORY.getAdaptedClass(target.getClass());
        return wrapper.isEmpty() ? null : wrapper.createEnvironment(target);
    }

    static {
        MethodSelector peripheralSelector = new MethodSelector("OpenComputers").addDefaultEnv().addProvidedEnv("access", IArchitectureAccess.class).addProvidedEnv("context", Context.class);
        PERIPHERAL_METHODS_FACTORY = new EnvironmentMethodsFactory<ManagedEnvironment>(AdapterRegistry.PERIPHERAL_ADAPTERS, peripheralSelector, PERIPHERAL_CLASS_PREFIX, new PeripheralCodeGenerator());
        InjectedClassesManager.instance.registerProvider(PERIPHERAL_CLASS_PREFIX, new EnvironmentClassBytesProvider(PERIPHERAL_METHODS_FACTORY));
        MethodSelector objectSelector = new MethodSelector("OpenComputers").addDefaultEnv().addProvidedEnv("context", Context.class);
        OBJECT_METHODS_FACTORY = new EnvironmentMethodsFactory<Value>(AdapterRegistry.OBJECT_ADAPTERS, objectSelector, OBJECT_CLASS_PREFIX, new ObjectCodeGenerator());
        InjectedClassesManager.instance.registerProvider(OBJECT_CLASS_PREFIX, new EnvironmentClassBytesProvider(OBJECT_METHODS_FACTORY));
        CommandDump.addArchSerializer("OpenComputers", "peripheral", DocBuilder.TILE_ENTITY_DECORATOR, PERIPHERAL_METHODS_FACTORY);
        CommandDump.addArchSerializer("OpenComputers", "object", DocBuilder.NULL_DECORATOR, OBJECT_METHODS_FACTORY);
    }
}

