/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.interfaces.cc;

import com.google.common.base.Predicate;
import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.ILuaObject;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.util.Map;
import openperipheral.ApiProvider;
import openperipheral.CommandDump;
import openperipheral.adapter.AdapterRegistry;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.ComposedMethodsFactory;
import openperipheral.adapter.composed.IndexedMethodMap;
import openperipheral.adapter.composed.MethodSelector;
import openperipheral.adapter.method.LuaTypeQualifier;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.architecture.IArchitectureAccess;
import openperipheral.converter.TypeConvertersProvider;
import openperipheral.interfaces.cc.TypeConversionRegistryCC;
import openperipheral.interfaces.cc.providers.AdapterFactoryWrapperCC;
import openperipheral.interfaces.cc.providers.PeripheralProvider;
import openperipheral.util.DocBuilder;

public class ModuleComputerCraft {
    public static final ComposedMethodsFactory<IndexedMethodMap> PERIPHERAL_METHODS_FACTORY;
    public static final ComposedMethodsFactory<IndexedMethodMap> OBJECT_METHODS_FACTORY;

    public static void init() {
        TypeConversionRegistryCC converter = new TypeConversionRegistryCC();
        TypeConvertersProvider.INSTANCE.registerConverter("ComputerCraft", converter);
        LuaTypeQualifier.registerType(ILuaObject.class, ArgType.OBJECT);
    }

    public static void registerProvider() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)new PeripheralProvider());
    }

    public static void installAPI(ApiProvider apiProvider) {
        apiProvider.registerClass(AdapterFactoryWrapperCC.class);
    }

    static {
        MethodSelector peripheralSelector = new MethodSelector("ComputerCraft").addDefaultEnv().addProvidedEnv("access", IArchitectureAccess.class).addProvidedEnv("computer", IComputerAccess.class).addProvidedEnv("context", ILuaContext.class);
        PERIPHERAL_METHODS_FACTORY = new ComposedMethodsFactory<IndexedMethodMap>(AdapterRegistry.PERIPHERAL_ADAPTERS, (Predicate)peripheralSelector){

            @Override
            protected IndexedMethodMap wrapMethods(Class<?> targetCls, Map<String, IMethodExecutor> methods) {
                return new IndexedMethodMap(methods);
            }
        };
        MethodSelector objectSelector = new MethodSelector("ComputerCraft").addDefaultEnv().addProvidedEnv("context", ILuaContext.class);
        OBJECT_METHODS_FACTORY = new ComposedMethodsFactory<IndexedMethodMap>(AdapterRegistry.OBJECT_ADAPTERS, (Predicate)objectSelector){

            @Override
            protected IndexedMethodMap wrapMethods(Class<?> targetCls, Map<String, IMethodExecutor> methods) {
                return new IndexedMethodMap(methods);
            }
        };
        CommandDump.addArchSerializer("ComputerCraft", "peripheral", DocBuilder.TILE_ENTITY_DECORATOR, PERIPHERAL_METHODS_FACTORY);
        CommandDump.addArchSerializer("ComputerCraft", "object", DocBuilder.NULL_DECORATOR, OBJECT_METHODS_FACTORY);
    }
}

