/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.converter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import openmods.Log;
import openperipheral.api.converter.IConverter;
import openperipheral.api.converter.IGenericInboundTypeConverter;
import openperipheral.api.converter.IGenericTypeConverter;
import openperipheral.api.converter.IInboundTypeConverter;
import openperipheral.api.converter.IOutboundTypeConverter;
import openperipheral.api.converter.ITypeConverter;
import openperipheral.converter.InboundTypeConverterAdapter;
import openperipheral.converter.inbound.ConverterArrayInbound;
import openperipheral.converter.inbound.ConverterBypass;
import openperipheral.converter.inbound.ConverterEnumInbound;
import openperipheral.converter.inbound.ConverterItemStackInbound;
import openperipheral.converter.inbound.ConverterListInbound;
import openperipheral.converter.inbound.ConverterMapInbound;
import openperipheral.converter.inbound.ConverterNumberInbound;
import openperipheral.converter.inbound.ConverterRawInbound;
import openperipheral.converter.inbound.ConverterSetInbound;
import openperipheral.converter.inbound.ConverterStringInbound;
import openperipheral.converter.inbound.ConverterUuid;
import openperipheral.converter.outbound.ConverterArrayOutbound;
import openperipheral.converter.outbound.ConverterBoolean;
import openperipheral.converter.outbound.ConverterEnumOutbound;
import openperipheral.converter.outbound.ConverterFluidStackOutbound;
import openperipheral.converter.outbound.ConverterFluidTankInfoOutbound;
import openperipheral.converter.outbound.ConverterGameProfileOutbound;
import openperipheral.converter.outbound.ConverterItemStackOutbound;
import openperipheral.converter.outbound.ConverterListOutbound;
import openperipheral.converter.outbound.ConverterMapOutbound;
import openperipheral.converter.outbound.ConverterNumberOutbound;
import openperipheral.converter.outbound.ConverterSetOutbound;
import openperipheral.converter.outbound.ConverterStringOutbound;

public abstract class TypeConverter
implements IConverter {
    protected final Deque<IGenericInboundTypeConverter> inbound = Lists.newLinkedList();
    protected final Deque<IOutboundTypeConverter> outbound = Lists.newLinkedList();
    private final Set<Class<?>> directlyIgnored = Sets.newHashSet();
    private final List<Class<?>> subclassIngored = Lists.newArrayList();

    @Override
    public void registerIgnored(Class<?> ignored, boolean includeSubclasses) {
        (includeSubclasses ? this.subclassIngored : this.directlyIgnored).add(ignored);
    }

    private boolean isIgnored(Class<?> cls) {
        if (this.directlyIgnored.contains(cls)) {
            return true;
        }
        for (Class<?> ignored : this.subclassIngored) {
            if (!ignored.isAssignableFrom(cls)) continue;
            return true;
        }
        return false;
    }

    protected TypeConverter() {
        this.inbound.add(new ConverterRawInbound());
        this.inbound.add(new ConverterItemStackInbound());
        this.inbound.add(new ConverterUuid());
        this.inbound.add(new ConverterNumberInbound());
        this.inbound.add(new ConverterEnumInbound());
        this.inbound.add(new ConverterStringInbound());
        this.inbound.add(new ConverterArrayInbound());
        this.inbound.add(new ConverterListInbound());
        this.inbound.add(new ConverterMapInbound());
        this.inbound.add(new ConverterSetInbound());
        this.inbound.add(new ConverterBypass());
        this.outbound.add(new ConverterBoolean());
        this.outbound.add(new ConverterNumberOutbound());
        this.outbound.add(new ConverterEnumOutbound());
        this.outbound.add(new ConverterArrayOutbound());
        this.outbound.add(new ConverterListOutbound());
        this.outbound.add(new ConverterMapOutbound());
        this.outbound.add(new ConverterSetOutbound());
        this.outbound.add(new ConverterItemStackOutbound());
        this.outbound.add(new ConverterGameProfileOutbound());
        this.outbound.add(new ConverterFluidTankInfoOutbound());
        this.outbound.add(new ConverterFluidStackOutbound());
        this.outbound.add(new ConverterStringOutbound());
    }

    @Override
    public void register(ITypeConverter converter) {
        Log.trace((String)"Registering type converter %s", (Object[])new Object[]{converter});
        this.inbound.addFirst(new InboundTypeConverterAdapter(converter));
        this.outbound.addFirst(converter);
    }

    @Override
    public void register(IGenericTypeConverter converter) {
        Log.trace((String)"Registering generic type converter %s", (Object[])new Object[]{converter});
        this.inbound.addFirst(converter);
        this.outbound.addFirst(converter);
    }

    @Override
    public void register(IInboundTypeConverter converter) {
        this.inbound.addFirst(new InboundTypeConverterAdapter(converter));
    }

    @Override
    public void register(IGenericInboundTypeConverter converter) {
        this.inbound.addFirst(converter);
    }

    @Override
    public void register(IOutboundTypeConverter converter) {
        this.outbound.addFirst(converter);
    }

    @Override
    public Object toJava(Object obj, Type expected) {
        if (obj == null) {
            TypeToken type = TypeToken.of((Type)expected);
            Preconditions.checkArgument((boolean)type.isPrimitive(), (String)"Type %s cannot be nil", (Object[])new Object[]{type});
            return null;
        }
        for (IGenericInboundTypeConverter converter : this.inbound) {
            Object response = converter.toJava(this, obj, expected);
            if (response == null) continue;
            return response;
        }
        TypeToken type = TypeToken.of((Type)expected);
        throw new IllegalArgumentException(String.format("Failed to convert value %s to %s", obj, type.getRawType().getSimpleName()));
    }

    @Override
    public <T> T toJava(Object obj, Class<? extends T> cls) {
        Object result = this.toJava(obj, cls);
        Preconditions.checkArgument((boolean)cls.isInstance(result), (String)"Conversion of %s to type %s failed", (Object[])new Object[]{obj, cls});
        return (T)result;
    }

    @Override
    public Object fromJava(Object obj) {
        if (obj == null || this.isIgnored(obj.getClass())) {
            return obj;
        }
        for (IOutboundTypeConverter converter : this.outbound) {
            Object response = converter.fromJava(this, obj);
            if (response == null) continue;
            return response;
        }
        throw new IllegalArgumentException("Conversion failed on value " + obj);
    }
}

