/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.wrappers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import openmods.Log;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.method.MethodDeclaration;
import openperipheral.adapter.wrappers.MethodMetaExtractor;
import openperipheral.api.adapter.method.ScriptCallable;

public abstract class AdapterWrapper {
    protected final List<IMethodExecutor> methods;
    protected final Class<?> targetClass;
    protected final Class<?> adapterClass;
    protected final String source;
    protected final MethodMetaExtractor metaInfo;

    protected AdapterWrapper(Class<?> adapterClass, Class<?> targetClass, String source) {
        this.adapterClass = adapterClass;
        this.targetClass = targetClass;
        this.source = source;
        this.metaInfo = new MethodMetaExtractor(adapterClass);
        this.methods = ImmutableList.copyOf(this.buildMethodList());
    }

    public String source() {
        return this.source;
    }

    public List<IMethodExecutor> getMethods() {
        return this.methods;
    }

    public Class<?> getAdapterClass() {
        return this.adapterClass;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public abstract boolean canUse(Class<?> var1);

    public abstract String describe();

    public abstract IMethodExecutor createExecutor(Method var1, MethodDeclaration var2);

    protected abstract void verifyArguments(MethodDeclaration var1);

    protected List<IMethodExecutor> buildMethodList() {
        Method[] clsMethods;
        ArrayList result = Lists.newArrayList();
        try {
            clsMethods = this.adapterClass.getDeclaredMethods();
        }
        catch (Throwable t) {
            Log.severe((Throwable)t, (String)"Can't get adapter %s methods (possible sideness fail), bailing out", (Object[])new Object[]{this.adapterClass});
            return result;
        }
        for (Method method : clsMethods) {
            try {
                ScriptCallable callableAnn = method.getAnnotation(ScriptCallable.class);
                if (callableAnn == null) continue;
                MethodDeclaration decl = new MethodDeclaration(method, callableAnn, this.source);
                this.verifyArguments(decl);
                IMethodExecutor exec = this.createExecutor(method, decl);
                result.add(exec);
            }
            catch (Throwable e) {
                throw new MethodWrapException(method, e);
            }
        }
        return result;
    }

    public static class MethodWrapException
    extends RuntimeException {
        private static final long serialVersionUID = -5116134133615320058L;

        public MethodWrapException(Method method, Throwable cause) {
            super(String.format("Failed to wrap method '%s'", method), cause);
        }
    }
}

