/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.composed;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import openperipheral.adapter.IMethodExecutor;
import openperipheral.adapter.composed.IMethodMap;

public class NamedMethodMap
implements IMethodMap {
    private final Map<String, IMethodExecutor> methods;
    private final String[] methodNames;

    public NamedMethodMap(Map<String, IMethodExecutor> methods) {
        this.methods = ImmutableMap.copyOf(methods);
        this.methodNames = methods.keySet().toArray(new String[methods.size()]);
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public IMethodExecutor getMethod(String name) {
        return this.methods.get(name);
    }

    @Override
    public boolean isEmpty() {
        return this.methods.isEmpty();
    }

    @Override
    public int size() {
        return this.methods.size();
    }

    @Override
    public void visitMethods(IMethodMap.IMethodVisitor visitor) {
        for (Map.Entry<String, IMethodExecutor> e : this.methods.entrySet()) {
            visitor.visit(e.getKey(), e.getValue());
        }
    }
}

