/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.LevelEmitterMode;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.util.IConfigManager;
import appeng.core.AELog;
import appeng.util.IConfigManagerHost;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public final class ConfigManager
implements IConfigManager {
    private final Map<Settings, Enum<?>> settings = new EnumMap(Settings.class);
    private final IConfigManagerHost target;

    public ConfigManager(IConfigManagerHost tile) {
        this.target = tile;
    }

    @Override
    public Set<Settings> getSettings() {
        return this.settings.keySet();
    }

    public void registerSetting(Settings settingName, Enum defaultValue) {
        this.settings.put(settingName, defaultValue);
    }

    @Override
    public Enum<?> getSetting(Settings settingName) {
        Enum<?> oldValue = this.settings.get((Object)settingName);
        if (oldValue != null) {
            return oldValue;
        }
        throw new RuntimeException("Invalid Config setting");
    }

    public Enum<?> putSetting(Settings settingName, Enum newValue) {
        Enum<?> oldValue = this.getSetting(settingName);
        this.settings.put(settingName, newValue);
        this.target.updateSetting(this, settingName, newValue);
        return oldValue;
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        for (Settings setting : this.settings.keySet()) {
            tagCompound.func_74778_a(setting.name(), this.settings.get((Object)setting).toString());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound) {
        for (Settings key : this.settings.keySet()) {
            try {
                if (!tagCompound.func_74764_b(key.name())) continue;
                String value = tagCompound.func_74779_i(key.name());
                if (value.equals("EXTACTABLE_ONLY")) {
                    value = StorageFilter.EXTRACTABLE_ONLY.toString();
                } else if (value.equals("STOREABLE_AMOUNT")) {
                    value = LevelEmitterMode.STORABLE_AMOUNT.toString();
                }
                Enum<?> oldValue = this.settings.get((Object)key);
                Object newValue = Enum.valueOf(oldValue.getClass(), value);
                this.putSetting(key, (Enum)newValue);
            }
            catch (IllegalArgumentException e) {
                AELog.error(e);
            }
        }
    }
}

