/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IntegrationNode;
import appeng.integration.IntegrationSide;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import java.util.Collection;
import java.util.LinkedList;

public enum IntegrationRegistry {
    INSTANCE;

    private final Collection<IntegrationNode> modules = new LinkedList<IntegrationNode>();

    public void add(IntegrationType type) {
        if (type.side == IntegrationSide.CLIENT && FMLLaunchHandler.side() == Side.SERVER) {
            return;
        }
        if (type.side == IntegrationSide.SERVER && FMLLaunchHandler.side() == Side.CLIENT) {
            return;
        }
        this.modules.add(new IntegrationNode(type.dspName, type.modID, type, "appeng.integration.modules." + type.name()));
    }

    public void init() {
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.PRE_INIT);
        }
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.INIT);
        }
    }

    public void postInit() {
        for (IntegrationNode node : this.modules) {
            node.Call(IntegrationStage.POST_INIT);
        }
    }

    public String getStatus() {
        StringBuilder builder = new StringBuilder(this.modules.size() * 3);
        for (IntegrationNode node : this.modules) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            String integrationState = (Object)((Object)node.shortName) + ":" + (node.state == IntegrationStage.FAILED ? "OFF" : "ON");
            builder.append(integrationState);
        }
        return builder.toString();
    }

    public boolean isEnabled(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.shortName != name) continue;
            return node.isActive();
        }
        return false;
    }

    public Object getInstance(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.shortName != name || !node.isActive()) continue;
            return node.instance;
        }
        throw new RuntimeException("integration with " + name.name() + " is disabled.");
    }
}

