/*
 * Decompiled with CFR 0.152.
 */
package appeng.fmp;

import appeng.api.implementations.parts.IPartCable;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.LayerFlags;
import appeng.api.parts.PartItemStack;
import appeng.api.parts.SelectedPart;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.fmp.PartRegistry;
import appeng.helpers.AEMultiTile;
import appeng.parts.BusCollisionHelper;
import appeng.parts.CableBusContainer;
import appeng.parts.PartPlacement;
import appeng.tile.networking.TileCableBus;
import appeng.util.Platform;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.JCuboidPart;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.scalatraits.TIInventoryTile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;

public class CableBusPart
extends JCuboidPart
implements JNormalOcclusion,
IRedstonePart,
AEMultiTile {
    public static final ThreadLocal<Boolean> DISABLE_FACADE_OCCLUSION = new ThreadLocal();
    private static final Cuboid6[] SIDE_TESTS = new Cuboid6[]{new Cuboid6(0.375, 0.0, 0.375, 0.625, 0.375, 0.625), new Cuboid6(0.375, 0.625, 0.375, 0.625, 1.0, 0.625), new Cuboid6(0.375, 0.375, 0.0, 0.625, 0.625, 0.375), new Cuboid6(0.375, 0.375, 0.625, 0.625, 0.625, 1.0), new Cuboid6(0.0, 0.375, 0.375, 0.375, 0.625, 0.625), new Cuboid6(0.625, 0.375, 0.375, 1.0, 0.625, 0.625)};
    public CableBusContainer cb = new CableBusContainer(this);
    boolean canUpdate = false;

    @Override
    public boolean recolourBlock(ForgeDirection side, AEColor colour, EntityPlayer who) {
        return this.cb.recolourBlock(side, colour, who);
    }

    public Cuboid6 getBounds() {
        AxisAlignedBB b = null;
        for (AxisAlignedBB bx : this.cb.getSelectedBoundingBoxesFromPool(false, true, null, true)) {
            if (b == null) {
                b = bx;
                continue;
            }
            double minX = Math.min(b.field_72340_a, bx.field_72340_a);
            double minY = Math.min(b.field_72338_b, bx.field_72338_b);
            double minZ = Math.min(b.field_72339_c, bx.field_72339_c);
            double maxX = Math.max(b.field_72336_d, bx.field_72336_d);
            double maxY = Math.max(b.field_72337_e, bx.field_72337_e);
            double maxZ = Math.max(b.field_72334_f, bx.field_72334_f);
            b.func_72324_b(minX, minY, minZ, maxX, maxY, maxZ);
        }
        if (b == null) {
            return new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        return new Cuboid6(b.field_72340_a, b.field_72338_b, b.field_72339_c, b.field_72336_d, b.field_72337_e, b.field_72334_f);
    }

    public String getType() {
        return PartRegistry.CableBusPart.getName();
    }

    public int getLightValue() {
        return this.cb.getLightValue();
    }

    public void onWorldJoin() {
        this.canUpdate = true;
        this.cb.updateConnections();
        this.cb.addToWorld();
    }

    public boolean occlusionTest(TMultiPart part) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)part);
    }

    public boolean renderStatic(Vector3 pos, int pass) {
        if (pass == 0 || pass == 1 && AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            BusRenderHelper.INSTANCE.setPass(pass);
            BusRenderer.INSTANCE.renderer.field_147837_f = true;
            BusRenderer.INSTANCE.renderer.field_147845_a = this.world();
            BusRenderer.INSTANCE.renderer.field_147840_d = null;
            this.cb.renderStatic(pos.x, pos.y, pos.z);
            return BusRenderHelper.INSTANCE.getItemsRendered() > 0;
        }
        return false;
    }

    public void renderDynamic(Vector3 pos, float frame, int pass) {
        if (pass == 0 || pass == 1 && AEConfig.instance.isFeatureEnabled(AEFeature.AlphaPass)) {
            BusRenderHelper.INSTANCE.setPass(pass);
            this.cb.renderDynamic(pos.x, pos.y, pos.z);
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.cb.updateConnections();
    }

    public void onEntityCollision(Entity entity) {
        this.cb.onEntityCollision(entity);
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        return this.cb.activate(player, hit.field_72307_f.func_72441_c((double)(-hit.field_72311_b), (double)(-hit.field_72312_c), (double)(-hit.field_72309_d)));
    }

    public void load(NBTTagCompound tag) {
        this.cb.readFromNBT(tag);
    }

    public void onWorldSeparate() {
        this.canUpdate = false;
        this.cb.removeFromWorld();
    }

    public void save(NBTTagCompound tag) {
        this.cb.writeToNBT(tag);
    }

    public void writeDesc(MCDataOutput packet) {
        ByteBuf stream = Unpooled.buffer();
        try {
            this.cb.writeToStream(stream);
            packet.writeInt(stream.readableBytes());
            stream.capacity(stream.readableBytes());
            packet.writeByteArray(stream.array());
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    public ItemStack pickItem(MovingObjectPosition hit) {
        Vec3 v3 = hit.field_72307_f.func_72441_c((double)(-hit.field_72311_b), (double)(-hit.field_72312_c), (double)(-hit.field_72309_d));
        SelectedPart sp = this.cb.selectPart(v3);
        if (sp != null) {
            if (sp.part != null) {
                return sp.part.getItemStack(PartItemStack.Break);
            }
            if (sp.facade != null) {
                return sp.facade.getItemStack();
            }
        }
        return null;
    }

    public Iterable<ItemStack> getDrops() {
        return this.cb.getDrops(new ArrayList());
    }

    public void onNeighborChanged() {
        this.cb.onNeighborChanged();
    }

    public boolean doesTick() {
        return false;
    }

    public void invalidateConvertedTile() {
        this.cb.setHost(this);
    }

    public void readDesc(MCDataInput packet) {
        int len = packet.readInt();
        byte[] data = packet.readByteArray(len);
        try {
            if (len > 0) {
                ByteBuf byteBuffer = Unpooled.wrappedBuffer((byte[])data);
                this.cb.readFromStream(byteBuffer);
            }
        }
        catch (IOException e) {
            AELog.error(e);
        }
    }

    public boolean canConnectRedstone(int side) {
        return this.cb.canConnectRedstone(EnumSet.of(ForgeDirection.getOrientation((int)side)));
    }

    public int weakPowerLevel(int side) {
        return this.cb.isProvidingWeakPower(ForgeDirection.getOrientation((int)side));
    }

    public int strongPowerLevel(int side) {
        return this.cb.isProvidingStrongPower(ForgeDirection.getOrientation((int)side));
    }

    public void convertFromTile(TileEntity blockTileEntity) {
        TileCableBus tcb = (TileCableBus)blockTileEntity;
        this.cb = tcb.cb;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        LinkedList<Cuboid6> l = new LinkedList<Cuboid6>();
        for (AxisAlignedBB b : this.cb.getSelectedBoundingBoxesFromPool(true, DISABLE_FACADE_OCCLUSION.get() == null, null, true)) {
            l.add(new Cuboid6(b.field_72340_a, b.field_72338_b, b.field_72339_c, b.field_72336_d, b.field_72337_e, b.field_72334_f));
        }
        return l;
    }

    @Override
    public IGridNode getGridNode(ForgeDirection dir) {
        return this.cb.getGridNode(dir);
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection dir) {
        return this.cb.getCableConnectionType(dir);
    }

    @Override
    public void securityBreak() {
        this.cb.securityBreak();
    }

    public int getHollowSize(int side) {
        IPartCable cable = (IPartCable)this.getPart(ForgeDirection.UNKNOWN);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        if (cable != null && cable.isConnected(dir)) {
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            BusCollisionHelper bch = new BusCollisionHelper(boxes, ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH, null, true);
            for (ForgeDirection whichSide : ForgeDirection.values()) {
                IPart fPart = this.getPart(whichSide);
                if (fPart == null) continue;
                fPart.getBoxes(bch);
            }
            AxisAlignedBB b = null;
            AxisAlignedBB pb = Platform.getPrimaryBox(dir, 2);
            for (AxisAlignedBB bb : boxes) {
                if (!bb.func_72326_a(pb)) continue;
                if (b == null) {
                    b = bb;
                    continue;
                }
                b.field_72336_d = Math.max(b.field_72336_d, bb.field_72336_d);
                b.field_72337_e = Math.max(b.field_72337_e, bb.field_72337_e);
                b.field_72334_f = Math.max(b.field_72334_f, bb.field_72334_f);
                b.field_72340_a = Math.min(b.field_72340_a, bb.field_72340_a);
                b.field_72338_b = Math.min(b.field_72338_b, bb.field_72338_b);
                b.field_72339_c = Math.min(b.field_72339_c, bb.field_72339_c);
            }
            if (b == null) {
                return 0;
            }
            switch (dir) {
                case WEST: 
                case EAST: {
                    return this.getSize(b.field_72339_c, b.field_72334_f, b.field_72338_b, b.field_72337_e);
                }
                case DOWN: 
                case NORTH: {
                    return this.getSize(b.field_72340_a, b.field_72336_d, b.field_72339_c, b.field_72334_f);
                }
                case SOUTH: 
                case UP: {
                    return this.getSize(b.field_72340_a, b.field_72336_d, b.field_72338_b, b.field_72337_e);
                }
            }
        }
        return 12;
    }

    int getSize(double a, double b, double c, double d) {
        double r = Math.abs(a - 0.5);
        r = Math.max(Math.abs(b - 0.5), r);
        r = Math.max(Math.abs(c - 0.5), r);
        return 8 * (int)Math.max(Math.abs(d - 0.5), r);
    }

    public int getSlotMask() {
        int mask = 0;
        for (ForgeDirection side : ForgeDirection.values()) {
            if (this.getPart(side) != null) {
                mask |= 1 << side.ordinal();
                continue;
            }
            if (side == ForgeDirection.UNKNOWN || this.getFacadeContainer().getFacade(side) == null) continue;
            mask |= 1 << side.ordinal();
        }
        return mask;
    }

    @Override
    public IFacadeContainer getFacadeContainer() {
        return this.cb.getFacadeContainer();
    }

    @Override
    public boolean canAddPart(ItemStack is, ForgeDirection side) {
        IFacadePart fp = PartPlacement.isFacade(is, side);
        if (fp != null) {
            if (side != null && side != ForgeDirection.UNKNOWN && this.tile() != null) {
                ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                fp.getBoxes(bch, null);
                for (AxisAlignedBB bb : boxes) {
                    DISABLE_FACADE_OCCLUSION.set(true);
                    boolean canAdd = this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(new Cuboid6(bb)));
                    DISABLE_FACADE_OCCLUSION.remove();
                    if (canAdd) continue;
                    return false;
                }
            }
            return true;
        }
        if (is.func_77973_b() instanceof IPartItem) {
            IPartItem bi = (IPartItem)is.func_77973_b();
            is = is.func_77946_l();
            is.field_77994_a = 1;
            IPart bp = bi.createPartFromItemStack(is);
            if (side != null && side != ForgeDirection.UNKNOWN && this.tile() != null) {
                ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
                BusCollisionHelper bch = new BusCollisionHelper(boxes, side, null, true);
                bp.getBoxes(bch);
                for (AxisAlignedBB bb : boxes) {
                    if (this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(new Cuboid6(bb)))) continue;
                    return false;
                }
            }
        }
        return this.cb.canAddPart(is, side);
    }

    @Override
    public ForgeDirection addPart(ItemStack is, ForgeDirection side, EntityPlayer owner) {
        return this.cb.addPart(is, side, owner);
    }

    @Override
    public IPart getPart(ForgeDirection side) {
        return this.cb.getPart(side);
    }

    @Override
    public void removePart(ForgeDirection side, boolean suppressUpdate) {
        this.cb.removePart(side, suppressUpdate);
    }

    @Override
    public void markForUpdate() {
        if (Platform.isServer() && this.canUpdate) {
            this.sendDescUpdate();
        }
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this.tile());
    }

    @Override
    public AEColor getColor() {
        return this.cb.getColor();
    }

    @Override
    public void clearContainer() {
        this.cb = new CableBusContainer(this);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> l = new LinkedList<Cuboid6>();
        for (AxisAlignedBB b : this.cb.getSelectedBoundingBoxesFromPool(false, true, null, true)) {
            l.add(new Cuboid6(b.field_72340_a, b.field_72338_b, b.field_72339_c, b.field_72336_d, b.field_72337_e, b.field_72334_f));
        }
        return l;
    }

    @Override
    public boolean isBlocked(ForgeDirection side) {
        if (side == null || side == ForgeDirection.UNKNOWN || this.tile() == null) {
            return false;
        }
        DISABLE_FACADE_OCCLUSION.set(true);
        boolean blocked = !this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(SIDE_TESTS[side.ordinal()]));
        DISABLE_FACADE_OCCLUSION.remove();
        return blocked;
    }

    @Override
    public SelectedPart selectPart(Vec3 pos) {
        return this.cb.selectPart(pos);
    }

    @Override
    public void markForSave() {
        TileMultipart te = this.tile();
        if (te != null && te.func_145831_w() != null) {
            te.func_145831_w().func_72938_d((int)this.x(), (int)this.z()).field_76643_l = true;
        }
    }

    @Override
    public void partChanged() {
        if (this.isInWorld()) {
            this.notifyNeighbors();
        }
    }

    @Override
    public boolean hasRedstone(ForgeDirection side) {
        return this.cb.hasRedstone(side);
    }

    @Override
    public boolean isEmpty() {
        return this.cb.isEmpty();
    }

    @Override
    public Set<LayerFlags> getLayerFlags() {
        return this.cb.getLayerFlags();
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        LinkedList<IndexedCuboid6> l = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 c : this.getCollisionBoxes()) {
            l.add(new IndexedCuboid6((Object)0, c));
        }
        return l;
    }

    @Override
    public void cleanup() {
        this.tile().remPart((TMultiPart)this);
    }

    @Override
    public void notifyNeighbors() {
        if (this.tile() instanceof TIInventoryTile) {
            ((TIInventoryTile)this.tile()).rebuildSlotMap();
        }
        if (this.world() != null && this.world().func_72899_e(this.x(), this.y(), this.z()) && !CableBusContainer.isLoading()) {
            Platform.notifyBlocksOfNeighbors(this.world(), this.x(), this.y(), this.z());
        }
    }

    @Override
    public boolean isInWorld() {
        return this.cb.isInWorld();
    }
}

