/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridCacheRegistry;
import appeng.core.AELog;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class GridCacheRegistry
implements IGridCacheRegistry {
    private final HashMap<Class<? extends IGridCache>, Class<? extends IGridCache>> caches = new HashMap();

    @Override
    public void registerGridCache(Class<? extends IGridCache> iface, Class<? extends IGridCache> implementation) {
        if (!iface.isAssignableFrom(implementation)) {
            throw new RuntimeException("Invalid setup, grid cache must either be the same class, or an interface that the implementation implements");
        }
        this.caches.put(iface, implementation);
    }

    @Override
    public HashMap<Class<? extends IGridCache>, IGridCache> createCacheInstance(IGrid g) {
        HashMap<Class<? extends IGridCache>, IGridCache> map = new HashMap<Class<? extends IGridCache>, IGridCache>();
        for (Class<? extends IGridCache> iface : this.caches.keySet()) {
            try {
                Constructor<? extends IGridCache> c = this.caches.get(iface).getConstructor(IGrid.class);
                map.put(iface, c.newInstance(g));
            }
            catch (Throwable e) {
                AELog.severe("Grid Caches must have a constructor with IGrid as the single param.", new Object[0]);
                throw new RuntimeException(e);
            }
        }
        return map;
    }
}

