/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Preconditions;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.InventoryUtils;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IAdapterWithConstraints;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.IWorldPosProvider;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
public class AdapterWorldInventory
implements IPeripheralAdapter,
IAdapterWithConstraints {
    private static final int ANY_SLOT = -1;

    public boolean canApply(Class<?> target) {
        return TileEntity.class.isAssignableFrom(target) || IWorldPosProvider.class.isAssignableFrom(target);
    }

    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    public String getSourceId() {
        return "inventory-world";
    }

    private static void checkSlotId(IInventory inventory, int slot, String name) {
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid inventory");
        if (slot != -1) {
            Preconditions.checkElementIndex((int)slot, (int)inventory.func_70302_i_(), (String)(name + " slot id"));
        }
    }

    private static IWorldPosProvider getProvider(IInventory target) {
        if (target instanceof IWorldPosProvider) {
            return (IWorldPosProvider)target;
        }
        if (target instanceof TileEntity) {
            final TileEntity te = (TileEntity)target;
            return new IWorldPosProvider(){

                public boolean isValid() {
                    return !te.func_145837_r();
                }

                public World getWorld() {
                    return te.func_145831_w();
                }

                public int getX() {
                    return te.field_145851_c;
                }

                public int getY() {
                    return te.field_145848_d;
                }

                public int getZ() {
                    return te.field_145849_e;
                }
            };
        }
        throw new IllegalArgumentException("Invalid target object " + String.valueOf(target));
    }

    private static IInventory getNeighborInventory(IInventory target, ForgeDirection direction) {
        Preconditions.checkNotNull((Object)direction, (Object)"Invalid direction");
        Preconditions.checkArgument((direction != ForgeDirection.UNKNOWN ? 1 : 0) != 0, (Object)"Invalid direction");
        IWorldPosProvider provider = AdapterWorldInventory.getProvider(target);
        return InventoryUtils.getInventory((World)provider.getWorld(), (int)provider.getX(), (int)provider.getY(), (int)provider.getZ(), (ForgeDirection)direction);
    }

    @Alias(value={"pullItemIntoSlot"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Pull an item from a slot in another inventory into a slot in this one. Returns the amount of items moved")
    public int pullItem(IInventory target, @Arg(name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(name="slot", description="The slot in the OTHER inventory that you're pulling from") int fromSlot, @Optionals @Arg(name="maxAmount", description="The maximum amount of items you want to pull") Integer maxAmount, @Arg(name="intoSlot", description="The slot in the current inventory that you want to pull into") Integer intoSlot) {
        IInventory otherInventory = AdapterWorldInventory.getNeighborInventory(target, direction);
        Preconditions.checkNotNull((Object)otherInventory, (Object)"Other inventory not found");
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (otherInventory == target) {
            return 0;
        }
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = 0;
        }
        intoSlot = intoSlot - 1;
        AdapterWorldInventory.checkSlotId(otherInventory, --fromSlot, "input");
        AdapterWorldInventory.checkSlotId(thisInventory, intoSlot, "output");
        int amount = ItemDistribution.moveItemInto((IInventory)otherInventory, (int)fromSlot, (IInventory)thisInventory, (int)intoSlot, (int)maxAmount, (ForgeDirection)direction.getOpposite(), (boolean)true);
        if (amount > 0) {
            thisInventory.func_70296_d();
            otherInventory.func_70296_d();
        }
        return amount;
    }

    @Alias(value={"pushItemIntoSlot"})
    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Push an item from the current inventory into slot on the other one. Returns the amount of items moved")
    public int pushItem(IInventory target, @Arg(name="direction", description="The direction of the other inventory. (north, south, east, west, up or down)") ForgeDirection direction, @Arg(name="slot", description="The slot in the current inventory that you're pushing from") int fromSlot, @Optionals @Arg(name="maxAmount", description="The maximum amount of items you want to push") Integer maxAmount, @Arg(name="intoSlot", description="The slot in the other inventory that you want to push into") Integer intoSlot) {
        IInventory otherInventory = AdapterWorldInventory.getNeighborInventory(target, direction);
        Preconditions.checkNotNull((Object)otherInventory, (Object)"Other inventory not found");
        IInventory thisInventory = InventoryUtils.getInventory((IInventory)target);
        if (otherInventory == target) {
            return 0;
        }
        if (maxAmount == null) {
            maxAmount = 64;
        }
        if (intoSlot == null) {
            intoSlot = 0;
        }
        intoSlot = intoSlot - 1;
        AdapterWorldInventory.checkSlotId(thisInventory, --fromSlot, "input");
        AdapterWorldInventory.checkSlotId(otherInventory, intoSlot, "output");
        int amount = ItemDistribution.moveItemInto((IInventory)thisInventory, (int)fromSlot, (IInventory)otherInventory, (int)intoSlot, (int)maxAmount, (ForgeDirection)direction, (boolean)true);
        if (amount > 0) {
            thisInventory.func_70296_d();
            otherInventory.func_70296_d();
        }
        return amount;
    }
}

