/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.vanilla;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.inventory.legacy.ItemDistribution;
import openmods.utils.InventoryUtils;
import openperipheral.api.ApiAccess;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.IPeripheralAdapter;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.ArgType;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;
import openperipheral.api.meta.IItemStackPartialMetaBuilder;

@Asynchronous
public class AdapterInventory
implements IPeripheralAdapter {
    private static final int ANY_SLOT = -1;

    public Class<?> getTargetClass() {
        return IInventory.class;
    }

    public String getSourceId() {
        return "inventory";
    }

    @ScriptCallable(returnTypes={ReturnType.STRING}, description="Get the name of this inventory")
    public String getInventoryName(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_145825_b() : null;
    }

    @ScriptCallable(returnTypes={ReturnType.NUMBER}, description="Get the size of this inventory")
    public int getInventorySize(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        return inventory != null ? inventory.func_70302_i_() : 0;
    }

    @ScriptCallable(description="Condense and tidy the stacks in an inventory")
    public void condenseItems(IInventory target) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        ArrayList stacks = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack sta = inventory.func_70301_a(i);
            if (sta != null) {
                stacks.add(sta.func_77946_l());
            }
            inventory.func_70299_a(i, null);
        }
        for (ItemStack stack : stacks) {
            ItemDistribution.insertItemIntoInventory((IInventory)inventory, (ItemStack)stack, (ForgeDirection)ForgeDirection.UNKNOWN, (int)-1);
        }
        target.func_70296_d();
    }

    @ScriptCallable(description="Swap two slots in the inventory")
    public void swapStacks(IInventory target, @Arg(name="from", description="The first slot") int fromSlot, @Arg(name="to", description="The other slot") int intoSlot, @Optionals @Arg(name="fromDirection") ForgeDirection fromDirection, @Arg(name="fromDirection") ForgeDirection toDirection) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkNotNull((Object)inventory, (Object)"Invalid target!");
        if (inventory instanceof ISidedInventory) {
            InventoryUtils.swapStacks((ISidedInventory)((ISidedInventory)inventory), (int)(fromSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)fromDirection, (Object)ForgeDirection.UNKNOWN)), (int)(intoSlot - 1), (ForgeDirection)((ForgeDirection)Objects.firstNonNull((Object)toDirection, (Object)ForgeDirection.UNKNOWN)));
        } else {
            InventoryUtils.swapStacks((IInventory)inventory, (int)(fromSlot - 1), (int)(intoSlot - 1));
        }
        inventory.func_70296_d();
    }

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Get details of an item in a particular slot")
    public Object getStackInSlot(IInventory target, @Arg(name="slotNumber", description="The slot number, from 1 to the max amount of slots") int slot, @Optionals @Arg(name="proxy", description="If true, method will return proxy instead of computing whole table") Boolean proxy) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)inventory.func_70302_i_(), (String)"slot id");
        ItemStack stack = inventory.func_70301_a(slot);
        return proxy == Boolean.TRUE ? ((IItemStackPartialMetaBuilder)ApiAccess.getApi(IItemStackPartialMetaBuilder.class)).createProxy(stack) : stack;
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get a table with all the items of the chest")
    public Map<Integer, Object> getAllStacks(IInventory target, @Optionals @Arg(name="proxy", description="If false, method will compute whole table, instead of returning proxy") Boolean proxy) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        HashMap result = Maps.newHashMap();
        IItemStackPartialMetaBuilder builder = (IItemStackPartialMetaBuilder)ApiAccess.getApi(IItemStackPartialMetaBuilder.class);
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            result.put(i + 1, proxy != Boolean.FALSE ? builder.createProxy(stack) : stack);
        }
        return result;
    }

    @ScriptCallable(description="Destroy a stack")
    public void destroyStack(IInventory target, @Arg(name="slotNumber", description="The slot number, from 1 to the max amount of slots") int slot) {
        IInventory inventory = InventoryUtils.getInventory((IInventory)target);
        Preconditions.checkElementIndex((int)(--slot), (int)inventory.func_70302_i_(), (String)"slot id");
        inventory.func_70299_a(slot, null);
        inventory.func_70296_d();
    }

    @ScriptCallable(returnTypes={ReturnType.TABLE}, description="Get full stack information from stub one {id=..., [qty=...], [dmg=...]}")
    public ItemStack expandStack(IInventory target, @Arg(name="stack", type=ArgType.TABLE) ItemStack itemStack) {
        return itemStack;
    }
}

