/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.integration.computercraft;

import com.google.common.collect.Maps;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import openmods.reflection.MethodAccess;
import openmods.reflection.ReflectionHelper;
import openperipheral.api.meta.IItemStackMetaProvider;

public class TurtleMetaProvider
implements IItemStackMetaProvider<Object> {
    private final Class<?> CLASS = ReflectionHelper.getClass((String)"dan200.computercraft.shared.turtle.items.ITurtleItem");
    private final MethodAccess.Function1<Integer, ItemStack> GET_FUEL_LEVEL = MethodAccess.create(Integer.TYPE, this.CLASS, ItemStack.class, (String[])new String[]{"getFuelLevel"});
    private final MethodAccess.Function2<ITurtleUpgrade, ItemStack, TurtleSide> GET_UPGRADE = MethodAccess.create(ITurtleUpgrade.class, this.CLASS, ItemStack.class, TurtleSide.class, (String[])new String[]{"getUpgrade"});

    public Class<? extends Object> getTargetClass() {
        return this.CLASS;
    }

    public String getKey() {
        return "turtle";
    }

    public Object getMeta(Object target, ItemStack stack) {
        HashMap map = Maps.newHashMap();
        TurtleMetaProvider.addSideInfo(map, "left", (ITurtleUpgrade)this.GET_UPGRADE.call(target, (Object)stack, (Object)TurtleSide.Left));
        TurtleMetaProvider.addSideInfo(map, "right", (ITurtleUpgrade)this.GET_UPGRADE.call(target, (Object)stack, (Object)TurtleSide.Right));
        int fuelLevel = (Integer)this.GET_FUEL_LEVEL.call(target, (Object)stack);
        map.put("fuel", fuelLevel);
        return map;
    }

    private static void addSideInfo(Map<String, Object> map, String side, ITurtleUpgrade upgrade) {
        if (upgrade != null) {
            HashMap upgradeMap = Maps.newHashMap();
            upgradeMap.put("adjective", upgrade.getUnlocalisedAdjective());
            upgradeMap.put("type", upgrade.getType().toString());
            map.put(side, upgradeMap);
        }
    }
}

