/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Utills {
    public static String formatNumber(double value) {
        if (value < 1000.0) {
            return String.valueOf(value);
        }
        if (value < 1000000.0) {
            return String.valueOf((double)Math.round(value) / 1000.0) + "K";
        }
        if (value < 1.0E9) {
            return String.valueOf((double)Math.round(value / 1000.0) / 1000.0) + "M";
        }
        if (value < 1.0E12) {
            return String.valueOf((double)Math.round(value / 1000000.0) / 1000.0) + "B";
        }
        return String.valueOf((double)Math.round(value / 1.0E9) / 1000.0) + "T";
    }

    public static double getDistanceAtoB(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double getDistanceAtoB(double x1, double z1, double x2, double z2) {
        double dx = x1 - x2;
        double dz = z1 - z2;
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static final boolean isSinglePlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() != null;
    }

    public static final boolean isMultiPlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance() == null;
    }

    public static ItemStack getStackFromName(String name, int meta) {
        if (name.contains("tile.")) {
            name = name.replace("draconicevolution", "DraconicEvolution").replace("tile.", "");
            if (GameData.getBlockRegistry().func_82594_a(name) != null) {
                return new ItemStack((Block)GameData.getBlockRegistry().func_82594_a(name), 1, meta);
            }
        }
        if (name.contains("item.")) {
            name = name.replace("draconicevolution", "DraconicEvolution").replace("item.", "");
            if (GameData.getItemRegistry().func_82594_a(name) != null) {
                return new ItemStack((Item)GameData.getItemRegistry().func_82594_a(name), 1, meta);
            }
        }
        return null;
    }
}

