/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.tileentities.TileParticleGenerator;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileInvisibleMultiblock;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class TileEnergyStorageCore
extends TileObjectSync {
    protected MultiblockHelper.TileLocation[] stabilizers = new MultiblockHelper.TileLocation[4];
    protected int tier = 0;
    protected boolean online = false;
    public float modelRotation = 0.0f;
    private double energy = 0.0;
    private double capacity = 0.0;
    private double lastTickCapacity = 0.0;
    private int tick = 0;

    public TileEnergyStorageCore() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            this.stabilizers[i] = new MultiblockHelper.TileLocation();
        }
    }

    public void func_145845_h() {
        if (!this.online) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.modelRotation = (float)((double)this.modelRotation + 0.5);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.detectAndRendChanges();
        }
        ++this.tick;
    }

    public boolean tryActivate() {
        if (!this.findStabalyzers()) {
            return false;
        }
        if (!this.setTier(false)) {
            return false;
        }
        if (!this.testOrActivateStructureIfValid(false, false)) {
            return false;
        }
        this.online = true;
        if (!this.testOrActivateStructureIfValid(false, true)) {
            this.online = false;
            this.deactivateStabilizers();
            return false;
        }
        this.activateStabilizers();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean creativeActivate() {
        if (!this.findStabalyzers()) {
            return false;
        }
        if (!this.setTier(false)) {
            return false;
        }
        if (!this.testOrActivateStructureIfValid(true, false)) {
            return false;
        }
        this.online = true;
        if (!this.testOrActivateStructureIfValid(false, true)) {
            this.online = false;
            this.deactivateStabilizers();
            return false;
        }
        this.activateStabilizers();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    public boolean isStructureStillValid(boolean update) {
        if (!this.checkStabilizers()) {
            this.online = false;
        }
        if (!this.testOrActivateStructureIfValid(false, false)) {
            this.online = false;
        }
        if (!this.areStabilizersActive()) {
            this.online = false;
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.online) {
            this.deactivateStabilizers();
        }
        if (update && !this.online) {
            this.reIntegrate();
        }
        return this.online;
    }

    private void reIntegrate() {
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
                for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.invisibleMultiblock) continue;
                    if (this.field_145850_b.func_72805_g(x, y, z) == 0) {
                        this.field_145850_b.func_147449_b(x, y, z, (Block)ModBlocks.draconiumBlock);
                        continue;
                    }
                    if (this.field_145850_b.func_72805_g(x, y, z) != 1) continue;
                    this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150451_bX);
                }
            }
        }
    }

    private boolean findStabalyzers() {
        int z;
        int x;
        boolean flag = true;
        for (x = this.field_145851_c; x <= this.field_145851_c + 11; ++x) {
            if (this.field_145850_b.func_147439_a(x, this.field_145848_d, this.field_145849_e) == ModBlocks.particleGenerator) {
                if (this.field_145850_b.func_72805_g(x, this.field_145848_d, this.field_145849_e) == 1) {
                    flag = false;
                    break;
                }
                this.stabilizers[0] = new MultiblockHelper.TileLocation(x, this.field_145848_d, this.field_145849_e);
                break;
            }
            if (x != this.field_145851_c + 11) continue;
            flag = false;
        }
        for (x = this.field_145851_c; x >= this.field_145851_c - 11; --x) {
            if (this.field_145850_b.func_147439_a(x, this.field_145848_d, this.field_145849_e) == ModBlocks.particleGenerator) {
                if (this.field_145850_b.func_72805_g(x, this.field_145848_d, this.field_145849_e) == 1) {
                    flag = false;
                    break;
                }
                this.stabilizers[1] = new MultiblockHelper.TileLocation(x, this.field_145848_d, this.field_145849_e);
                break;
            }
            if (x != this.field_145851_c - 11) continue;
            flag = false;
        }
        for (z = this.field_145849_e; z <= this.field_145849_e + 11; ++z) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, z) == ModBlocks.particleGenerator) {
                if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, z) == 1) {
                    flag = false;
                    break;
                }
                this.stabilizers[2] = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, z);
                break;
            }
            if (z != this.field_145849_e + 11) continue;
            flag = false;
        }
        for (z = this.field_145849_e; z >= this.field_145849_e - 11; --z) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, z) == ModBlocks.particleGenerator) {
                if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, z) == 1) {
                    flag = false;
                    break;
                }
                this.stabilizers[3] = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, z);
                break;
            }
            if (z != this.field_145849_e - 11) continue;
            flag = false;
        }
        return flag;
    }

    private boolean setTier(boolean force) {
        int z;
        int y;
        int x;
        if (force) {
            return true;
        }
        int xPos = 0;
        int xNeg = 0;
        int yPos = 0;
        int yNeg = 0;
        int zPos = 0;
        int zNeg = 0;
        int range = 5;
        for (x = 0; x <= range; ++x) {
            if (!this.testForOrActivateDraconium(this.field_145851_c + x, this.field_145848_d, this.field_145849_e, false, false)) continue;
            xPos = x;
            break;
        }
        for (x = 0; x <= range; ++x) {
            if (!this.testForOrActivateDraconium(this.field_145851_c - x, this.field_145848_d, this.field_145849_e, false, false)) continue;
            xNeg = x;
            break;
        }
        for (y = 0; y <= range; ++y) {
            if (!this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d + y, this.field_145849_e, false, false)) continue;
            yPos = y;
            break;
        }
        for (y = 0; y <= range; ++y) {
            if (!this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d - y, this.field_145849_e, false, false)) continue;
            yNeg = y;
            break;
        }
        for (z = 0; z <= range; ++z) {
            if (!this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d, this.field_145849_e + z, false, false)) continue;
            zPos = z;
            break;
        }
        for (z = 0; z <= range; ++z) {
            if (!this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d, this.field_145849_e - z, false, false)) continue;
            zNeg = z;
            break;
        }
        if (zNeg != zPos || zNeg != yNeg || zNeg != yPos || zNeg != xNeg || zNeg != xPos) {
            return false;
        }
        this.tier = xPos;
        if (this.tier > 1) {
            ++this.tier;
        }
        if (this.tier == 1 && this.testForOrActivateDraconium(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e, false, false)) {
            this.tier = 2;
        }
        return true;
    }

    private boolean testOrActivateStructureIfValid(boolean setBlocks, boolean activate) {
        switch (this.tier) {
            case 0: {
                if (this.testOrActivateRect(1, 1, 1, "air", setBlocks, activate)) break;
                return false;
            }
            case 1: {
                if (!(this.testForOrActivateDraconium(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, setBlocks, activate) && this.testForOrActivateDraconium(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, setBlocks, activate) && this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, setBlocks, activate) && this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, setBlocks, activate) && this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, setBlocks, activate) && this.testForOrActivateDraconium(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, setBlocks, activate))) {
                    return false;
                }
                if (!(this.isReplacable(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e, setBlocks) && this.isReplacable(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e, setBlocks) && this.isReplacable(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, setBlocks) && this.isReplacable(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, setBlocks) && this.isReplacable(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1, setBlocks))) {
                    return false;
                }
                if (this.isReplacable(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e + 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e - 1, setBlocks) && this.isReplacable(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e + 1, setBlocks)) break;
                return false;
            }
            case 2: {
                if (this.testOrActivateRect(1, 1, 1, "draconiumBlock", setBlocks, activate)) break;
                return false;
            }
            case 3: {
                if (!this.testOrActivateSides(1, "draconiumBlock", setBlocks, activate)) {
                    return false;
                }
                if (this.testOrActivateRect(1, 1, 1, "redstone", setBlocks, activate)) break;
                return false;
            }
            case 4: {
                if (!this.testOrActivateSides(2, "draconiumBlock", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(2, 1, 1, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(1, 2, 1, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(1, 1, 2, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (this.testOrActivateRings(2, 2, "draconiumBlock", setBlocks, activate)) break;
                return false;
            }
            case 5: {
                if (!this.testOrActivateSides(3, "draconiumBlock", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateSides(2, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(2, 2, 2, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (this.testOrActivateRings(2, 3, "draconiumBlock", setBlocks, activate)) break;
                return false;
            }
            case 6: {
                if (!this.testOrActivateSides(4, "draconiumBlock", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateSides(3, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(3, 2, 2, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(2, 3, 2, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRect(2, 2, 3, "redstone", setBlocks, activate)) {
                    return false;
                }
                if (!this.testOrActivateRings(2, 4, "draconiumBlock", setBlocks, activate)) {
                    return false;
                }
                if (this.testOrActivateRings(3, 3, "draconiumBlock", setBlocks, activate)) break;
                return false;
            }
        }
        return true;
    }

    private boolean testOrActivateRect(int xDim, int yDim, int zDim, String block, boolean set, boolean activate) {
        for (int x = this.field_145851_c - xDim; x <= this.field_145851_c + xDim; ++x) {
            for (int y = this.field_145848_d - yDim; y <= this.field_145848_d + yDim; ++y) {
                for (int z = this.field_145849_e - zDim; z <= this.field_145849_e + zDim; ++z) {
                    if (block.equals("air")) {
                        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.isReplacable(x, y, z, set)) continue;
                        return false;
                    }
                    if (block.equals("redstone")) {
                        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(x, y, z, set, activate)) continue;
                        return false;
                    }
                    if (block.equals("draconiumBlock")) {
                        if (x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(x, y, z, set, activate)) continue;
                        return false;
                    }
                    if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                    LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                    return false;
                }
            }
        }
        return true;
    }

    private boolean testOrActivateRings(int size, int dist, String block, boolean set, boolean activate) {
        int x;
        int x2;
        int z;
        int y;
        for (y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                if (y != this.field_145848_d - size && y != this.field_145848_d + size && z != this.field_145849_e - size && z != this.field_145849_e + size) continue;
                if (block.equals("air")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.isReplacable(this.field_145851_c + dist, y, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(this.field_145851_c + dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(this.field_145851_c + dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                if (y != this.field_145848_d - size && y != this.field_145848_d + size && z != this.field_145849_e - size && z != this.field_145849_e + size) continue;
                if (block.equals("air")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.isReplacable(this.field_145851_c - dist, y, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(this.field_145851_c - dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(this.field_145851_c - dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (x2 = this.field_145851_c - size; x2 <= this.field_145851_c + size; ++x2) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                if (x2 != this.field_145851_c - size && x2 != this.field_145851_c + size && z != this.field_145849_e - size && z != this.field_145849_e + size) continue;
                if (block.equals("air")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.isReplacable(x2, this.field_145848_d + dist, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(x2, this.field_145848_d + dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(x2, this.field_145848_d + dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (x2 = this.field_145851_c - size; x2 <= this.field_145851_c + size; ++x2) {
            for (z = this.field_145849_e - size; z <= this.field_145849_e + size; ++z) {
                if (x2 != this.field_145851_c - size && x2 != this.field_145851_c + size && z != this.field_145849_e - size && z != this.field_145849_e + size) continue;
                if (block.equals("air")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.isReplacable(x2, this.field_145848_d - dist, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(x2, this.field_145848_d - dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(x2, this.field_145848_d - dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
            for (x = this.field_145851_c - size; x <= this.field_145851_c + size; ++x) {
                if (y != this.field_145848_d - size && y != this.field_145848_d + size && x != this.field_145851_c - size && x != this.field_145851_c + size) continue;
                if (block.equals("air")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.isReplacable(x, y, this.field_145849_e + dist, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.testForOrActivateRedstone(x, y, this.field_145849_e + dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.testForOrActivateDraconium(x, y, this.field_145849_e + dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - size; y <= this.field_145848_d + size; ++y) {
            for (x = this.field_145851_c - size; x <= this.field_145851_c + size; ++x) {
                if (y != this.field_145848_d - size && y != this.field_145848_d + size && x != this.field_145851_c - size && x != this.field_145851_c + size) continue;
                if (block.equals("air")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.isReplacable(x, y, this.field_145849_e - dist, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.testForOrActivateRedstone(x, y, this.field_145849_e - dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.testForOrActivateDraconium(x, y, this.field_145849_e - dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        return true;
    }

    private boolean testOrActivateSides(int dist, String block, boolean set, boolean activate) {
        int x;
        int x2;
        int z;
        int y;
        ++dist;
        for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
            for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (block.equals("air")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.isReplacable(this.field_145851_c + dist, y, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(this.field_145851_c + dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (this.field_145851_c + dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(this.field_145851_c + dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
            for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (block.equals("air")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.isReplacable(this.field_145851_c - dist, y, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(this.field_145851_c - dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (this.field_145851_c - dist == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(this.field_145851_c - dist, y, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (x2 = this.field_145851_c - 1; x2 <= this.field_145851_c + 1; ++x2) {
            for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (block.equals("air")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.isReplacable(x2, this.field_145848_d + dist, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(x2, this.field_145848_d + dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x2 == this.field_145851_c && this.field_145848_d + dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(x2, this.field_145848_d + dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (x2 = this.field_145851_c - 1; x2 <= this.field_145851_c + 1; ++x2) {
            for (z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (block.equals("air")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.isReplacable(x2, this.field_145848_d - dist, z, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateRedstone(x2, this.field_145848_d - dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x2 == this.field_145851_c && this.field_145848_d - dist == this.field_145848_d && z == this.field_145849_e || this.testForOrActivateDraconium(x2, this.field_145848_d - dist, z, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
            for (x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                if (block.equals("air")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.isReplacable(x, y, this.field_145849_e + dist, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.testForOrActivateRedstone(x, y, this.field_145849_e + dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e + dist == this.field_145849_e || this.testForOrActivateDraconium(x, y, this.field_145849_e + dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        for (y = this.field_145848_d - 1; y <= this.field_145848_d + 1; ++y) {
            for (x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
                if (block.equals("air")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.isReplacable(x, y, this.field_145849_e - dist, set)) continue;
                    return false;
                }
                if (block.equals("redstone")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.testForOrActivateRedstone(x, y, this.field_145849_e - dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock")) {
                    if (x == this.field_145851_c && y == this.field_145848_d && this.field_145849_e - dist == this.field_145849_e || this.testForOrActivateDraconium(x, y, this.field_145849_e - dist, set, activate)) continue;
                    return false;
                }
                if (block.equals("draconiumBlock") || block.equals("redstone") || block.equals("air")) continue;
                LogHelper.error("Invalid String In Multiblock Structure Code!!!");
                return false;
            }
        }
        return true;
    }

    private boolean testForOrActivateDraconium(int x, int y, int z, boolean set, boolean activate) {
        if (!activate) {
            if (set) {
                this.field_145850_b.func_147449_b(x, y, z, (Block)ModBlocks.draconiumBlock);
                return true;
            }
            return this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.draconiumBlock || this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.invisibleMultiblock && this.field_145850_b.func_72805_g(x, y, z) == 0;
        }
        return this.activateDraconium(x, y, z);
    }

    private boolean testForOrActivateRedstone(int x, int y, int z, boolean set, boolean activate) {
        if (!activate) {
            if (set) {
                this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150451_bX);
                return true;
            }
            return this.field_145850_b.func_147439_a(x, y, z) == Blocks.field_150451_bX || this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.invisibleMultiblock && this.field_145850_b.func_72805_g(x, y, z) == 1;
        }
        return this.activateRedstone(x, y, z);
    }

    private boolean activateDraconium(int x, int y, int z) {
        if (this.testForOrActivateDraconium(x, y, z, false, false)) {
            TileInvisibleMultiblock tile;
            this.field_145850_b.func_147465_d(x, y, z, (Block)ModBlocks.invisibleMultiblock, 0, 2);
            TileInvisibleMultiblock tileInvisibleMultiblock = tile = this.field_145850_b.func_147438_o(x, y, z) != null && this.field_145850_b.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)this.field_145850_b.func_147438_o(x, y, z) : null;
            if (tile != null) {
                tile.master = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        LogHelper.error("Failed to activate structure (activateDraconium)");
        return false;
    }

    private boolean activateRedstone(int x, int y, int z) {
        if (this.testForOrActivateRedstone(x, y, z, false, false)) {
            TileInvisibleMultiblock tile;
            this.field_145850_b.func_147465_d(x, y, z, (Block)ModBlocks.invisibleMultiblock, 1, 2);
            TileInvisibleMultiblock tileInvisibleMultiblock = tile = this.field_145850_b.func_147438_o(x, y, z) != null && this.field_145850_b.func_147438_o(x, y, z) instanceof TileInvisibleMultiblock ? (TileInvisibleMultiblock)this.field_145850_b.func_147438_o(x, y, z) : null;
            if (tile != null) {
                tile.master = new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            return true;
        }
        LogHelper.error("Failed to activate structure (activateRedstone)");
        return false;
    }

    private boolean isReplacable(int x, int y, int z, boolean set) {
        if (set) {
            this.field_145850_b.func_147449_b(x, y, z, Blocks.field_150350_a);
            return true;
        }
        return this.field_145850_b.func_147439_a(x, y, z).isReplaceable((IBlockAccess)this.field_145850_b, x, y, z) || this.field_145850_b.func_147437_c(x, y, z);
    }

    public boolean isOnline() {
        return this.online;
    }

    private void activateStabilizers() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            TileParticleGenerator tile;
            if (this.stabilizers[i] == null) {
                LogHelper.error("activateStabilizers stabalizers[" + i + "] == null!!!");
                return;
            }
            TileParticleGenerator tileParticleGenerator = tile = this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) != null && this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) instanceof TileParticleGenerator ? (TileParticleGenerator)this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) : null;
            if (tile == null) {
                LogHelper.error("Missing Tile Entity (Particle Generator)");
                return;
            }
            tile.stabalizerMode = true;
            tile.setMaster(new MultiblockHelper.TileLocation(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.field_145850_b.func_72921_c(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord(), 1, 2);
        }
        double capacity = 0.0;
        switch (this.tier) {
            case 0: {
                capacity = 4.55E7;
                break;
            }
            case 1: {
                capacity = 2.73E8;
                break;
            }
            case 2: {
                capacity = 1.64E9;
                break;
            }
            case 3: {
                capacity = 9.88E9;
                break;
            }
            case 4: {
                capacity = 5.93E10;
                break;
            }
            case 5: {
                capacity = 3.56E11;
                break;
            }
            case 6: {
                capacity = 2.14E12;
            }
        }
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
    }

    public void deactivateStabilizers() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            TileParticleGenerator tile;
            if (this.stabilizers[i] == null) {
                LogHelper.error("activateStabilizers stabalizers[" + i + "] == null!!!");
                continue;
            }
            TileParticleGenerator tileParticleGenerator = tile = this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) != null && this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) instanceof TileParticleGenerator ? (TileParticleGenerator)this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) : null;
            if (tile == null) continue;
            tile.stabalizerMode = false;
            this.field_145850_b.func_72921_c(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord(), 0, 2);
        }
    }

    private boolean areStabilizersActive() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            TileParticleGenerator tile;
            if (this.stabilizers[i] == null) {
                LogHelper.error("activateStabilizers stabalizers[" + i + "] == null!!!");
                return false;
            }
            TileParticleGenerator tileParticleGenerator = tile = this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) != null && this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) instanceof TileParticleGenerator ? (TileParticleGenerator)this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) : null;
            if (tile == null) {
                return false;
            }
            if (tile.stabalizerMode && this.field_145850_b.func_72805_g(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) == 1) continue;
            return false;
        }
        return true;
    }

    private boolean checkStabilizers() {
        for (int i = 0; i < this.stabilizers.length; ++i) {
            TileParticleGenerator gen;
            if (this.stabilizers[i] == null) {
                return false;
            }
            TileParticleGenerator tileParticleGenerator = gen = this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) != null && this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) instanceof TileParticleGenerator ? (TileParticleGenerator)this.field_145850_b.func_147438_o(this.stabilizers[i].getXCoord(), this.stabilizers[i].getYCoord(), this.stabilizers[i].getZCoord()) : null;
            if (gen == null || !gen.stabalizerMode) {
                return false;
            }
            if (gen.getMaster().field_145851_c == this.field_145851_c && gen.getMaster().field_145848_d == this.field_145848_d && gen.getMaster().field_145849_e == this.field_145849_e) continue;
            return false;
        }
        return true;
    }

    public int getTier() {
        return this.tier;
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74757_a("Online", this.online);
        compound.func_74777_a("Tier", (short)this.tier);
        compound.func_74780_a("Energy", this.energy);
        for (int i = 0; i < this.stabilizers.length; ++i) {
            if (this.stabilizers[i] == null) continue;
            this.stabilizers[i].writeToNBT(compound, String.valueOf(i));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.online = compound.func_74767_n("Online");
        this.tier = compound.func_74765_d("Tier");
        this.energy = compound.func_74769_h("Energy");
        for (int i = 0; i < this.stabilizers.length; ++i) {
            if (this.stabilizers[i] == null) continue;
            this.stabilizers[i].readFromNBT(compound, String.valueOf(i));
        }
        double capacity = 0.0;
        switch (this.tier) {
            case 0: {
                capacity = 4.55E7;
                break;
            }
            case 1: {
                capacity = 2.73E8;
                break;
            }
            case 2: {
                capacity = 1.64E9;
                break;
            }
            case 3: {
                capacity = 9.88E9;
                break;
            }
            case 4: {
                capacity = 5.93E10;
                break;
            }
            case 5: {
                capacity = 3.56E11;
                break;
            }
            case 6: {
                capacity = 2.14E12;
            }
        }
        this.capacity = capacity;
        if (this.energy > capacity) {
            this.energy = capacity;
        }
        super.func_145839_a(compound);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int maxReceive1 = Integer.MAX_VALUE;
        double energyReceived = Math.min(this.capacity - this.energy, (double)Math.min(maxReceive1, maxReceive));
        if (!simulate) {
            this.energy += energyReceived;
        }
        return (int)energyReceived;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int maxExtract1 = Integer.MAX_VALUE;
        double energyExtracted = Math.min(this.energy, (double)Math.min(maxExtract1, maxExtract));
        if (!simulate) {
            this.energy -= energyExtracted;
        }
        return (int)energyExtracted;
    }

    public double getEnergyStored() {
        return this.energy;
    }

    public double getMaxEnergyStored() {
        return this.capacity;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    private void detectAndRendChanges() {
        int diff = (int)Math.abs(this.lastTickCapacity - this.energy);
        if (diff > 1000) {
            this.lastTickCapacity = (Double)this.sendObject((byte)5, 0, this.energy, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 20.0));
        }
    }

    @Override
    public void receiveObject(int index, Object object) {
        this.energy = (Double)object;
    }
}

