/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.InfoHelper;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.brandon3055.draconicevolution.common.utills.ItemNBTHelper;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import thaumcraft.api.IGoggles;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft")})
public class DraconicArmor
extends ItemArmor
implements ISpecialArmor,
IEnergyContainerItem,
IConfigurableItem,
IInventoryTool,
IGoggles,
IRevealer {
    private IIcon helmIcon;
    private IIcon chestIcon;
    private IIcon leggsIcon;
    private IIcon bootsIcon;
    private double totalAbsorption = 2.0;
    private int maxTransfer = 50000;
    private int maxEnergy = 10000000;
    private int energyPerDamage = 80;

    public DraconicArmor(ItemArmor.ArmorMaterial material, int armorType, String name) {
        super(material, 0, armorType);
        this.func_77655_b(name);
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)name);
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        list.add(ItemNBTHelper.setInteger(new ItemStack(item), "Energy", 0));
        list.add(ItemNBTHelper.setInteger(new ItemStack(item), "Energy", this.maxEnergy));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.helmIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_helmet");
        this.chestIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_chestplate");
        this.leggsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_leggings");
        this.bootsIcon = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_boots");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            return this.helmIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicChest) {
            return this.chestIcon;
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs) {
            return this.leggsIcon;
        }
        return this.bootsIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (stack.func_77973_b() == ModItems.draconicHelm || stack.func_77973_b() == ModItems.draconicChest || stack.func_77973_b() == ModItems.draconicBoots) {
            return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_1.png";
        }
        return References.RESOURCESPREFIX + "textures/models/armor/draconic_layer_2.png";
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        return EnumRarity.epic;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)ItemNBTHelper.getInteger(stack, "Energy", 0) / (double)this.maxEnergy;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) < this.maxEnergy;
    }

    protected double getAbsorptionPercent() {
        switch (this.field_77881_a) {
            case 0: {
                return 0.15;
            }
            case 1: {
                return 0.4;
            }
            case 2: {
                return 0.3;
            }
            case 3: {
                return 0.15;
            }
        }
        return 0.0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        int maxAbsorption = 25 * this.getEnergyStored(armor) / this.energyPerDamage;
        if (source.field_76373_n.equals(DamageSource.field_76379_h.field_76373_n) && armor.func_77973_b() == ModItems.draconicBoots) {
            return new ISpecialArmor.ArmorProperties(0, 1.0, maxAbsorption);
        }
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, this.getAbsorptionPercent() * this.totalAbsorption / 2.0, maxAbsorption);
        }
        return new ISpecialArmor.ArmorProperties(0, this.getAbsorptionPercent() * this.totalAbsorption, maxAbsorption);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.getEnergyStored(armor) > 10000 ? (int)(this.getAbsorptionPercent() * 20.0) : (int)((float)this.getEnergyStored(armor) / 10000.0f * (float)(this.getAbsorptionPercent() * 20.0));
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        this.extractEnergy(stack, damage * this.energyPerDamage, false);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.func_77973_b() == ModItems.draconicHelm) {
            if (world.field_72995_K) {
                return;
            }
            if (this.getEnergyStored(stack) >= 5000 && this.clearNegativeEffects((Entity)player)) {
                this.extractEnergy(stack, 5000, false);
            }
            if (player.field_70170_p.func_72957_l((int)Math.floor(player.field_70165_t), (int)player.field_70163_u, (int)Math.floor(player.field_70161_v)) < 5 && ItemNBTHelper.getBoolean(stack, "ArmorNVActive", false)) {
                player.func_70690_d(new PotionEffect(16, 419, 0, true));
            } else if (ItemNBTHelper.getBoolean(stack, "ArmorNVActive", false) && ItemNBTHelper.getBoolean(stack, "ArmorNVLock", false)) {
                player.func_70690_d(new PotionEffect(16, 419, 0, true));
            } else if (player.func_82165_m(16)) {
                player.func_82170_o(16);
            }
        }
        if (stack.func_77973_b() == ModItems.draconicLeggs && player.func_70051_ag() && !player.field_71075_bZ.field_75098_d) {
            this.extractEnergy(stack, player.field_71075_bZ.field_75100_b ? 160 : 80, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer par2EntityPlayer, List list, boolean par4) {
        InfoHelper.addEnergyAndLore(stack, list);
    }

    public boolean clearNegativeEffects(Entity par3Entity) {
        boolean flag = false;
        if (par3Entity.field_70173_aa % 20 == 0 && par3Entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)par3Entity;
            Collection potions = player.func_70651_bq();
            if (player.func_70027_ad()) {
                player.func_70066_B();
                flag = true;
            } else {
                for (PotionEffect potion : potions) {
                    int id = potion.func_76456_a();
                    if (!((Boolean)ReflectionHelper.getPrivateValue(Potion.class, (Object)Potion.field_76425_a[id], (String[])new String[]{"isBadEffect", "field_76418_K", "J"})).booleanValue()) continue;
                    if (player.func_70694_bm() != null && (player.func_70694_bm().func_77973_b() == ModItems.wyvernBow || player.func_70694_bm().func_77973_b() == ModItems.draconicBow) && id == 2) break;
                    player.func_82170_o(id);
                    flag = true;
                    break;
                }
            }
        }
        return flag;
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        int stored = ItemNBTHelper.getInteger(container, "Energy", 0);
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            ItemNBTHelper.setInteger(container, "Energy", stored += receive);
        }
        return receive;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        int stored = ItemNBTHelper.getInteger(container, "Energy", 0);
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            ItemNBTHelper.setInteger(container, "Energy", stored -= extract);
        }
        return extract;
    }

    @Override
    public int getEnergyStored(ItemStack container) {
        return ItemNBTHelper.getInteger(container, "Energy", 0);
    }

    @Override
    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> list = new ArrayList<ItemConfigField>();
        if (this.field_77881_a == 0) {
            list.add(new ItemConfigField(6, slot, "ArmorNVActive").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorNVLock").readFromItem(stack, false));
        } else if (this.field_77881_a == 1) {
            list.add(new ItemConfigField(6, slot, "ArmorFlightLock").readFromItem(stack, false));
        } else if (this.field_77881_a == 2) {
            list.add(new ItemConfigField(4, slot, "ArmorSpeedMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.01f)).readFromItem(stack, Float.valueOf(1.0f)));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
        } else if (this.field_77881_a == 3) {
            list.add(new ItemConfigField(4, slot, "ArmorJumpMult").setMinMaxAndIncromente(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.01f)).readFromItem(stack, Float.valueOf(1.0f)));
            list.add(new ItemConfigField(6, slot, "ArmorSprintOnly").readFromItem(stack, false));
            list.add(new ItemConfigField(6, slot, "ArmorHillStep").readFromItem(stack, true));
        }
        return list;
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.armor || this.field_77881_a == 0 && enchant.field_77351_y == EnumEnchantmentType.armor_head || this.field_77881_a == 1 && enchant.field_77351_y == EnumEnchantmentType.armor_torso || this.field_77881_a == 2 && enchant.field_77351_y == EnumEnchantmentType.armor_legs || this.field_77881_a == 3 && enchant.field_77351_y == EnumEnchantmentType.armor_feet;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }
}

