/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.inventory;

import com.brandon3055.draconicevolution.common.container.ContainerAdvTool;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;

public class InventoryTool
implements IInventory {
    public int size;
    public ItemStack inventoryItem;
    private ItemStack[] inventoryStacks;
    private EntityPlayer player;
    private ContainerAdvTool container;
    private int slot = -1;

    public InventoryTool(EntityPlayer player, ItemStack stack) {
        this.inventoryItem = stack;
        this.player = player;
        if (stack != null && stack.func_77973_b() instanceof IInventoryTool) {
            this.size = ((IInventoryTool)stack.func_77973_b()).getInventorySlots();
            this.readFromNBT(ItemNBTHelper.getCompound(this.inventoryItem));
        }
        this.inventoryStacks = new ItemStack[this.size + 5];
    }

    public void setAndReadFromStack(ItemStack stack, int slot) {
        this.slot = slot;
        this.inventoryItem = stack;
        this.size = ((IInventoryTool)stack.func_77973_b()).getInventorySlots();
        this.inventoryStacks = new ItemStack[this.size + 5];
        this.readFromNBT(ItemNBTHelper.getCompound(this.inventoryItem));
    }

    public void setContainer(ContainerAdvTool container) {
        this.container = container;
    }

    public int func_70302_i_() {
        return this.inventoryStacks.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventoryStacks[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
        }
        return item;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventoryStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.inventoryItem != null && this.inventoryItem.func_77973_b() instanceof IInventoryTool ? (!StringUtils.func_151246_b((String)((IInventoryTool)this.inventoryItem.func_77973_b()).getInventoryName()) ? ((IInventoryTool)this.inventoryItem.func_77973_b()).getInventoryName() : "") : "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null || this.func_70301_a((int)i).field_77994_a != 0) continue;
            this.inventoryStacks[i] = null;
        }
        if (this.player.func_70005_c_().equals("brandon3055")) {
            this.player.func_146105_b((IChatComponent)new ChatComponentText("markDirty " + this.inventoryItem + (this.player.field_70170_p.field_72995_K ? ":client" : ":server")));
        }
        if (this.inventoryItem != null) {
            this.writeToNBT(ItemNBTHelper.getCompound(this.inventoryItem));
            this.readFromNBT(ItemNBTHelper.getCompound(this.inventoryItem));
        } else {
            LogHelper.error("[InventoryItem] storage item == null This is not a good thing...");
            if (this.player.func_70005_c_().equals("brandon3055")) {
                this.player.func_146105_b((IChatComponent)new ChatComponentText("[InventoryItem] storage item == null " + (this.player.field_70170_p.field_72995_K ? ":client" : ":server")));
            }
        }
        this.container.func_75142_b();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.size];
        NBTTagList enchList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (i < this.size) {
                tag[i] = new NBTTagCompound();
                if (this.inventoryStacks[i] != null) {
                    tag[i] = this.inventoryStacks[i].func_77955_b(tag[i]);
                }
                compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
            } else if (this.inventoryStacks[i] != null) {
                if (this.inventoryStacks[i].func_77978_p() == null) {
                    this.inventoryStacks[i] = null;
                } else {
                    enchList.func_74742_a((NBTBase)this.inventoryStacks[i].func_77978_p().func_150295_c("StoredEnchantments", 10).func_150305_b(0));
                }
            }
            compound.func_74782_a("ench", (NBTBase)enchList);
        }
        if (compound.func_74764_b("ench") && compound.func_150295_c("ench", 10).func_74745_c() == 0) {
            compound.func_82580_o("ench");
        }
        if (this.player.func_70005_c_().equals("brandon3055")) {
            this.player.func_146105_b((IChatComponent)new ChatComponentText("writeToNBT " + (this.player.field_70170_p.field_72995_K ? ":client" : ":server") + " Tag:" + compound));
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (this.player.func_70005_c_().equals("brandon3055")) {
            this.player.func_146105_b((IChatComponent)new ChatComponentText("readFromNBT " + (this.player.field_70170_p.field_72995_K ? ":client" : ":server") + " Tag:" + compound));
        }
        NBTTagCompound[] tag = new NBTTagCompound[this.size];
        NBTTagList enchList = null;
        if (compound.func_74764_b("ench")) {
            enchList = compound.func_150295_c("ench", 10);
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.inventoryStacks[i] = null;
            if (i < this.size) {
                tag[i] = compound.func_74775_l("Item" + i);
                this.inventoryStacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
                continue;
            }
            if (enchList == null || enchList.func_74745_c() <= i - this.size) continue;
            this.inventoryStacks[i] = new ItemStack((Item)Items.field_151134_bR);
            this.inventoryStacks[i].func_77982_d(new NBTTagCompound());
            NBTTagList list = new NBTTagList();
            list.func_74742_a((NBTBase)enchList.func_150305_b(i - this.size));
            this.inventoryStacks[i].func_77978_p().func_74782_a("StoredEnchantments", (NBTBase)list);
        }
        if (compound.func_74764_b("ench") && compound.func_150295_c("ench", 10).func_74745_c() == 0) {
            compound.func_82580_o("ench");
        }
    }
}

