/*
 * Decompiled with CFR 0.152.
 */
package fox.spiteful.forbidden.tiles;

import fox.spiteful.forbidden.Config;
import fox.spiteful.forbidden.DarkAspects;
import fox.spiteful.forbidden.tiles.WrathSpawnerLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TileEntityWrathCage
extends TileEntity
implements IAspectContainer,
IEssentiaTransport {
    private final WrathSpawnerLogic spawnLogic = new WrathSpawnerLogic(this);
    public int wrath = 0;
    public int sloth = 0;
    public int special = 0;
    public byte mode = 0;
    Aspect aspect = Aspect.GREED;

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.spawnLogic.readFromNBT(par1NBTTagCompound);
        this.wrath = par1NBTTagCompound.func_74765_d("Wrath");
        this.sloth = par1NBTTagCompound.func_74765_d("Sloth");
        this.special = par1NBTTagCompound.func_74765_d("Special");
        this.mode = par1NBTTagCompound.func_74771_c("Mode");
        this.aspect = this.spawnLogic.getAspect();
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.spawnLogic.writeToNBT(par1NBTTagCompound);
        par1NBTTagCompound.func_74777_a("Wrath", (short)this.wrath);
        par1NBTTagCompound.func_74777_a("Sloth", (short)this.sloth);
        par1NBTTagCompound.func_74777_a("Special", (short)this.special);
        par1NBTTagCompound.func_74774_a("Mode", this.mode);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            this.spawnLogic.updateSpawner();
        }
        if (Config.wrathCost > 0 && this.spawnLogic.isMobSet() && this.special < 64 && this.wrath < 64 && this.sloth < 64) {
            this.drawEssentia();
        }
        super.func_145845_h();
    }

    void drawEssentia() {
        for (int x = 0; x < ForgeDirection.VALID_DIRECTIONS.length; ++x) {
            ForgeDirection current = ForgeDirection.VALID_DIRECTIONS[x];
            TileEntity te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)current);
            if (te == null) continue;
            IEssentiaTransport ic = (IEssentiaTransport)te;
            if (ic.canOutputTo(current.getOpposite()) && this.special < 64 && ic.getEssentiaType(current.getOpposite()) == this.aspect && ic.getEssentiaAmount(current.getOpposite()) > 0 && ic.takeEssentia(this.aspect, 1, current.getOpposite()) == 1) {
                ++this.special;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (ic.canOutputTo(current.getOpposite()) && this.wrath < 64 && this.special < Config.wrathCost && ic.getEssentiaType(current.getOpposite()) == DarkAspects.WRATH && ic.getEssentiaAmount(current.getOpposite()) > 0 && ic.takeEssentia(DarkAspects.WRATH, 1, current.getOpposite()) == 1) {
                ++this.wrath;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                return;
            }
            if (!ic.canOutputTo(current.getOpposite()) || this.sloth >= 64 || this.special >= Config.wrathCost || this.wrath >= Config.wrathCost || ic.getEssentiaType(current.getOpposite()) != DarkAspects.SLOTH || ic.getEssentiaAmount(current.getOpposite()) <= 0 || ic.takeEssentia(DarkAspects.SLOTH, 1, current.getOpposite()) != 1) continue;
            ++this.sloth;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return;
        }
    }

    public void checkAspect() {
        if (this.aspect != this.spawnLogic.getAspect()) {
            this.special = 0;
        }
        this.aspect = this.spawnLogic.getAspect();
    }

    public boolean func_145842_c(int par1, int x) {
        return this.spawnLogic.setDelayToMin(par1) ? true : super.func_145842_c(par1, x);
    }

    public WrathSpawnerLogic getSpawnerLogic() {
        return this.spawnLogic;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (Config.wrathCost > 0 && this.spawnLogic.isMobSet()) {
            if (this.mode == 0) {
                list.add(this.aspect, this.special);
            } else if (this.mode == 1) {
                list.add(DarkAspects.WRATH, this.wrath);
            } else {
                list.add(DarkAspects.SLOTH, this.sloth);
            }
        }
        return list;
    }

    public void setAspects(AspectList aspects) {
    }

    public boolean doesContainerAccept(Aspect tag) {
        if (Config.wrathCost <= 0) {
            return false;
        }
        return tag == DarkAspects.WRATH || tag == DarkAspects.SLOTH || tag == this.aspect;
    }

    public int addToContainer(Aspect tag, int amount) {
        if (Config.wrathCost <= 0) {
            return amount;
        }
        if (tag == DarkAspects.WRATH) {
            this.wrath += amount;
            return 0;
        }
        if (tag == DarkAspects.SLOTH) {
            this.sloth += amount;
            return 0;
        }
        if (tag == this.aspect) {
            this.special += amount;
            return 0;
        }
        return amount;
    }

    public boolean takeFromContainer(Aspect tag, int amount) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect tag, int amount) {
        if (tag == DarkAspects.WRATH) {
            return this.wrath >= amount;
        }
        if (tag == DarkAspects.SLOTH) {
            return this.sloth >= amount;
        }
        if (tag == this.aspect) {
            return this.special >= amount;
        }
        return false;
    }

    public int containerContains(Aspect tag) {
        if (tag == DarkAspects.WRATH) {
            return this.wrath;
        }
        if (tag == DarkAspects.SLOTH) {
            return this.sloth;
        }
        if (tag == this.aspect) {
            return this.special;
        }
        return 0;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList ot) {
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList ot) {
        return false;
    }

    public boolean isConnectable(ForgeDirection face) {
        return Config.wrathCost > 0;
    }

    public boolean canInputFrom(ForgeDirection face) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection face) {
        return false;
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public Aspect getSuctionType(ForgeDirection face) {
        if (Config.wrathCost <= 0) {
            return null;
        }
        if (this.mode == 0) {
            return this.aspect;
        }
        if (this.mode == 1) {
            return DarkAspects.WRATH;
        }
        return DarkAspects.SLOTH;
    }

    public int getSuctionAmount(ForgeDirection face) {
        if (Config.wrathCost > 0) {
            return 256;
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection dir) {
        return 0;
    }

    public int addEssentia(Aspect inp, int amount, ForgeDirection dir) {
        if (inp == this.aspect) {
            this.special += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        if (inp == DarkAspects.WRATH) {
            this.wrath += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        if (inp == DarkAspects.SLOTH) {
            this.sloth += Math.min(amount, 64);
            return Math.min(amount, 64);
        }
        return amount;
    }

    public Aspect getEssentiaType(ForgeDirection face) {
        return this.getSuctionType(face);
    }

    public int getEssentiaAmount(ForgeDirection face) {
        if (this.mode == 0) {
            return this.special;
        }
        if (this.mode == 1) {
            return this.wrath;
        }
        return this.sloth;
    }

    public int getMinimumSuction() {
        return 9000;
    }

    public boolean renderExtendedTube() {
        return false;
    }
}

